# 機能設計書 48-Material

## 概要

本ドキュメントは、Three.jsライブラリにおけるマテリアル（材質）の抽象基底クラスであるMaterialクラスの機能設計を記述する。

### 本機能の処理概要

Materialは、3Dオブジェクトの視覚的外観を定義するすべてのマテリアルクラスの抽象基底クラスである。ブレンディング、深度テスト、ステンシルテスト、クリッピング、透過性など、レンダリングに関する共通のプロパティとメソッドを提供する。

**業務上の目的・背景**：3Dグラフィックスにおいて、マテリアルはジオメトリの見た目を決定する重要な要素である。色、テクスチャ、反射、透過などの属性を統一的に管理するため、基底クラスとして共通の機能を提供することで、派生マテリアルクラス（MeshBasicMaterial、MeshStandardMaterialなど）の実装を簡素化し、一貫性のあるAPIを提供する。

**機能の利用シーン**：
- すべてのマテリアルの基底クラスとして機能
- ブレンディング設定の管理（加算、乗算、アルファブレンドなど）
- 深度テスト・書き込みの制御
- ステンシル操作の設定
- クリッピングプレーンの管理
- 透過性とアルファテストの制御

**主要な処理内容**：
1. 一意のID・UUIDの生成と管理
2. ブレンディングパラメータの設定
3. 深度テスト・ステンシルテストの設定
4. クリッピングプレーンの管理
5. シリアライズ/デシリアライズ（toJSON）
6. マテリアルのコピー・クローン
7. イベントの発行（dispose等）

**関連システム・外部連携**：EventDispatcher、Color、Renderer、Meshなど

**権限による制御**：なし（クライアントサイドのJavaScriptライブラリのため）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | Sidebar - Material | 主機能 | 選択オブジェクトのマテリアル編集 |
| 21 | WebGL基本サンプル | 補助機能 | マテリアルの設定 |
| 36 | Material Browser | 主機能 | 各種マテリアルのプレビュー |

## 機能種別

基底クラス / プロパティ管理

## 入力仕様

### 入力パラメータ

Materialの基底クラスはパラメータを受け取らない。派生クラスがパラメータオブジェクトを受け取り、setValuesメソッドで設定する。

### 入力データソース

コンストラクタ引数として直接渡される（派生クラスで使用）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | number | 一意の識別子（自動生成） |
| uuid | string | UUID（generateUUIDで生成） |
| name | string | マテリアル名 |
| type | string | マテリアルタイプ |
| version | number | 更新カウンタ |

### 出力先

レンダラーがマテリアルプロパティを読み取りシェーダーに反映する。

## 処理フロー

### 処理シーケンス

```
1. EventDispatcherの初期化
   └─ super()を呼び出し
2. 識別子の生成
   └─ id（自動インクリメント）、uuid（generateUUID）
3. デフォルトプロパティの設定
   └─ ブレンディング、深度、ステンシル、クリッピング等
4. 派生クラスでのパラメータ適用
   └─ setValues()でオブジェクトからプロパティを設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[EventDispatcher初期化]
    B --> C[id生成: _materialId++]
    C --> D[uuid生成: generateUUID]
    D --> E[デフォルトプロパティ設定]
    E --> F{派生クラスでsetValues呼び出し?}
    F -->|Yes| G[パラメータからプロパティを設定]
    F -->|No| H[終了]
    G --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | ID自動生成 | _materialIdをインクリメントしてidを設定 | コンストラクタ実行時 |
| BR-002 | UUID生成 | generateUUID()でuuidを設定 | コンストラクタ実行時 |
| BR-003 | バージョン管理 | needsUpdate=trueでversionをインクリメント | needsUpdate設定時 |
| BR-004 | alphaTest変更 | alphaTestの変更でversionをインクリメント | alphaTest設定時 |
| BR-005 | イベント発行 | disposeでdisposeイベントを発行 | dispose呼び出し時 |

### 計算ロジック

特になし（プロパティ管理が主）

## データベース操作仕様

該当なし（クライアントサイド処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | setValuesで未定義パラメータ | コンソールに警告を出力 |
| - | 警告 | setValuesで存在しないプロパティ | コンソールに警告を出力 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（クライアントサイド処理のみ）

## パフォーマンス要件

- versionの変更でシェーダーの再コンパイルが発生する可能性
- 大量のマテリアルはGPUメモリを消費

## セキュリティ考慮事項

該当なし（クライアントサイドのマテリアル管理処理）

## 備考

- Materialは抽象基底クラスとして設計されており、直接インスタンス化することは推奨されない
- JSON形式でのシリアライズに対応（toJSONメソッド）
- disposeメソッドでGPUリソースを解放

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Materialが継承するEventDispatcherと依存するクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | EventDispatcher.js | `src/core/EventDispatcher.js` | イベント発行・購読の仕組み |
| 1-2 | Color.js | `src/math/Color.js` | カラー管理クラス |
| 1-3 | constants.js | `src/constants.js` | ブレンディング・深度等の定数 |

**読解のコツ**: Materialは多数のプロパティを持つため、グループごとに理解するとよい（ブレンディング、深度、ステンシル、クリッピング）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Material.js | `src/materials/Material.js` | コンストラクタのプロパティ定義 |

**主要処理フロー**:
1. **22-25行目**: EventDispatcher継承、isMaterialフラグ
2. **42行目**: id設定（_materialIdインクリメント）
3. **50行目**: uuid設定（generateUUID）
4. **66行目**: type設定（'Material'）
5. **78-201行目**: ブレンディングプロパティ群
6. **209-297行目**: 深度・ステンシルプロパティ群
7. **299-340行目**: クリッピングプロパティ群
8. **464-473行目**: versionとneedsUpdate管理

#### Step 3: setValuesメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Material.js | `src/materials/Material.js` | setValuesメソッド |

**主要処理フロー**:
- **555-595行目**: setValuesメソッド
- **559-567行目**: undefined値の警告
- **570-576行目**: 存在しないプロパティの警告
- **579-591行目**: Color/Vector3のコピー処理

#### Step 4: toJSONメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Material.js | `src/materials/Material.js` | toJSONメソッド |

**主要処理フロー**:
- **604-882行目**: toJSONメソッド
- **617-623行目**: メタデータ生成
- **631-850行目**: 各プロパティのシリアライズ

### プログラム呼び出し階層図

```
Material.constructor()
    │
    ├─ EventDispatcher.constructor()
    │
    ├─ generateUUID()
    │      └─ UUID文字列生成
    │
    └─ プロパティ初期化
           ├─ ブレンディング設定
           ├─ 深度設定
           ├─ ステンシル設定
           └─ クリッピング設定

Material.setValues(parameters)
    │
    └─ プロパティへの値設定
           ├─ Color.set() / Color.copy()
           └─ Vector3.copy()

Material.toJSON(meta)
    │
    └─ プロパティのシリアライズ
           └─ Texture.toJSON()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

parameters ─────────────▶ Material.setValues()
                               │
                               │ プロパティ検証
                               │ 値の設定
                               ▼
                    ┌─────────────────────┐
                    │ Material            │
                    │  - id/uuid          │
                    │  - blending設定     │
                    │  - depth設定        │ ────▶ Rendererで使用
                    │  - stencil設定      │
                    │  - clipping設定     │
                    │  - version          │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Material.js | `src/materials/Material.js` | ソース | マテリアル基底クラス |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベントシステム |
| Color.js | `src/math/Color.js` | ソース | カラー管理 |
| MathUtils.js | `src/math/MathUtils.js` | ソース | generateUUID関数 |
| constants.js | `src/constants.js` | ソース | ブレンディング等の定数 |
| MeshBasicMaterial.js | `src/materials/MeshBasicMaterial.js` | ソース | 派生マテリアル |
| MeshStandardMaterial.js | `src/materials/MeshStandardMaterial.js` | ソース | 派生マテリアル |
