# 機能設計書 49-MeshBasicMaterial

## 概要

本ドキュメントは、Three.jsライブラリにおけるライティング不要の基本マテリアルであるMeshBasicMaterialクラスの機能設計を記述する。

### 本機能の処理概要

MeshBasicMaterialは、ライティング計算を行わないシンプルなマテリアルクラスである。フラットシェーディングまたはワイヤーフレームモードでジオメトリを描画し、環境マップやライトマップなどのテクスチャ機能をサポートする。光源の影響を受けないため、一定の色で描画される。

**業務上の目的・背景**：3Dグラフィックスにおいて、ライティング計算を必要としない場面は多く存在する。UI要素、デバッグ表示、スタイライズドグラフィックス、パフォーマンス優先のシーンなどでMeshBasicMaterialが活用される。シンプルな計算モデルのため、他のマテリアルよりも高速に描画できる。

**機能の利用シーン**：
- UIパネルやオーバーレイの描画
- デバッグ用のビジュアライゼーション
- スタイライズド（非リアリスティック）レンダリング
- ライティングを使用しない2Dライクな表現
- 環境マップによる反射表現
- パフォーマンスが重要なシーン

**主要な処理内容**：
1. 基本色（diffuse color）の設定
2. カラーマップ（テクスチャ）の適用
3. ライトマップ・AOマップの適用
4. 環境マップとリフレクション設定
5. ワイヤーフレームモードの制御
6. フォグへの反応設定

**関連システム・外部連携**：Material（親クラス）、Texture、Color、Euler、Meshなど

**権限による制御**：なし（クライアントサイドのJavaScriptライブラリのため）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | Sidebar - Material | 補助機能 | 基本マテリアルタイプの設定 |
| 36 | Material Browser | 主機能 | 基本マテリアルのプレビュー |

## 機能種別

マテリアル設定 / レンダリング外観

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| parameters | Object | No | マテリアルプロパティを定義するオブジェクト | - |
| parameters.color | Color/number/string | No | 基本色 | デフォルト: 0xffffff |
| parameters.map | Texture | No | カラーマップテクスチャ | デフォルト: null |
| parameters.lightMap | Texture | No | ライトマップテクスチャ | デフォルト: null |
| parameters.aoMap | Texture | No | アンビエントオクルージョンマップ | デフォルト: null |
| parameters.envMap | Texture | No | 環境マップ | デフォルト: null |
| parameters.wireframe | boolean | No | ワイヤーフレーム表示 | デフォルト: false |
| parameters.fog | boolean | No | フォグへの反応 | デフォルト: true |

### 入力データソース

コンストラクタ引数として直接渡される。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| color | Color | 基本色（RGB） |
| map | Texture | カラーマップテクスチャ |
| lightMap | Texture | ライトマップ |
| aoMap | Texture | アンビエントオクルージョンマップ |
| envMap | Texture | 環境マップ |
| wireframe | boolean | ワイヤーフレームモード |

### 出力先

レンダラーがマテリアルプロパティを読み取りシェーダーに反映する。

## 処理フロー

### 処理シーケンス

```
1. Materialの初期化
   └─ super()を呼び出し
2. isMeshBasicMaterialフラグの設定
   └─ true
3. typeプロパティの設定
   └─ 'MeshBasicMaterial'
4. デフォルトプロパティの設定
   └─ color, map, lightMap, aoMap, envMap等
5. パラメータの適用
   └─ setValues(parameters)
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Material初期化]
    B --> C[isMeshBasicMaterial = true]
    C --> D[type = 'MeshBasicMaterial']
    D --> E[color = 0xffffff]
    E --> F[テクスチャプロパティ初期化]
    F --> G[環境マップ設定初期化]
    G --> H[ワイヤーフレーム設定初期化]
    H --> I[setValues: パラメータ適用]
    I --> J[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | ライティング無視 | シーン内の光源による影響を受けない | 常時 |
| BR-002 | 環境マップ合成 | combineプロパティで合成モードを選択 | envMap使用時 |
| BR-003 | フォグ対応 | fogプロパティでフォグへの反応を制御 | シーンにフォグがある場合 |
| BR-004 | UV必須 | lightMap, aoMapは第2UVセットが必要 | lightMap/aoMap使用時 |

### 計算ロジック

**環境マップ合成**:
- MultiplyOperation: surfaceColor * envMapColor
- MixOperation: lerp(surfaceColor, envMapColor, reflectivity)
- AddOperation: surfaceColor + envMapColor

**屈折率**:
- refractionRatio = IOR_air / IOR_material
- デフォルト: 0.98（空気/ガラスに近い値）

## データベース操作仕様

該当なし（クライアントサイド処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | 無効なテクスチャ参照 | コンソール警告 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（クライアントサイド処理のみ）

## パフォーマンス要件

- ライティング計算がないため、他のマテリアルより高速
- 環境マップ使用時は追加のテクスチャサンプリングが発生

## セキュリティ考慮事項

該当なし（クライアントサイドのマテリアル管理処理）

## 備考

- ライティングを使用しないためシャドウを受けない
- 環境マップによる疑似反射は可能
- スプライトやパーティクルにも使用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、MeshBasicMaterialが継承するMaterialと依存するクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Material.js | `src/materials/Material.js` | 基底クラスのプロパティ |
| 1-2 | Color.js | `src/math/Color.js` | カラー管理 |
| 1-3 | Euler.js | `src/math/Euler.js` | 環境マップ回転 |

**読解のコツ**: MeshBasicMaterialはMaterialを継承し、テクスチャ関連のプロパティを追加している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MeshBasicMaterial.js | `src/materials/MeshBasicMaterial.js` | コンストラクタのプロパティ定義 |

**主要処理フロー**:
1. **25-28行目**: Material継承、super()呼び出し
2. **36行目**: isMeshBasicMaterial = true
3. **38行目**: type = 'MeshBasicMaterial'
4. **46行目**: color = new Color(0xffffff)
5. **56行目**: map = null（カラーマップ）
6. **64-72行目**: lightMap, lightMapIntensity
7. **80-91行目**: aoMap, aoMapIntensity
8. **99行目**: specularMap
9. **114行目**: alphaMap
10. **122行目**: envMap
11. **130行目**: envMapRotation
12. **141行目**: combine（環境マップ合成モード）
13. **150行目**: reflectivity
14. **161行目**: refractionRatio
15. **169-199行目**: wireframe設定
16. **207行目**: fog
17. **209行目**: setValues(parameters)

#### Step 3: copyメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MeshBasicMaterial.js | `src/materials/MeshBasicMaterial.js` | copyメソッド |

**主要処理フロー**:
- **213-246行目**: copyメソッド
- **215行目**: super.copy(source)で基底クラスのコピー
- **217行目**: color.copy(source.color)
- **219-242行目**: 各プロパティのコピー

### プログラム呼び出し階層図

```
MeshBasicMaterial.constructor(parameters)
    │
    ├─ Material.constructor()
    │      └─ EventDispatcher.constructor()
    │
    ├─ new Color(0xffffff)
    │
    ├─ new Euler()
    │
    └─ Material.setValues(parameters)
           └─ プロパティへの値設定
```

### データフロー図

```
[入力]                      [処理]                           [出力]

parameters ─────────────▶ MeshBasicMaterial.constructor()
                               │
                               │ Material初期化
                               │ プロパティ設定
                               │ setValues適用
                               ▼
                    ┌─────────────────────┐
                    │ MeshBasicMaterial   │
                    │  - color            │
                    │  - map              │
                    │  - lightMap         │
                    │  - aoMap            │ ────▶ Rendererで使用
                    │  - envMap           │
                    │  - wireframe        │
                    │  - fog              │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MeshBasicMaterial.js | `src/materials/MeshBasicMaterial.js` | ソース | 基本マテリアルクラス |
| Material.js | `src/materials/Material.js` | ソース | マテリアル基底クラス |
| Color.js | `src/math/Color.js` | ソース | カラー管理 |
| Euler.js | `src/math/Euler.js` | ソース | 環境マップ回転 |
| Texture.js | `src/textures/Texture.js` | ソース | テクスチャ基底クラス |
| constants.js | `src/constants.js` | ソース | MultiplyOperation等の定数 |
