# 機能設計書 50-MeshLambertMaterial

## 概要

本ドキュメントは、Three.jsライブラリにおけるLambertシェーディングを使用するマテリアルであるMeshLambertMaterialクラスの機能設計を記述する。

### 本機能の処理概要

MeshLambertMaterialは、Lambertian反射モデルを使用した非物理ベースのマテリアルクラスである。光沢のない（非スペキュラー）表面をシミュレートし、木材、石材、布などの拡散反射が支配的な素材の表現に適している。MeshBasicMaterialとは異なり、シーン内の光源に反応して明暗が変化する。

**業務上の目的・背景**：Lambertian反射モデルは、コンピュータグラフィックスにおいて最も基本的なシェーディングモデルの一つである。計算が軽量でありながら、光源による陰影を表現できるため、リアルタイムアプリケーションで広く使用される。MeshPhongMaterialやMeshStandardMaterialよりも計算コストが低いため、パフォーマンスが重要なシーンや大量のオブジェクトを描画する場合に適している。

**機能の利用シーン**：
- 木材、石、コンクリートなどのマット素材の表現
- パフォーマンス重視のリアルタイムレンダリング
- 大量のオブジェクトを含むシーン
- 陰影表現が必要だがスペキュラーハイライトが不要な場面
- ゲームや建築ビジュアライゼーション

**主要な処理内容**：
1. 拡散色（diffuse color）の設定
2. 各種テクスチャマップの適用（カラー、法線、バンプ、ディスプレイスメント等）
3. 発光色（emissive）の設定
4. 環境マップとリフレクション設定
5. フラットシェーディング／スムーズシェーディングの切り替え
6. ワイヤーフレームモードの制御

**関連システム・外部連携**：Material（親クラス）、Texture、Color、Vector2、Euler、Light、Meshなど

**権限による制御**：なし（クライアントサイドのJavaScriptライブラリのため）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | Sidebar - Material | 補助機能 | Lambertマテリアルの設定 |

## 機能種別

マテリアル設定 / レンダリング外観

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| parameters | Object | No | マテリアルプロパティを定義するオブジェクト | - |
| parameters.color | Color/number/string | No | 拡散色 | デフォルト: 0xffffff |
| parameters.map | Texture | No | カラーマップテクスチャ | デフォルト: null |
| parameters.emissive | Color/number/string | No | 発光色 | デフォルト: 0x000000 |
| parameters.emissiveMap | Texture | No | 発光マップ | デフォルト: null |
| parameters.normalMap | Texture | No | 法線マップ | デフォルト: null |
| parameters.bumpMap | Texture | No | バンプマップ | デフォルト: null |
| parameters.displacementMap | Texture | No | ディスプレイスメントマップ | デフォルト: null |
| parameters.envMap | Texture | No | 環境マップ | デフォルト: null |
| parameters.flatShading | boolean | No | フラットシェーディング | デフォルト: false |
| parameters.wireframe | boolean | No | ワイヤーフレーム表示 | デフォルト: false |

### 入力データソース

コンストラクタ引数として直接渡される。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| color | Color | 拡散色（RGB） |
| emissive | Color | 発光色（RGB） |
| map | Texture | カラーマップテクスチャ |
| normalMap | Texture | 法線マップ |
| bumpMap | Texture | バンプマップ |
| envMap | Texture | 環境マップ |
| flatShading | boolean | フラットシェーディングモード |

### 出力先

レンダラーがマテリアルプロパティを読み取りシェーダーに反映する。

## 処理フロー

### 処理シーケンス

```
1. Materialの初期化
   └─ super()を呼び出し
2. isMeshLambertMaterialフラグの設定
   └─ true
3. typeプロパティの設定
   └─ 'MeshLambertMaterial'
4. デフォルトプロパティの設定
   └─ color, emissive, map, normalMap, bumpMap等
5. パラメータの適用
   └─ setValues(parameters)
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Material初期化]
    B --> C[isMeshLambertMaterial = true]
    C --> D[type = 'MeshLambertMaterial']
    D --> E[color = 0xffffff, emissive = 0x000000]
    E --> F[テクスチャプロパティ初期化]
    F --> G[法線/バンプマップ設定初期化]
    G --> H[環境マップ設定初期化]
    H --> I[シェーディング設定初期化]
    I --> J[setValues: パラメータ適用]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | Lambertian反射 | 視線方向に依存しない拡散反射を計算 | 常時 |
| BR-002 | 発光独立 | emissiveはライティングに影響されない | 常時 |
| BR-003 | 法線マップ優先 | normalMapがある場合bumpMapは無視 | 両方設定時 |
| BR-004 | フラグメントシェーディング | per-fragmentで計算（per-vertexではない） | 常時 |

### 計算ロジック

**Lambertian反射モデル**:
- diffuse = color * lightColor * max(dot(N, L), 0)
- N: 表面法線
- L: ライト方向

**最終出力**:
- output = diffuse + emissive * emissiveIntensity + ambient

## データベース操作仕様

該当なし（クライアントサイド処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | 無効なテクスチャ参照 | コンソール警告 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（クライアントサイド処理のみ）

## パフォーマンス要件

- MeshPhongMaterial/MeshStandardMaterialより軽量
- スペキュラー計算がないため高速
- 大量オブジェクトのシーンに適している

## セキュリティ考慮事項

該当なし（クライアントサイドのマテリアル管理処理）

## 備考

- スペキュラーハイライトを表現できない
- 物理ベースレンダリング（PBR）ではない
- 光沢のある表面にはMeshPhongMaterialまたはMeshStandardMaterialを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、MeshLambertMaterialが継承するMaterialと依存するクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Material.js | `src/materials/Material.js` | 基底クラスのプロパティ |
| 1-2 | Color.js | `src/math/Color.js` | カラー管理 |
| 1-3 | Vector2.js | `src/math/Vector2.js` | 法線スケール |

**読解のコツ**: MeshLambertMaterialはMeshBasicMaterialに発光と法線マッピングを追加したものとして理解できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MeshLambertMaterial.js | `src/materials/MeshLambertMaterial.js` | コンストラクタのプロパティ定義 |

**主要処理フロー**:
1. **35-38行目**: Material継承、super()呼び出し
2. **46行目**: isMeshLambertMaterial = true
3. **48行目**: type = 'MeshLambertMaterial'
4. **56行目**: color = new Color(0xffffff)
5. **66行目**: map = null（カラーマップ）
6. **74-82行目**: lightMap, lightMapIntensity
7. **90-101行目**: aoMap, aoMapIntensity
8. **110行目**: emissive = new Color(0x000000)
9. **118行目**: emissiveIntensity = 1.0
10. **128行目**: emissiveMap
11. **139行目**: bumpMap
12. **147行目**: bumpScale = 1
13. **160行目**: normalMap
14. **168行目**: normalMapType = TangentSpaceNormalMap
15. **176行目**: normalScale = new Vector2(1, 1)
16. **189行目**: displacementMap
17. **199行目**: displacementScale = 1
18. **209行目**: displacementBias = 0
19. **217-287行目**: specularMap, alphaMap, envMap等
20. **333行目**: flatShading = false
21. **341行目**: fog = true
22. **343行目**: setValues(parameters)

#### Step 3: copyメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MeshLambertMaterial.js | `src/materials/MeshLambertMaterial.js` | copyメソッド |

**主要処理フロー**:
- **347-398行目**: copyメソッド
- **349行目**: super.copy(source)で基底クラスのコピー
- **351行目**: color.copy(source.color)
- **361行目**: emissive.copy(source.emissive)
- **370行目**: normalScale.copy(source.normalScale)

### プログラム呼び出し階層図

```
MeshLambertMaterial.constructor(parameters)
    │
    ├─ Material.constructor()
    │      └─ EventDispatcher.constructor()
    │
    ├─ new Color(0xffffff)  // color
    │
    ├─ new Color(0x000000)  // emissive
    │
    ├─ new Vector2(1, 1)    // normalScale
    │
    ├─ new Euler()          // envMapRotation
    │
    └─ Material.setValues(parameters)
           └─ プロパティへの値設定
```

### データフロー図

```
[入力]                      [処理]                           [出力]

parameters ─────────────▶ MeshLambertMaterial.constructor()
Light情報                      │
                               │ Material初期化
                               │ プロパティ設定
                               │ setValues適用
                               ▼
                    ┌─────────────────────┐
                    │ MeshLambertMaterial │
                    │  - color            │
                    │  - emissive         │
                    │  - map              │
                    │  - normalMap        │ ────▶ Rendererで使用
                    │  - bumpMap          │      （Light情報と組み合わせ）
                    │  - envMap           │
                    │  - flatShading      │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MeshLambertMaterial.js | `src/materials/MeshLambertMaterial.js` | ソース | Lambertマテリアルクラス |
| Material.js | `src/materials/Material.js` | ソース | マテリアル基底クラス |
| Color.js | `src/math/Color.js` | ソース | カラー管理 |
| Vector2.js | `src/math/Vector2.js` | ソース | 2Dベクトル（法線スケール） |
| Euler.js | `src/math/Euler.js` | ソース | 環境マップ回転 |
| Texture.js | `src/textures/Texture.js` | ソース | テクスチャ基底クラス |
| constants.js | `src/constants.js` | ソース | TangentSpaceNormalMap等の定数 |
| Light.js | `src/lights/Light.js` | ソース | 光源基底クラス |
