# 機能設計書 51-MeshPhongMaterial

## 概要

本ドキュメントは、Three.jsにおけるMeshPhongMaterialクラスの機能設計を定義する。MeshPhongMaterialは、Phongシェーディングモデルを使用した光沢のある表面を持つ3Dオブジェクトのレンダリングに使用されるマテリアルクラスである。

### 本機能の処理概要

MeshPhongMaterialは、非物理ベースのBlinn-Phongシェーディングモデルを使用して反射を計算するマテリアルである。MeshLambertMaterialで使用されるLambertianモデルとは異なり、ニス塗りの木材のようなスペキュラハイライト（鏡面反射光）を持つ光沢のある表面をシミュレートできる。

**業務上の目的・背景**：3Dグラフィックスにおいて、プラスチック、陶器、金属などの光沢のある表面を持つオブジェクトを効率的にレンダリングする必要がある。MeshStandardMaterialやMeshPhysicalMaterialと比較して計算コストが低いため、パフォーマンスが重要な場面（リアルタイムプレビュー、モバイルデバイス等）で有効である。

**機能の利用シーン**：エディタでのマテリアル設定時、リアルタイム3Dアプリケーションでの光沢表面のレンダリング時、ゲームやインタラクティブコンテンツでの使用時に利用される。パフォーマンスと品質のバランスが求められる場面で選択される。

**主要な処理内容**：
1. マテリアルの初期化とパラメータ設定
2. 拡散反射色（diffuse color）の管理
3. スペキュラ色と輝度（shininess）の設定
4. 各種テクスチャマップ（カラーマップ、法線マップ、バンプマップ等）の適用
5. 環境マップによる反射のシミュレーション
6. ライトマップとアンビエントオクルージョンの適用
7. 発光色（emissive）の設定
8. ワイヤーフレームモードとフラットシェーディングのサポート

**関連システム・外部連携**：WebGLRenderer、WebGPURenderer、SVGRendererと連携してレンダリングを行う。テクスチャローダーから読み込まれたTexture、環境マップ用のCubeTexture等と連携する。

**権限による制御**：特になし。マテリアルの設定はすべてのユーザーが実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | Sidebar - Material | 補助機能 | Phongマテリアルの設定 |
| 36 | Material Browser | 主機能 | マテリアルのプレビュー |

## 機能種別

マテリアル設定 / シェーディング処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| color | Color | No | 拡散反射色（デフォルト: 0xffffff） | Color型として有効な値 |
| specular | Color | No | スペキュラ色（デフォルト: 0x111111） | Color型として有効な値 |
| shininess | number | No | スペキュラの鋭さ（デフォルト: 30） | 0以上の数値 |
| map | Texture | No | カラーマップ | Texture型またはnull |
| lightMap | Texture | No | ライトマップ | Texture型またはnull |
| lightMapIntensity | number | No | ライトマップ強度（デフォルト: 1） | 0以上の数値 |
| aoMap | Texture | No | アンビエントオクルージョンマップ | Texture型またはnull |
| aoMapIntensity | number | No | AO強度（デフォルト: 1） | 0-1の数値 |
| emissive | Color | No | 発光色（デフォルト: 0x000000） | Color型として有効な値 |
| emissiveIntensity | number | No | 発光強度（デフォルト: 1） | 0以上の数値 |
| emissiveMap | Texture | No | 発光マップ | Texture型またはnull |
| bumpMap | Texture | No | バンプマップ | Texture型またはnull |
| bumpScale | number | No | バンプスケール（デフォルト: 1） | 数値 |
| normalMap | Texture | No | 法線マップ | Texture型またはnull |
| normalMapType | constant | No | 法線マップタイプ（デフォルト: TangentSpaceNormalMap） | TangentSpaceNormalMapまたはObjectSpaceNormalMap |
| normalScale | Vector2 | No | 法線マップスケール（デフォルト: (1,1)） | Vector2型 |
| displacementMap | Texture | No | ディスプレイスメントマップ | Texture型またはnull |
| displacementScale | number | No | ディスプレイスメントスケール（デフォルト: 1） | 数値 |
| displacementBias | number | No | ディスプレイスメントバイアス（デフォルト: 0） | 数値 |
| specularMap | Texture | No | スペキュラマップ | Texture型またはnull |
| alphaMap | Texture | No | アルファマップ | Texture型またはnull |
| envMap | Texture | No | 環境マップ | Texture型またはnull |
| envMapRotation | Euler | No | 環境マップ回転（デフォルト: (0,0,0)） | Euler型 |
| combine | constant | No | 環境マップ合成モード（デフォルト: MultiplyOperation） | MultiplyOperation, MixOperation, AddOperation |
| reflectivity | number | No | 反射率（デフォルト: 1） | 0-1の数値 |
| envMapIntensity | number | No | 環境マップ強度（デフォルト: 1） | 0以上の数値 |
| refractionRatio | number | No | 屈折率（デフォルト: 0.98） | 0-1の数値 |
| wireframe | boolean | No | ワイヤーフレーム描画（デフォルト: false） | true/false |
| wireframeLinewidth | number | No | ワイヤーフレーム線幅（デフォルト: 1） | 1以上の数値 |
| wireframeLinecap | string | No | ワイヤーフレーム線端（デフォルト: 'round'） | 'round', 'bevel', 'miter' |
| wireframeLinejoin | string | No | ワイヤーフレーム線結合（デフォルト: 'round'） | 'round', 'bevel', 'miter' |
| flatShading | boolean | No | フラットシェーディング（デフォルト: false） | true/false |
| fog | boolean | No | フォグ影響（デフォルト: true） | true/false |

### 入力データソース

コンストラクタへのパラメータオブジェクト、またはプロパティへの直接代入

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isMeshPhongMaterial | boolean | 型判定フラグ（常にtrue） |
| type | string | マテリアルタイプ（'MeshPhongMaterial'） |
| マテリアルプロパティ | 各種 | 設定されたマテリアル属性 |

### 出力先

WebGLRenderer/WebGPURendererによるシェーダープログラムへの入力

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 親クラスMaterialのコンストラクタを呼び出し
2. 型フラグの設定
   └─ isMeshPhongMaterial = true
3. マテリアルタイプの設定
   └─ type = 'MeshPhongMaterial'
4. デフォルトプロパティの初期化
   └─ color, specular, shininess等の初期値設定
5. テクスチャマップの初期化
   └─ map, normalMap, bumpMap等をnullで初期化
6. パラメータの適用
   └─ setValues(parameters)でパラメータを適用
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new MeshPhongMaterial] --> B[super() 呼び出し]
    B --> C[isMeshPhongMaterial = true]
    C --> D[type = 'MeshPhongMaterial']
    D --> E[カラープロパティ初期化]
    E --> F[テクスチャマップ初期化]
    F --> G[ワイヤーフレーム設定初期化]
    G --> H[setValues parameters]
    H --> I[終了: マテリアルインスタンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 法線マップ優先 | normalMapが設定されている場合、bumpMapは無視される | normalMapがnull以外の場合 |
| BR-02 | 第2UV必須 | lightMapとaoMapは第2セットのUV座標が必要 | lightMapまたはaoMapを使用する場合 |
| BR-03 | スペキュラハイライト | shininess値が高いほど、スペキュラハイライトがシャープになる | shininess > 0の場合 |
| BR-04 | 環境マップ合成 | combineがMixOperationの場合、reflectivityでブレンド量を制御 | combine = MixOperationの場合 |

### 計算ロジック

Blinn-Phongシェーディングモデル:
- 拡散反射: diffuse = color * dot(normal, lightDirection)
- スペキュラ反射: specular = specularColor * pow(dot(normal, halfVector), shininess)
- 最終色 = ambient + diffuse + specular + emissive

## データベース操作仕様

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | Warning | 未定義のプロパティを設定しようとした場合 | コンソールに警告を出力 |
| N/A | Warning | undefinedの値を設定しようとした場合 | コンソールに警告を出力し、設定をスキップ |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- MeshStandardMaterialやMeshPhysicalMaterialより計算コストが低い
- per-fragmentシェーディングを使用
- 複雑なシーンでも60fps維持が目標

## セキュリティ考慮事項

特になし

## 備考

- SVGRendererを使用する場合のみwireframeLinewidthが有効
- WebGL/WebGPUでは線幅は常に1ピクセル

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、マテリアルの基本構造と継承関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Material.js | `src/materials/Material.js` | マテリアルの基底クラス。共通プロパティ（blending, side, opacity等）を定義 |
| 1-2 | MeshPhongMaterial.js | `src/materials/MeshPhongMaterial.js` | Phong固有のプロパティ（specular, shininess等）を定義 |

**読解のコツ**: Materialクラスはすべてのマテリアルの基底クラスであり、ブレンディング、深度テスト、ステンシルなどの共通設定を持つ。MeshPhongMaterialはこれを継承し、Phongシェーディング固有のプロパティを追加している。

#### Step 2: エントリーポイントを理解する

マテリアルのインスタンス化と初期化プロセスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MeshPhongMaterial.js | `src/materials/MeshPhongMaterial.js` | constructorメソッドがエントリーポイント |

**主要処理フロー**:
1. **33-35行目**: コンストラクタでsuper()を呼び出し、Materialの初期化を実行
2. **44行目**: isMeshPhongMaterialフラグをtrueに設定
3. **46行目**: typeを'MeshPhongMaterial'に設定
4. **54行目**: 拡散色colorを白(0xffffff)で初期化
5. **63行目**: スペキュラ色specularを暗いグレー(0x111111)で初期化
6. **71行目**: shininessを30で初期化
7. **81-304行目**: 各種テクスチャマップとプロパティの初期化
8. **360行目**: setValues(parameters)でユーザー指定パラメータを適用

#### Step 3: copyメソッドを理解する

マテリアルのクローン作成時の動作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MeshPhongMaterial.js | `src/materials/MeshPhongMaterial.js` | copyメソッド（364-417行目） |

**主要処理フロー**:
- **366行目**: 親クラスのcopyを呼び出し
- **368-413行目**: Phong固有のプロパティをコピー

### プログラム呼び出し階層図

```
MeshPhongMaterial (constructor)
    │
    ├─ Material (super())
    │      └─ EventDispatcher (super())
    │
    ├─ Color (new Color())
    │      └─ color, specular, emissive の初期化
    │
    ├─ Vector2 (new Vector2())
    │      └─ normalScale の初期化
    │
    ├─ Euler (new Euler())
    │      └─ envMapRotation の初期化
    │
    └─ setValues (parameters)
           └─ Material.setValues (inherited)
```

### データフロー図

```
[入力]                      [処理]                         [出力]

parameters ────────▶ constructor() ────────▶ MeshPhongMaterial
  (color, specular,    - super()呼び出し        インスタンス
   shininess, map,     - プロパティ初期化        (シェーダーで
   normalMap, etc.)    - setValues()適用          使用される
                                                  マテリアル設定)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Material.js | `src/materials/Material.js` | ソース | マテリアル基底クラス |
| MeshPhongMaterial.js | `src/materials/MeshPhongMaterial.js` | ソース | Phongマテリアル実装 |
| Color.js | `src/math/Color.js` | ソース | 色データ管理 |
| Vector2.js | `src/math/Vector2.js` | ソース | 2次元ベクトル（normalScale用） |
| Euler.js | `src/math/Euler.js` | ソース | オイラー角（envMapRotation用） |
| constants.js | `src/constants.js` | ソース | 定数定義（TangentSpaceNormalMap, MultiplyOperation等） |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベント管理（disposeイベント等） |
