# 機能設計書 54-MeshToonMaterial

## 概要

本ドキュメントは、Three.jsにおけるMeshToonMaterialクラスの機能設計を定義する。MeshToonMaterialは、トゥーン（アニメ調）シェーディングを実現するマテリアルクラスである。

### 本機能の処理概要

MeshToonMaterialは、漫画やアニメーションのような非写実的なレンダリング（NPR: Non-Photorealistic Rendering）を実現するマテリアルである。gradientMapを使用して、陰影を段階的（セルシェーディング）に表現し、アニメ調の見た目を実現する。

**業務上の目的・背景**：ゲーム、アニメーション、インタラクティブコンテンツなど、スタイライズドな表現が求められる場面では、写実的なPBRレンダリングではなく、アニメ調のレンダリングが必要となる。MeshToonMaterialは、このようなニーズに対応し、セルシェーディング効果を簡単に実現できる。

**機能の利用シーン**：アニメ調のキャラクターレンダリング、カートゥーンスタイルのゲーム開発、スタイライズドな3Dイラストレーション、漫画風の視覚効果が必要な場面で使用される。

**主要な処理内容**：
1. マテリアルの初期化とパラメータ設定
2. 拡散反射色（diffuse color）の管理
3. グラデーションマップによるトゥーンシェーディング
4. 各種テクスチャマップ（カラーマップ、法線マップ、バンプマップ等）の適用
5. ライトマップとアンビエントオクルージョンの適用
6. 発光色（emissive）の設定
7. ワイヤーフレームモードのサポート

**関連システム・外部連携**：WebGLRenderer、WebGPURenderer、SVGRendererと連携。gradientMapのテクスチャ設定にはNearestFilterの使用が推奨される。

**権限による制御**：特になし。マテリアルの設定はすべてのユーザーが実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | Sidebar - Material | 補助機能 | トゥーンマテリアルの設定 |

## 機能種別

マテリアル設定 / トゥーンシェーディング処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| color | Color | No | 拡散反射色（デフォルト: 0xffffff） | Color型として有効な値 |
| map | Texture | No | カラーマップ | Texture型またはnull |
| gradientMap | Texture | No | グラデーションマップ（トゥーン効果用、NearestFilter推奨） | Texture型またはnull |
| lightMap | Texture | No | ライトマップ | Texture型またはnull |
| lightMapIntensity | number | No | ライトマップ強度（デフォルト: 1） | 0以上の数値 |
| aoMap | Texture | No | アンビエントオクルージョンマップ | Texture型またはnull |
| aoMapIntensity | number | No | AO強度（デフォルト: 1） | 0-1の数値 |
| emissive | Color | No | 発光色（デフォルト: 0x000000） | Color型として有効な値 |
| emissiveIntensity | number | No | 発光強度（デフォルト: 1） | 0以上の数値 |
| emissiveMap | Texture | No | 発光マップ | Texture型またはnull |
| bumpMap | Texture | No | バンプマップ | Texture型またはnull |
| bumpScale | number | No | バンプスケール（デフォルト: 1） | 数値 |
| normalMap | Texture | No | 法線マップ | Texture型またはnull |
| normalMapType | constant | No | 法線マップタイプ（デフォルト: TangentSpaceNormalMap） | TangentSpaceNormalMapまたはObjectSpaceNormalMap |
| normalScale | Vector2 | No | 法線マップスケール（デフォルト: (1,1)） | Vector2型 |
| displacementMap | Texture | No | ディスプレイスメントマップ | Texture型またはnull |
| displacementScale | number | No | ディスプレイスメントスケール（デフォルト: 1） | 数値 |
| displacementBias | number | No | ディスプレイスメントバイアス（デフォルト: 0） | 数値 |
| alphaMap | Texture | No | アルファマップ | Texture型またはnull |
| wireframe | boolean | No | ワイヤーフレーム描画（デフォルト: false） | true/false |
| wireframeLinewidth | number | No | ワイヤーフレーム線幅（デフォルト: 1） | 1以上の数値 |
| wireframeLinecap | string | No | ワイヤーフレーム線端（デフォルト: 'round'） | 'round', 'bevel', 'miter' |
| wireframeLinejoin | string | No | ワイヤーフレーム線結合（デフォルト: 'round'） | 'round', 'bevel', 'miter' |
| fog | boolean | No | フォグ影響（デフォルト: true） | true/false |

### 入力データソース

コンストラクタへのパラメータオブジェクト、またはプロパティへの直接代入

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isMeshToonMaterial | boolean | 型判定フラグ（常にtrue） |
| type | string | マテリアルタイプ（'MeshToonMaterial'） |
| defines | Object | シェーダー定義（{ 'TOON': '' }） |
| マテリアルプロパティ | 各種 | 設定されたマテリアル属性 |

### 出力先

WebGLRenderer/WebGPURendererによるシェーダープログラムへの入力

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 親クラスMaterialのコンストラクタを呼び出し
2. 型フラグの設定
   └─ isMeshToonMaterial = true
3. シェーダー定義の設定
   └─ defines = { 'TOON': '' }
4. マテリアルタイプの設定
   └─ type = 'MeshToonMaterial'
5. デフォルトプロパティの初期化
   └─ color, gradientMap等の初期値設定
6. テクスチャマップの初期化
   └─ map, normalMap, bumpMap等をnullで初期化
7. パラメータの適用
   └─ setValues(parameters)でパラメータを適用
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new MeshToonMaterial] --> B[super() 呼び出し]
    B --> C[isMeshToonMaterial = true]
    C --> D[defines = TOON]
    D --> E[type = 'MeshToonMaterial']
    E --> F[カラープロパティ初期化]
    F --> G[gradientMap初期化 null]
    G --> H[テクスチャマップ初期化]
    H --> I[ワイヤーフレーム設定初期化]
    I --> J[setValues parameters]
    J --> K[終了: マテリアルインスタンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | gradientMapフィルタ | gradientMapを使用する場合、minFilterとmagFilterをNearestFilterに設定する必要がある | gradientMapを使用する場合 |
| BR-02 | 法線マップ優先 | normalMapが設定されている場合、bumpMapは無視される | normalMapがnull以外の場合 |
| BR-03 | 第2UV必須 | lightMapとaoMapは第2セットのUV座標が必要 | lightMapまたはaoMapを使用する場合 |
| BR-04 | flatShading非対応 | MeshToonMaterialはflatShadingプロパティを持たない | - |

### 計算ロジック

トゥーンシェーディング:
- gradientMapを使用して陰影を離散的に量子化
- NdotL（法線とライト方向の内積）をgradientMapでルックアップ
- gradientMapがnullの場合、デフォルトの2段階シェーディングが適用

## データベース操作仕様

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | Warning | 未定義のプロパティを設定しようとした場合 | コンソールに警告を出力 |
| N/A | Warning | undefinedの値を設定しようとした場合 | コンソールに警告を出力し、設定をスキップ |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- PBRマテリアルより計算コストが低い
- gradientMapルックアップによる追加テクスチャサンプリングが発生

## セキュリティ考慮事項

特になし

## 備考

- SVGRendererを使用する場合のみwireframeLinewidthが有効
- gradientMapは1Dテクスチャとして扱われるため、通常は小さな画像（3-5ピクセル幅）で十分

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、マテリアルの基本構造とトゥーン固有のプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Material.js | `src/materials/Material.js` | マテリアルの基底クラス |
| 1-2 | MeshToonMaterial.js | `src/materials/MeshToonMaterial.js` | トゥーン固有のプロパティ（gradientMap等） |

**読解のコツ**: MeshToonMaterialはMaterialを直接継承し、definesに'TOON'を設定することでシェーダーにトゥーンモードを指示している。gradientMapがトゥーンシェーディングの核心的なプロパティである。

#### Step 2: エントリーポイントを理解する

マテリアルのインスタンス化と初期化プロセスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MeshToonMaterial.js | `src/materials/MeshToonMaterial.js` | constructorメソッドがエントリーポイント |

**主要処理フロー**:
1. **23-26行目**: コンストラクタでsuper()を呼び出し
2. **34行目**: isMeshToonMaterialフラグをtrueに設定
3. **36行目**: definesに{ 'TOON': '' }を設定
4. **38行目**: typeを'MeshToonMaterial'に設定
5. **46行目**: colorを白(0xffffff)で初期化
6. **56行目**: mapをnullで初期化
7. **66行目**: gradientMapをnullで初期化
8. **74-82行目**: lightMap関連の初期化
9. **91-101行目**: aoMap関連の初期化
10. **110-128行目**: emissive関連の初期化
11. **139-176行目**: bump, normal関連の初期化
12. **188-209行目**: displacement関連の初期化
13. **224行目**: alphaMapの初期化
14. **232-262行目**: wireframe関連の初期化
15. **270行目**: fogをtrueで初期化
16. **272行目**: setValues(parameters)でパラメータを適用

#### Step 3: copyメソッドを理解する

マテリアルのクローン作成時の動作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MeshToonMaterial.js | `src/materials/MeshToonMaterial.js` | copyメソッド（276-317行目） |

**主要処理フロー**:
- **278行目**: 親クラスのcopyを呼び出し
- **280行目**: colorをコピー
- **282-283行目**: mapとgradientMapをコピー
- **285-313行目**: その他のプロパティをコピー

### プログラム呼び出し階層図

```
MeshToonMaterial (constructor)
    │
    ├─ Material (super())
    │      └─ EventDispatcher (super())
    │
    ├─ Color (new Color())
    │      └─ color, emissive の初期化
    │
    ├─ Vector2 (new Vector2())
    │      └─ normalScale の初期化
    │
    └─ setValues (parameters)
           └─ Material.setValues (inherited)
```

### データフロー図

```
[入力]                      [処理]                         [出力]

parameters ────────▶ constructor() ────────▶ MeshToonMaterial
  (color, gradientMap,   - super()呼び出し       インスタンス
   map, normalMap,       - defines設定           (トゥーンシェーダー
   emissive, etc.)       - プロパティ初期化        で使用される
                         - setValues()適用         マテリアル設定)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Material.js | `src/materials/Material.js` | ソース | マテリアル基底クラス |
| MeshToonMaterial.js | `src/materials/MeshToonMaterial.js` | ソース | トゥーンマテリアル実装 |
| Color.js | `src/math/Color.js` | ソース | 色データ管理 |
| Vector2.js | `src/math/Vector2.js` | ソース | 2次元ベクトル（normalScale用） |
| constants.js | `src/constants.js` | ソース | 定数定義（TangentSpaceNormalMap等） |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベント管理 |
