# 機能設計書 55-MeshNormalMaterial

## 概要

本ドキュメントは、Three.jsにおけるMeshNormalMaterialクラスの機能設計を定義する。MeshNormalMaterialは、法線ベクトルをRGB色にマッピングして表示するデバッグ用マテリアルクラスである。

### 本機能の処理概要

MeshNormalMaterialは、メッシュの法線ベクトルをRGB色として視覚化するマテリアルである。法線のX、Y、Z成分がそれぞれR、G、B色成分にマッピングされ、ジオメトリの法線状態を視覚的に確認できる。ライティングの影響を受けないため、デバッグや法線の確認に最適である。

**業務上の目的・背景**：3Dモデルの法線が正しく設定されているかを確認することは、ライティングやシェーディングの品質に直接影響する。MeshNormalMaterialを使用することで、モデルの法線状態を視覚的に確認でき、法線の問題（反転、欠落、不連続等）を素早く発見できる。

**機能の利用シーン**：3Dモデルのデバッグ時、法線マップの確認時、ジオメトリの品質チェック時、教育・学習目的での法線の可視化時に使用される。

**主要な処理内容**：
1. マテリアルの初期化とパラメータ設定
2. 法線ベクトルのRGB色への変換
3. バンプマップによる法線の摂動
4. 法線マップによる法線の変更
5. ディスプレイスメントマップによる頂点変形
6. ワイヤーフレームモードとフラットシェーディングのサポート

**関連システム・外部連携**：WebGLRenderer、WebGPURendererと連携。ライティングの影響を受けないため、光源設定なしで使用可能。

**権限による制御**：特になし。マテリアルの設定はすべてのユーザーが実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | （画面機能マッピングに登録なし） |

## 機能種別

マテリアル設定 / デバッグ用シェーディング処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| bumpMap | Texture | No | バンプマップ | Texture型またはnull |
| bumpScale | number | No | バンプスケール（デフォルト: 1） | 数値 |
| normalMap | Texture | No | 法線マップ | Texture型またはnull |
| normalMapType | constant | No | 法線マップタイプ（デフォルト: TangentSpaceNormalMap） | TangentSpaceNormalMapまたはObjectSpaceNormalMap |
| normalScale | Vector2 | No | 法線マップスケール（デフォルト: (1,1)） | Vector2型 |
| displacementMap | Texture | No | ディスプレイスメントマップ | Texture型またはnull |
| displacementScale | number | No | ディスプレイスメントスケール（デフォルト: 1） | 数値 |
| displacementBias | number | No | ディスプレイスメントバイアス（デフォルト: 0） | 数値 |
| wireframe | boolean | No | ワイヤーフレーム描画（デフォルト: false） | true/false |
| wireframeLinewidth | number | No | ワイヤーフレーム線幅（デフォルト: 1） | 1以上の数値 |
| flatShading | boolean | No | フラットシェーディング（デフォルト: false） | true/false |

### 入力データソース

コンストラクタへのパラメータオブジェクト、またはプロパティへの直接代入

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isMeshNormalMaterial | boolean | 型判定フラグ（常にtrue） |
| type | string | マテリアルタイプ（'MeshNormalMaterial'） |
| マテリアルプロパティ | 各種 | 設定されたマテリアル属性 |

### 出力先

WebGLRenderer/WebGPURendererによるシェーダープログラムへの入力

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 親クラスMaterialのコンストラクタを呼び出し
2. 型フラグの設定
   └─ isMeshNormalMaterial = true
3. マテリアルタイプの設定
   └─ type = 'MeshNormalMaterial'
4. デフォルトプロパティの初期化
   └─ bumpMap, normalMap等の初期値設定
5. テクスチャマップの初期化
   └─ displacementMap等をnullで初期化
6. パラメータの適用
   └─ setValues(parameters)でパラメータを適用
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new MeshNormalMaterial] --> B[super() 呼び出し]
    B --> C[isMeshNormalMaterial = true]
    C --> D[type = 'MeshNormalMaterial']
    D --> E[bumpMap/normalMap初期化]
    E --> F[displacementMap初期化]
    F --> G[wireframe/flatShading初期化]
    G --> H[setValues parameters]
    H --> I[終了: マテリアルインスタンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 法線マップ優先 | normalMapが設定されている場合、bumpMapは無視される | normalMapがnull以外の場合 |
| BR-02 | ライティング非対応 | 光源の影響を受けない（法線をそのまま色として表示） | 常時 |
| BR-03 | 色設定なし | colorプロパティを持たない（法線が色を決定） | 常時 |

### 計算ロジック

法線からRGB色への変換:
- R = (normal.x + 1) / 2
- G = (normal.y + 1) / 2
- B = (normal.z + 1) / 2

法線ベクトルの各成分（-1〜1）を0〜1の色範囲にマッピング。

## データベース操作仕様

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | Warning | 未定義のプロパティを設定しようとした場合 | コンソールに警告を出力 |
| N/A | Warning | undefinedの値を設定しようとした場合 | コンソールに警告を出力し、設定をスキップ |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 非常に軽量な計算（ライティング計算不要）
- デバッグ用途に最適

## セキュリティ考慮事項

特になし

## 備考

- WebGL/WebGPUではwireframeLinewidthは常に1ピクセルで描画
- フラットシェーディング時は面法線が使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、マテリアルの基本構造とNormal固有のプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Material.js | `src/materials/Material.js` | マテリアルの基底クラス |
| 1-2 | MeshNormalMaterial.js | `src/materials/MeshNormalMaterial.js` | 法線表示固有のプロパティ |

**読解のコツ**: MeshNormalMaterialはMaterialを直接継承し、colorプロパティを持たない。法線ベクトルが直接色として出力されるため、ライティング関連のプロパティも持たない。

#### Step 2: エントリーポイントを理解する

マテリアルのインスタンス化と初期化プロセスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MeshNormalMaterial.js | `src/materials/MeshNormalMaterial.js` | constructorメソッドがエントリーポイント |

**主要処理フロー**:
1. **22-24行目**: コンストラクタでsuper()を呼び出し
2. **33行目**: isMeshNormalMaterialフラグをtrueに設定
3. **35行目**: typeを'MeshNormalMaterial'に設定
4. **46行目**: bumpMapをnullで初期化
5. **54行目**: bumpScaleを1で初期化
6. **67行目**: normalMapをnullで初期化
7. **75行目**: normalMapTypeをTangentSpaceNormalMapで初期化
8. **83行目**: normalScaleを(1,1)で初期化
9. **96行目**: displacementMapをnullで初期化
10. **106行目**: displacementScaleを1で初期化
11. **116行目**: displacementBiasを0で初期化
12. **124行目**: wireframeをfalseで初期化
13. **135行目**: wireframeLinewidthを1で初期化
14. **143行目**: flatShadingをfalseで初期化
15. **145行目**: setValues(parameters)でパラメータを適用

#### Step 3: copyメソッドを理解する

マテリアルのクローン作成時の動作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MeshNormalMaterial.js | `src/materials/MeshNormalMaterial.js` | copyメソッド（149-171行目） |

**主要処理フロー**:
- **151行目**: 親クラスのcopyを呼び出し
- **153-167行目**: Normal固有のプロパティをコピー

### プログラム呼び出し階層図

```
MeshNormalMaterial (constructor)
    │
    ├─ Material (super())
    │      └─ EventDispatcher (super())
    │
    ├─ Vector2 (new Vector2())
    │      └─ normalScale の初期化
    │
    └─ setValues (parameters)
           └─ Material.setValues (inherited)
```

### データフロー図

```
[入力]                      [処理]                         [出力]

parameters ────────▶ constructor() ────────▶ MeshNormalMaterial
  (bumpMap,            - super()呼び出し       インスタンス
   normalMap,          - プロパティ初期化        (法線シェーダーで
   displacementMap,    - setValues()適用         使用される
   wireframe, etc.)                              マテリアル設定)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Material.js | `src/materials/Material.js` | ソース | マテリアル基底クラス |
| MeshNormalMaterial.js | `src/materials/MeshNormalMaterial.js` | ソース | 法線マテリアル実装 |
| Vector2.js | `src/math/Vector2.js` | ソース | 2次元ベクトル（normalScale用） |
| constants.js | `src/constants.js` | ソース | 定数定義（TangentSpaceNormalMap等） |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベント管理 |
