# 機能設計書 57-MeshDepthMaterial

## 概要

本ドキュメントは、Three.jsにおけるMeshDepthMaterialクラスの機能設計を定義する。MeshDepthMaterialは、ジオメトリを深度値で描画するマテリアルクラスである。カメラのnear/farプレーンに基づき、近いほど白く、遠いほど黒く表示される。

### 本機能の処理概要

MeshDepthMaterialは、カメラからの距離（深度）を色として視覚化するマテリアルである。深度バッファの内容を確認したり、シャドウマップの生成、ポストプロセッシング用の深度パスレンダリングなどに使用される。深度値のパッキング方式を選択でき、用途に応じた精度で深度情報を出力できる。

**業務上の目的・背景**：シャドウマッピング、被写界深度（DOF）エフェクト、SSAO（Screen Space Ambient Occlusion）などのポストプロセッシングエフェクトでは、深度情報が必要となる。MeshDepthMaterialを使用することで、深度パスを簡単にレンダリングできる。

**機能の利用シーン**：シャドウマップの生成、深度バッファの可視化、ポストプロセッシング用の深度パス、カメラ距離に基づくエフェクトの実装時に使用される。

**主要な処理内容**：
1. マテリアルの初期化とパラメータ設定
2. 深度パッキングモードの選択
3. カラーマップとアルファマップによるアルファテスト
4. ディスプレイスメントマップによる頂点変形
5. ワイヤーフレームモードのサポート

**関連システム・外部連携**：WebGLRenderer、WebGPURendererと連携。シャドウマップ生成時に内部的に使用される。RenderTargetへのレンダリングと組み合わせて使用。

**権限による制御**：特になし。マテリアルの設定はすべてのユーザーが実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | （画面機能マッピングに登録なし） |

## 機能種別

マテリアル設定 / 深度シェーディング処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| depthPacking | constant | No | 深度パッキングタイプ（デフォルト: BasicDepthPacking） | BasicDepthPacking, RGBADepthPacking, RGBDepthPacking, RGDepthPacking |
| map | Texture | No | カラーマップ（アルファテスト用） | Texture型またはnull |
| alphaMap | Texture | No | アルファマップ | Texture型またはnull |
| displacementMap | Texture | No | ディスプレイスメントマップ | Texture型またはnull |
| displacementScale | number | No | ディスプレイスメントスケール（デフォルト: 1） | 数値 |
| displacementBias | number | No | ディスプレイスメントバイアス（デフォルト: 0） | 数値 |
| wireframe | boolean | No | ワイヤーフレーム描画（デフォルト: false） | true/false |
| wireframeLinewidth | number | No | ワイヤーフレーム線幅（デフォルト: 1） | 1以上の数値 |

### 入力データソース

コンストラクタへのパラメータオブジェクト、またはプロパティへの直接代入

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isMeshDepthMaterial | boolean | 型判定フラグ（常にtrue） |
| type | string | マテリアルタイプ（'MeshDepthMaterial'） |
| マテリアルプロパティ | 各種 | 設定されたマテリアル属性 |

### 出力先

WebGLRenderer/WebGPURendererによるシェーダープログラムへの入力

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 親クラスMaterialのコンストラクタを呼び出し
2. 型フラグの設定
   └─ isMeshDepthMaterial = true
3. マテリアルタイプの設定
   └─ type = 'MeshDepthMaterial'
4. 深度パッキングの設定
   └─ depthPacking = BasicDepthPacking
5. テクスチャマップの初期化
   └─ map, alphaMap, displacementMap等をnullで初期化
6. パラメータの適用
   └─ setValues(parameters)でパラメータを適用
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new MeshDepthMaterial] --> B[super() 呼び出し]
    B --> C[isMeshDepthMaterial = true]
    C --> D[type = 'MeshDepthMaterial']
    D --> E[depthPacking = BasicDepthPacking]
    E --> F[テクスチャマップ初期化]
    F --> G[wireframe設定初期化]
    G --> H[setValues parameters]
    H --> I[終了: マテリアルインスタンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 深度パッキング選択 | depthPackingで深度値のエンコード方式を選択 | 常時 |
| BR-02 | BasicDepthPacking | 深度値をグレースケール（単一チャンネル）で出力 | depthPacking=BasicDepthPacking |
| BR-03 | RGBADepthPacking | 深度値を4チャンネルにパック（高精度） | depthPacking=RGBADepthPacking |
| BR-04 | ライト非対応 | ライティングの影響を受けない | 常時 |

### 計算ロジック

深度計算:
- 深度 = (カメラからの距離 - near) / (far - near)
- BasicDepthPacking: color.rgb = vec3(depth)
- RGBADepthPacking: 24ビット深度を4つの8ビットチャンネルにパック

## データベース操作仕様

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | Warning | 未定義のプロパティを設定しようとした場合 | コンソールに警告を出力 |
| N/A | Warning | undefinedの値を設定しようとした場合 | コンソールに警告を出力し、設定をスキップ |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 非常に軽量な計算（ライティング計算不要）
- シャドウマップ生成に最適化

## セキュリティ考慮事項

特になし

## 備考

- WebGL/WebGPUではwireframeLinewidthは常に1ピクセルで描画
- RGBADepthPackingはシャドウマップで高精度が必要な場合に使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、マテリアルの基本構造とDepth固有のプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Material.js | `src/materials/Material.js` | マテリアルの基底クラス |
| 1-2 | MeshDepthMaterial.js | `src/materials/MeshDepthMaterial.js` | 深度マテリアル固有のプロパティ（depthPacking等） |

**読解のコツ**: MeshDepthMaterialはMaterialを直接継承し、colorプロパティを持たない。depthPackingプロパティが深度値のエンコード方式を制御する。

#### Step 2: エントリーポイントを理解する

マテリアルのインスタンス化と初期化プロセスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MeshDepthMaterial.js | `src/materials/MeshDepthMaterial.js` | constructorメソッドがエントリーポイント |

**主要処理フロー**:
1. **22-24行目**: コンストラクタでsuper()を呼び出し
2. **33行目**: isMeshDepthMaterialフラグをtrueに設定
3. **35行目**: typeを'MeshDepthMaterial'に設定
4. **43行目**: depthPackingをBasicDepthPackingで初期化
5. **52行目**: mapをnullで初期化
6. **67行目**: alphaMapをnullで初期化
7. **80行目**: displacementMapをnullで初期化
8. **90行目**: displacementScaleを1で初期化
9. **100行目**: displacementBiasを0で初期化
10. **108行目**: wireframeをfalseで初期化
11. **119行目**: wireframeLinewidthを1で初期化
12. **121行目**: setValues(parameters)でパラメータを適用

#### Step 3: copyメソッドを理解する

マテリアルのクローン作成時の動作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MeshDepthMaterial.js | `src/materials/MeshDepthMaterial.js` | copyメソッド（125-144行目） |

**主要処理フロー**:
- **127行目**: 親クラスのcopyを呼び出し
- **129行目**: depthPackingをコピー
- **131-140行目**: その他のプロパティをコピー

### プログラム呼び出し階層図

```
MeshDepthMaterial (constructor)
    │
    ├─ Material (super())
    │      └─ EventDispatcher (super())
    │
    └─ setValues (parameters)
           └─ Material.setValues (inherited)
```

### データフロー図

```
[入力]                      [処理]                         [出力]

parameters ────────▶ constructor() ────────▶ MeshDepthMaterial
  (depthPacking,       - super()呼び出し       インスタンス
   map, alphaMap,      - プロパティ初期化        (深度シェーダーで
   displacementMap,    - setValues()適用         使用される
   wireframe, etc.)                              マテリアル設定)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Material.js | `src/materials/Material.js` | ソース | マテリアル基底クラス |
| MeshDepthMaterial.js | `src/materials/MeshDepthMaterial.js` | ソース | 深度マテリアル実装 |
| constants.js | `src/constants.js` | ソース | 定数定義（BasicDepthPacking, RGBADepthPacking等） |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベント管理 |
