# 機能設計書 59-LineBasicMaterial

## 概要

本ドキュメントは、Three.jsにおけるLineBasicMaterialクラスの機能設計を定義する。LineBasicMaterialは、ラインプリミティブをレンダリングするための基本マテリアルクラスである。

### 本機能の処理概要

LineBasicMaterialは、Line、LineLoop、LineSegmentsなどのラインジオメトリを描画するためのマテリアルである。シンプルな単色ラインの描画が可能で、ライン描画に特化したプロパティ（linewidth、linecap、linejoin）を持つ。

**業務上の目的・背景**：3Dシーンにおいて、ワイヤーフレーム、グラフ、パス、輪郭線などのライン描画が必要となる。LineBasicMaterialは、これらのライン要素を効率的に描画するための軽量なマテリアルを提供する。

**機能の利用シーン**：グラフやチャートの線描画、3Dオブジェクトの輪郭線、パスやトレイルの可視化、デバッグ用ワイヤーフレーム表示、GridHelperやAxesHelperなどのヘルパーオブジェクトに使用される。

**主要な処理内容**：
1. マテリアルの初期化とパラメータ設定
2. ライン色の設定
3. テクスチャマップによる色の変調
4. SVGRenderer向けのライン形状プロパティ設定

**関連システム・外部連携**：WebGLRenderer、WebGPURenderer、SVGRendererと連携。Line、LineLoop、LineSegmentsクラスと組み合わせて使用。

**権限による制御**：特になし。マテリアルの設定はすべてのユーザーが実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | （画面機能マッピングに登録なし） |

## 機能種別

マテリアル設定 / ラインシェーディング処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| color | Color/number/string | No | ラインの色（デフォルト: 0xffffff） | Color型で受け付け可能な値 |
| map | Texture | No | カラーマップ | Texture型またはnull |
| linewidth | number | No | ライン幅（デフォルト: 1） | 数値（WebGL/WebGPUでは常に1） |
| linecap | string | No | 線端の形状（デフォルト: 'round'） | 'butt', 'round', 'square' |
| linejoin | string | No | 線の結合部形状（デフォルト: 'round'） | 'round', 'bevel', 'miter' |
| fog | boolean | No | フォグの影響を受けるか（デフォルト: true） | true/false |

### 入力データソース

コンストラクタへのパラメータオブジェクト、またはプロパティへの直接代入

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isLineBasicMaterial | boolean | 型判定フラグ（常にtrue） |
| type | string | マテリアルタイプ（'LineBasicMaterial'） |
| マテリアルプロパティ | 各種 | 設定されたマテリアル属性 |

### 出力先

WebGLRenderer/WebGPURenderer/SVGRendererによるシェーダープログラムへの入力

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 親クラスMaterialのコンストラクタを呼び出し
2. 型フラグの設定
   └─ isLineBasicMaterial = true
3. マテリアルタイプの設定
   └─ type = 'LineBasicMaterial'
4. 色の初期化
   └─ color = new Color(0xffffff)
5. テクスチャマップの初期化
   └─ map = null
6. ライン形状プロパティの初期化
   └─ linewidth, linecap, linejoin
7. フォグ設定の初期化
   └─ fog = true
8. パラメータの適用
   └─ setValues(parameters)でパラメータを適用
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new LineBasicMaterial] --> B[super() 呼び出し]
    B --> C[isLineBasicMaterial = true]
    C --> D[type = 'LineBasicMaterial']
    D --> E[color = 0xffffff]
    E --> F[map = null]
    F --> G[linewidth/linecap/linejoin 初期化]
    G --> H[fog = true]
    H --> I[setValues parameters]
    I --> J[終了: マテリアルインスタンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | WebGL/WebGPUライン幅制限 | WebGL/WebGPUではlinewidthは常に1ピクセルで描画 | WebGL/WebGPU使用時 |
| BR-02 | SVGライン形状 | linecap、linejoinはSVGRendererでのみ有効 | SVGRenderer使用時 |
| BR-03 | ライト非対応 | ライティングの影響を受けない | 常時 |
| BR-04 | テクスチャ変調 | mapが設定されている場合、テクスチャ色とcolorを乗算 | map設定時 |

### 計算ロジック

最終色計算:
- map未設定時: finalColor = color
- map設定時: finalColor = color * textureColor

## データベース操作仕様

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | Warning | 未定義のプロパティを設定しようとした場合 | コンソールに警告を出力 |
| N/A | Warning | undefinedの値を設定しようとした場合 | コンソールに警告を出力し、設定をスキップ |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 非常に軽量な計算（ライティング計算不要）
- ラインプリミティブの高速描画に最適化

## セキュリティ考慮事項

特になし

## 備考

- WebGL/WebGPUではlinewidthプロパティは無視され、常に1ピクセル幅で描画される
- 太い線が必要な場合は、Line2やLineGeometryを使用する
- LineDashedMaterialの基底クラスとして機能する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、マテリアルの基本構造とLine固有のプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Material.js | `src/materials/Material.js` | マテリアルの基底クラス |
| 1-2 | LineBasicMaterial.js | `src/materials/LineBasicMaterial.js` | ラインマテリアル固有のプロパティ |

**読解のコツ**: LineBasicMaterialはMaterialを直接継承し、ライン描画専用のプロパティ（linewidth、linecap、linejoin）を追加する。これらのプロパティの多くはSVGRendererでのみ有効。

#### Step 2: エントリーポイントを理解する

マテリアルのインスタンス化と初期化プロセスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LineBasicMaterial.js | `src/materials/LineBasicMaterial.js` | constructorメソッドがエントリーポイント |

**主要処理フロー**:
1. **26-28行目**: コンストラクタでsuper()を呼び出し
2. **37行目**: isLineBasicMaterialフラグをtrueに設定
3. **39行目**: typeを'LineBasicMaterial'に設定
4. **47行目**: colorをnew Color(0xffffff)で初期化
5. **56行目**: mapをnullで初期化
6. **68行目**: linewidthを1で初期化
7. **78行目**: linecapを'round'で初期化
8. **88行目**: linejoinを'round'で初期化
9. **96行目**: fogをtrueで初期化
10. **98行目**: setValues(parameters)でパラメータを適用

#### Step 3: copyメソッドを理解する

マテリアルのクローン作成時の動作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LineBasicMaterial.js | `src/materials/LineBasicMaterial.js` | copyメソッド（102-118行目） |

**主要処理フロー**:
- **104行目**: 親クラスのcopyを呼び出し
- **106行目**: colorをコピー
- **108-114行目**: その他のプロパティをコピー

### プログラム呼び出し階層図

```
LineBasicMaterial (constructor)
    │
    ├─ Material (super())
    │      └─ EventDispatcher (super())
    │
    └─ setValues (parameters)
           └─ Material.setValues (inherited)
```

### データフロー図

```
[入力]                      [処理]                         [出力]

parameters ────────▶ constructor() ────────▶ LineBasicMaterial
  (color, map,          - super()呼び出し       インスタンス
   linewidth,           - プロパティ初期化        (ラインシェーダーで
   linecap, linejoin,   - setValues()適用         使用される
   fog)                                           マテリアル設定)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Material.js | `src/materials/Material.js` | ソース | マテリアル基底クラス |
| LineBasicMaterial.js | `src/materials/LineBasicMaterial.js` | ソース | ラインマテリアル実装 |
| LineDashedMaterial.js | `src/materials/LineDashedMaterial.js` | ソース | 破線マテリアル（派生クラス） |
| Color.js | `src/math/Color.js` | ソース | 色クラス |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベント管理 |
| Line.js | `src/objects/Line.js` | ソース | Lineオブジェクト |
| LineLoop.js | `src/objects/LineLoop.js` | ソース | LineLoopオブジェクト |
| LineSegments.js | `src/objects/LineSegments.js` | ソース | LineSegmentsオブジェクト |
