# 機能設計書 60-LineDashedMaterial

## 概要

本ドキュメントは、Three.jsにおけるLineDashedMaterialクラスの機能設計を定義する。LineDashedMaterialは、破線（ダッシュ線）スタイルでラインプリミティブをレンダリングするためのマテリアルクラスである。

### 本機能の処理概要

LineDashedMaterialは、LineBasicMaterialを継承し、破線パターンを描画するための追加プロパティを持つ。ダッシュのサイズ、ギャップのサイズ、全体のスケールを制御することで、様々な破線パターンを実現できる。

**業務上の目的・背景**：3Dシーンにおいて、破線は様々な用途で使用される。選択状態の表示、非表示オブジェクトの輪郭、距離や境界の表現など、実線とは異なる視覚的表現が必要な場合に破線マテリアルが必要となる。

**機能の利用シーン**：選択オブジェクトのハイライト表示、隠線処理（Hidden Line Removal）の表現、測定線や寸法線の描画、グリッドやガイド線の表示、アニメーションパスの可視化に使用される。

**主要な処理内容**：
1. マテリアルの初期化とパラメータ設定
2. 親クラスLineBasicMaterialのプロパティ継承
3. ダッシュパターンパラメータの設定（scale、dashSize、gapSize）
4. ジオメトリの線分距離計算との連携

**関連システム・外部連携**：WebGLRenderer、WebGPURenderer、SVGRendererと連携。Line、LineLoop、LineSegmentsクラスと組み合わせて使用。使用前にジオメトリのcomputeLineDistances()メソッドを呼び出す必要がある。

**権限による制御**：特になし。マテリアルの設定はすべてのユーザーが実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | （画面機能マッピングに登録なし） |

## 機能種別

マテリアル設定 / 破線シェーディング処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| color | Color/number/string | No | ラインの色（継承、デフォルト: 0xffffff） | Color型で受け付け可能な値 |
| map | Texture | No | カラーマップ（継承） | Texture型またはnull |
| linewidth | number | No | ライン幅（継承、デフォルト: 1） | 数値（WebGL/WebGPUでは常に1） |
| linecap | string | No | 線端の形状（継承、デフォルト: 'round'） | 'butt', 'round', 'square' |
| linejoin | string | No | 線の結合部形状（継承、デフォルト: 'round'） | 'round', 'bevel', 'miter' |
| fog | boolean | No | フォグの影響を受けるか（継承、デフォルト: true） | true/false |
| scale | number | No | ダッシュパターンのスケール（デフォルト: 1） | 正の数値 |
| dashSize | number | No | ダッシュ（線）の長さ（デフォルト: 3） | 正の数値 |
| gapSize | number | No | ギャップ（隙間）の長さ（デフォルト: 1） | 正の数値 |

### 入力データソース

コンストラクタへのパラメータオブジェクト、またはプロパティへの直接代入

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isLineDashedMaterial | boolean | 型判定フラグ（常にtrue） |
| type | string | マテリアルタイプ（'LineDashedMaterial'） |
| マテリアルプロパティ | 各種 | 設定されたマテリアル属性 |

### 出力先

WebGLRenderer/WebGPURenderer/SVGRendererによるシェーダープログラムへの入力

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 親クラスLineBasicMaterialのコンストラクタを呼び出し
2. 型フラグの設定
   └─ isLineDashedMaterial = true
3. マテリアルタイプの設定
   └─ type = 'LineDashedMaterial'
4. ダッシュパラメータの初期化
   └─ scale = 1
   └─ dashSize = 3
   └─ gapSize = 1
5. パラメータの適用
   └─ setValues(parameters)でパラメータを適用
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new LineDashedMaterial] --> B[super() 呼び出し]
    B --> C[isLineDashedMaterial = true]
    C --> D[type = 'LineDashedMaterial']
    D --> E[scale = 1]
    E --> F[dashSize = 3]
    F --> G[gapSize = 1]
    G --> H[setValues parameters]
    H --> I[終了: マテリアルインスタンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 線分距離計算必須 | 使用前にジオメトリのcomputeLineDistances()を呼び出す必要がある | 常時 |
| BR-02 | ダッシュパターン計算 | dashSize + gapSizeの繰り返しパターンでラインを描画 | 常時 |
| BR-03 | スケール適用 | scaleパラメータでパターン全体を拡大縮小 | 常時 |
| BR-04 | ライト非対応 | ライティングの影響を受けない | 常時 |

### 計算ロジック

ダッシュパターン計算:
- パターン長 = (dashSize + gapSize) * scale
- 線分位置がdashSize * scale未満なら描画、それ以外は非描画
- この計算はシェーダー内でlineDistance属性を使用して行われる

## データベース操作仕様

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | Warning | 未定義のプロパティを設定しようとした場合 | コンソールに警告を出力 |
| N/A | Warning | undefinedの値を設定しようとした場合 | コンソールに警告を出力し、設定をスキップ |
| N/A | 表示異常 | computeLineDistances()未呼び出し | ダッシュが正しく表示されない |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- ダッシュ計算はシェーダー内で実行（高速）
- computeLineDistances()は初回のみ必要

## セキュリティ考慮事項

特になし

## 備考

- LineBasicMaterialのすべてのプロパティを継承
- WebGL/WebGPUではlinewidthプロパティは無視され、常に1ピクセル幅で描画される
- 太い破線が必要な場合は、Line2系のクラスを使用する
- ジオメトリが変更された場合はcomputeLineDistances()を再度呼び出す必要がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、基底クラスの構造とDashed固有のプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Material.js | `src/materials/Material.js` | マテリアルの基底クラス |
| 1-2 | LineBasicMaterial.js | `src/materials/LineBasicMaterial.js` | ラインマテリアルの基底クラス |
| 1-3 | LineDashedMaterial.js | `src/materials/LineDashedMaterial.js` | 破線マテリアル固有のプロパティ |

**読解のコツ**: LineDashedMaterialはLineBasicMaterialを継承し、破線パターン制御用の3つのプロパティ（scale、dashSize、gapSize）を追加するシンプルな構造。

#### Step 2: エントリーポイントを理解する

マテリアルのインスタンス化と初期化プロセスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LineDashedMaterial.js | `src/materials/LineDashedMaterial.js` | constructorメソッドがエントリーポイント |

**主要処理フロー**:
1. **30-32行目**: コンストラクタでsuper()を呼び出し（LineBasicMaterialの初期化）
2. **41行目**: isLineDashedMaterialフラグをtrueに設定
3. **42行目**: typeを'LineDashedMaterial'に設定
4. **50行目**: scaleを1で初期化
5. **58行目**: dashSizeを3で初期化
6. **66行目**: gapSizeを1で初期化
7. **68行目**: setValues(parameters)でパラメータを適用

#### Step 3: copyメソッドを理解する

マテリアルのクローン作成時の動作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LineDashedMaterial.js | `src/materials/LineDashedMaterial.js` | copyメソッド（72-82行目） |

**主要処理フロー**:
- **74行目**: 親クラス（LineBasicMaterial）のcopyを呼び出し
- **76-78行目**: scale、dashSize、gapSizeをコピー

### プログラム呼び出し階層図

```
LineDashedMaterial (constructor)
    │
    ├─ LineBasicMaterial (super())
    │      │
    │      └─ Material (super())
    │             └─ EventDispatcher (super())
    │
    └─ setValues (parameters)
           └─ Material.setValues (inherited)
```

### データフロー図

```
[入力]                      [処理]                         [出力]

parameters ────────▶ constructor() ────────▶ LineDashedMaterial
  (color, map,          - super()呼び出し       インスタンス
   linewidth,           - プロパティ初期化        (破線シェーダーで
   scale, dashSize,     - setValues()適用         使用される
   gapSize, fog)                                  マテリアル設定)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Material.js | `src/materials/Material.js` | ソース | マテリアル基底クラス |
| LineBasicMaterial.js | `src/materials/LineBasicMaterial.js` | ソース | ラインマテリアル基底クラス |
| LineDashedMaterial.js | `src/materials/LineDashedMaterial.js` | ソース | 破線マテリアル実装 |
| Color.js | `src/math/Color.js` | ソース | 色クラス |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベント管理 |
| Line.js | `src/objects/Line.js` | ソース | Lineオブジェクト |
| BufferGeometry.js | `src/core/BufferGeometry.js` | ソース | computeLineDistances()メソッド定義 |
