# 機能設計書 62-SpriteMaterial

## 概要

本ドキュメントは、Three.jsライブラリにおけるスプライト描画用マテリアル「SpriteMaterial」の機能設計について記述する。SpriteMaterialは、Spriteオブジェクトと組み合わせて使用され、常にカメラに正対する2D平面（ビルボード）の外観を定義する。

### 本機能の処理概要

SpriteMaterialは、3Dシーン内でスプライト（ビルボード）を描画する際の見た目を定義するマテリアルクラスである。スプライトは常にカメラを向くため、どの角度から見ても同じように見える2D画像を3D空間に配置できる。

**業務上の目的・背景**：3Dゲームやアプリケーションでは、木、草、パーティクル、UIアイコン、ラベルなど、常にカメラを向いて表示される2D要素が必要になる場面が多い。従来の3Dモデルで表現すると計算コストが高くなるこれらの要素を、スプライト技術で効率的に描画することで、パフォーマンスと視覚的品質のバランスを取ることができる。SpriteMaterialは、このようなビルボードスプライトの外観（テクスチャ、色、回転、透明度など）を定義し、レンダラーに適切な描画パラメータを提供する。

**機能の利用シーン**：
- ゲーム内のパーティクルエフェクト（爆発、魔法効果など）
- 3Dシーン内のラベルやアイコン表示
- 遠景の木や草（ビルボード草木）
- キャラクターの頭上に表示する名前タグ
- ミニマップ上のマーカー表示

**主要な処理内容**：
1. マテリアルプロパティの初期化（色、テクスチャマップ、回転など）
2. 透明度のデフォルト有効化（スプライトは通常透明部分を含む）
3. パラメータオブジェクトからのプロパティ設定
4. マテリアルの複製機能提供

**関連システム・外部連携**：WebGLRenderer/WebGPURendererと連携してGPUへの描画命令を発行。Spriteオブジェクトと組み合わせて使用される。

**権限による制御**：特になし（クライアントサイドライブラリ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | Menubar - Add | 補助機能 | スプライトの追加 |

## 機能種別

データ定義 / 外観設定

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| color | number/Color/string | No | スプライトの色（デフォルト: 0xffffff） | Color.setで受け付ける形式 |
| map | Texture | No | カラーマップテクスチャ | Textureインスタンス |
| alphaMap | Texture | No | アルファマップ（透明度制御用グレースケールテクスチャ） | Textureインスタンス |
| rotation | number | No | スプライトの回転角度（ラジアン、デフォルト: 0） | 数値 |
| sizeAttenuation | boolean | No | カメラ距離によるサイズ減衰（デフォルト: true） | boolean |
| fog | boolean | No | フォグの影響を受けるか（デフォルト: true） | boolean |

### 入力データソース

コンストラクタのparametersオブジェクトから入力。Material基底クラスのプロパティも継承して使用可能。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isSpriteMaterial | boolean | 型判定用フラグ（常にtrue） |
| type | string | マテリアルタイプ識別子（'SpriteMaterial'） |
| color | Color | マテリアルの色 |
| map | Texture/null | カラーマップテクスチャ |
| alphaMap | Texture/null | アルファマップテクスチャ |
| rotation | number | 回転角度（ラジアン） |
| sizeAttenuation | boolean | サイズ減衰フラグ |
| transparent | boolean | 透明度フラグ（デフォルトtrue） |
| fog | boolean | フォグ影響フラグ |

### 出力先

レンダラー（WebGLRenderer/WebGPURenderer）に描画パラメータとして提供される。

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ Material基底クラスのコンストラクタ実行
2. デフォルトプロパティの初期化
   └─ isSpriteMaterial, type, color, map, alphaMap, rotation, sizeAttenuation, transparent, fog
3. setValues(parameters)でパラメータ適用
   └─ Material基底クラスのsetValuesメソッドで各プロパティを設定
4. レンダリング時にレンダラーがプロパティを参照
   └─ Spriteシェーダーへユニフォームとして渡される
```

### フローチャート

```mermaid
flowchart TD
    A[new SpriteMaterial] --> B[super - Material初期化]
    B --> C[デフォルト値設定]
    C --> D[transparent = true]
    D --> E{parameters存在?}
    E -->|Yes| F[setValues実行]
    E -->|No| G[初期化完了]
    F --> G
    G --> H[Spriteオブジェクトに適用]
    H --> I[レンダラーでビルボード描画]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-62-1 | デフォルト透明 | SpriteMaterialはデフォルトでtransparent=trueが設定される | 常時 |
| BR-62-2 | サイズ減衰 | sizeAttenuationがtrueの場合、透視投影カメラでのみ距離による減衰が適用される | PerspectiveCamera使用時 |
| BR-62-3 | 回転単位 | rotationプロパティはラジアン単位で指定する | rotation使用時 |
| BR-62-4 | アルファマップ | alphaMapはグレースケール画像として扱われ、緑チャンネルが使用される | alphaMap指定時 |

### 計算ロジック

スプライトの回転は、シェーダー内で以下のように適用される:
```
回転後の座標 = 回転行列(rotation) * 元の座標
```

## データベース操作仕様

該当なし（クライアントサイドライブラリ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | 未定義のパラメータを渡した場合 | コンソールに警告を出力 |
| - | 警告 | undefinedの値を持つパラメータを渡した場合 | コンソールに警告を出力、スキップ |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- スプライトは3Dメッシュより描画コストが低い
- 大量のスプライト使用時はInstancedMeshの検討を推奨
- テクスチャアトラスの使用で描画バッチ効率向上

## セキュリティ考慮事項

特になし（クライアントサイドライブラリ）

## 備考

- Spriteオブジェクトと組み合わせて使用
- ビルボード効果（常にカメラを向く）はSpriteオブジェクト側で実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、SpriteMaterialが継承するMaterialクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Material.js | `src/materials/Material.js` | 基底クラスのプロパティ（opacity、transparent等）とsetValuesメソッド |
| 1-2 | Color.js | `src/math/Color.js` | colorプロパティで使用されるColorクラス |

**読解のコツ**: Material.jsのtransparentプロパティ（119-122行目）がデフォルトfalseであることを確認し、SpriteMaterialでtrueに上書きされることを理解する。

#### Step 2: エントリーポイントを理解する

SpriteMaterialクラス自体の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SpriteMaterial.js | `src/materials/SpriteMaterial.js` | クラス全体（137行程度の簡潔な実装） |

**主要処理フロー**:
1. **18-29行目**: クラス定義とコンストラクタ開始
2. **33-40行目**: isSpriteMaterialフラグ、type設定
3. **44-50行目**: colorプロパティ初期化
4. **52-60行目**: mapプロパティ（テクスチャ）
5. **62-75行目**: alphaMapプロパティ
6. **77-83行目**: rotationプロパティ（回転角度）
7. **85-91行目**: sizeAttenuationプロパティ
8. **93-100行目**: transparentプロパティ（デフォルトtrue、**重要**）
9. **102-108行目**: fogプロパティ
10. **110行目**: setValuesでパラメータ適用
11. **114-132行目**: copyメソッドの実装

#### Step 3: 使用されるオブジェクトを理解する

SpriteMaterialが適用されるSpriteオブジェクトを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Sprite.js | `src/objects/Sprite.js` | SpriteMaterialを使用するオブジェクトの実装、ビルボード処理 |

### プログラム呼び出し階層図

```
SpriteMaterial (継承: Material)
    │
    ├─ constructor(parameters)
    │      │
    │      ├─ super() → Material.constructor()
    │      │                 └─ EventDispatcher()
    │      │
    │      ├─ this.transparent = true  ← 重要な違い
    │      │
    │      └─ setValues(parameters)
    │               └─ Material.setValues()
    │
    ├─ copy(source)
    │      └─ super.copy(source) → Material.copy()
    │
    └─ [レンダリング時]
           └─ WebGLRenderer.renderSprite()
                   └─ Spriteシェーダーへユニフォーム送信
```

### データフロー図

```
[入力]                    [処理]                         [出力]

parameters ───────▶ SpriteMaterial.constructor()
{                           │
  color: 0xff0000,          ├─ プロパティ初期化
  rotation: Math.PI/4,      ├─ transparent = true (強制)
  map: texture              └─ setValues() ───────▶ マテリアルインスタンス
}                                                        │
                                                         │
                                                         ▼
                                              Spriteオブジェクト
                                                         │
                                              (ビルボード変換)
                                                         │
                                                         ▼
                                              WebGLRenderer.render()
                                                         │
                                                         ▼
                                              常にカメラを向く
                                              2D平面として描画
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SpriteMaterial.js | `src/materials/SpriteMaterial.js` | ソース | SpriteMaterialクラス定義 |
| Material.js | `src/materials/Material.js` | ソース | 基底マテリアルクラス |
| Color.js | `src/math/Color.js` | ソース | 色管理クラス |
| Sprite.js | `src/objects/Sprite.js` | ソース | スプライトオブジェクトクラス |
| WebGLRenderer.js | `src/renderers/WebGLRenderer.js` | ソース | WebGLレンダラー |
| sprite.glsl.js | `src/renderers/shaders/ShaderLib/sprite.glsl.js` | シェーダー | スプライト描画用シェーダー |
