# 機能設計書 71-HemisphereLight

## 概要

本ドキュメントは、Three.jsライブラリにおけるHemisphereLight（半球光）機能の設計を記述する。HemisphereLightは、シーンの上方から下方に向かって色が変化するグラデーション照明を提供する光源である。

### 本機能の処理概要

HemisphereLightは、3Dシーンにおいて環境光に近い自然な照明効果を実現する光源クラスである。上空からの光（skyColor）と地面からの反射光（groundColor）を組み合わせることで、より現実的な環境照明をシミュレートする。

**業務上の目的・背景**：3Dグラフィックスにおいて、均一な環境光（AmbientLight）では表現できない、空と地面からの間接光をシミュレートする必要がある。特に屋外シーンでは、空からの青みがかった光と地面からの暖かい反射光が混在しており、HemisphereLightはこのような照明環境を簡潔かつ効率的に再現する。単一の光源で自然な環境照明を実現でき、複数の光源を配置するよりも計算コストを抑えられる。

**機能の利用シーン**：屋外シーンの環境照明、フォトリアリスティックなレンダリング、ゲームやシミュレーションにおける昼夜の表現、建築ビジュアライゼーションにおける自然光の再現。

**主要な処理内容**：
1. 上空色（skyColor）と地面色（groundColor）の2つの色を管理
2. 光の強度（intensity）を制御
3. Lightクラスを継承し、シーングラフに配置可能
4. JSONシリアライズ/デシリアライズに対応
5. copyメソッドによる光源の複製機能

**関連システム・外部連携**：WebGLRendererおよびWebGPURendererと連携し、シェーダーに半球光のデータを渡してライティング計算を行う。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | Menubar - Add | 補助機能 | 半球光の追加 |

## 機能種別

照明制御 / オブジェクト生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| skyColor | number/Color/string | No | 上空からの光の色（デフォルト: 0xffffff） | Color型に変換可能な値 |
| groundColor | number/Color/string | No | 地面からの光の色（デフォルト: 0xffffff） | Color型に変換可能な値 |
| intensity | number | No | 光の強度（デフォルト: 1） | 数値型 |

### 入力データソース

JavaScriptコードからのコンストラクタ呼び出し、またはObjectLoaderによるJSONファイルからの読み込み。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isHemisphereLight | boolean | 型識別フラグ（常にtrue） |
| type | string | オブジェクト種別（'HemisphereLight'） |
| color | Color | 上空色（継承） |
| groundColor | Color | 地面色 |
| intensity | number | 光の強度 |
| position | Vector3 | 光源の位置（デフォルトはDEFAULT_UP） |

### 出力先

3Dシーングラフ、WebGLシェーダーへのユニフォーム変数

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ Lightクラスの初期化（skyColor, intensity）
2. 型識別フラグの設定
   └─ isHemisphereLight = true
3. 位置の初期化
   └─ Object3D.DEFAULT_UP（0, 1, 0）をコピー
4. 行列の更新
   └─ updateMatrix()の呼び出し
5. groundColorの設定
   └─ Colorオブジェクトとして保存
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Lightコンストラクタ呼び出し]
    B --> C[isHemisphereLight = true]
    C --> D[type = 'HemisphereLight']
    D --> E[position = DEFAULT_UP]
    E --> F[updateMatrix]
    F --> G[groundColor = new Color]
    G --> H[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-71-1 | 影の非対応 | HemisphereLightは影を生成できない | 常時 |
| BR-71-2 | 位置の意味 | positionは光の向きを決定（光源からの距離は無関係） | 常時 |
| BR-71-3 | 色の補間 | 法線の方向に基づいてskyColorとgroundColorが補間される | レンダリング時 |

### 計算ロジック

半球光の計算は、サーフェスの法線方向と光源の方向（position）の内積に基づいて行われる。法線が真上を向いている場合はskyColor、真下を向いている場合はgroundColorが適用され、その間は線形補間される。

## データベース操作仕様

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | 不正な色値が渡された場合 | Colorクラスがデフォルト値を使用 |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- 単一インスタンスの生成は即座に完了すること（1ms以下）
- 複数のHemisphereLightをシーンに配置可能だが、パフォーマンスへの影響を考慮する必要がある

## セキュリティ考慮事項

特になし。

## 備考

- HemisphereLightはターゲットを持たないため、向きはpositionのみで決定される
- 初期位置が(0, 1, 0)に設定されるのは、これが一般的な「上向き」の方向であるため

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、半球光が持つプロパティとその型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Color.js | `src/math/Color.js` | 色の管理方法とコンストラクタの挙動 |
| 1-2 | Light.js | `src/lights/Light.js` | 基底クラスのプロパティ（color, intensity） |

**読解のコツ**: Colorクラスは数値、文字列、Colorオブジェクトを受け取れる柔軟なコンストラクタを持つ。

#### Step 2: エントリーポイントを理解する

HemisphereLightクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HemisphereLight.js | `src/lights/HemisphereLight.js` | クラス全体の構造 |

**主要処理フロー**:
1. **27-29行目**: コンストラクタでLightクラスを初期化
2. **38行目**: isHemisphereLightフラグの設定
3. **42-43行目**: 位置の初期化とマトリックス更新
4. **50行目**: groundColorの設定

#### Step 3: 継承関係を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Light.js | `src/lights/Light.js` | Lightクラスの構造（11-85行目） |
| 3-2 | Object3D.js | `src/core/Object3D.js` | 3Dオブジェクトの基本機能 |

**主要処理フロー**:
- **Light.js 19-48行目**: コンストラクタでcolor, intensityを設定
- **Light.js 61-68行目**: copyメソッドの実装

### プログラム呼び出し階層図

```
HemisphereLight
    │
    ├─ extends Light
    │      │
    │      ├─ extends Object3D
    │      │      └─ extends EventDispatcher
    │      │
    │      └─ uses Color (for color property)
    │
    └─ uses Color (for groundColor property)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

skyColor (引数) ────────▶ Lightコンストラクタ ────────────▶ this.color
groundColor (引数) ─────▶ new Color() ────────────────────▶ this.groundColor
intensity (引数) ───────▶ Lightコンストラクタ ────────────▶ this.intensity
DEFAULT_UP ─────────────▶ position.copy() ────────────────▶ this.position
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HemisphereLight.js | `src/lights/HemisphereLight.js` | ソース | 半球光クラスの実装 |
| Light.js | `src/lights/Light.js` | ソース | 光源の基底クラス |
| Object3D.js | `src/core/Object3D.js` | ソース | 3Dオブジェクトの基底クラス |
| Color.js | `src/math/Color.js` | ソース | 色の管理クラス |
