# 機能設計書 72-RectAreaLight

## 概要

本ドキュメントは、Three.jsライブラリにおけるRectAreaLight（矩形エリアライト）機能の設計を記述する。RectAreaLightは、矩形平面から均一に光を放射する面光源であり、より現実的な照明効果を実現する。

### 本機能の処理概要

RectAreaLightは、矩形の面から均一に光を放射する光源クラスである。点光源やスポットライトとは異なり、面積を持つ光源として機能し、より柔らかく自然な影と照明効果を生成する。窓からの光やストリップライトなどの実世界の光源をシミュレートするのに適している。

**業務上の目的・背景**：フォトリアリスティックなレンダリングにおいて、点光源では表現できない面光源の効果が求められる。蛍光灯、窓からの自然光、ソフトボックスライトなど、現実世界の多くの光源は面積を持っており、RectAreaLightはこれらをシミュレートする。特にPBR（物理ベースレンダリング）マテリアルと組み合わせることで、高品質な照明表現が可能になる。

**機能の利用シーン**：インテリアビジュアライゼーション、製品レンダリング、建築ビジュアライゼーション、フォトリアリスティックな3Dシーンの制作、ソフトシャドウ効果が必要なシーン。

**主要な処理内容**：
1. 矩形光源の色（color）、強度（intensity）、幅（width）、高さ（height）を管理
2. ルーメン単位の光量（power）をnits単位の強度（intensity）に変換
3. Lightクラスを継承し、シーングラフに配置可能
4. JSONシリアライズ/デシリアライズに対応

**関連システム・外部連携**：RectAreaLightUniformsLib（WebGLRenderer用）またはRectAreaLightTexturesLib（WebGPURenderer用）との連携が必須。PBRマテリアル（MeshStandardMaterial、MeshPhysicalMaterial）でのみ正常に動作する。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに登録なし |

## 機能種別

照明制御 / オブジェクト生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| color | number/Color/string | No | 光の色（デフォルト: 0xffffff） | Color型に変換可能な値 |
| intensity | number | No | 光の強度（nits単位、デフォルト: 1） | 数値型 |
| width | number | No | 光源の幅（デフォルト: 10） | 正の数値 |
| height | number | No | 光源の高さ（デフォルト: 10） | 正の数値 |

### 入力データソース

JavaScriptコードからのコンストラクタ呼び出し、またはObjectLoaderによるJSONファイルからの読み込み。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isRectAreaLight | boolean | 型識別フラグ（常にtrue） |
| type | string | オブジェクト種別（'RectAreaLight'） |
| color | Color | 光の色（継承） |
| intensity | number | 光の強度（nits単位） |
| width | number | 光源の幅 |
| height | number | 光源の高さ |
| power | number | 光量（ルーメン単位、計算プロパティ） |

### 出力先

3Dシーングラフ、WebGLシェーダーへのユニフォーム変数

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ Lightクラスの初期化（color, intensity）
2. 型識別フラグの設定
   └─ isRectAreaLight = true
3. サイズの設定
   └─ width, heightの保存
4. powerプロパティ（getter/setter）
   └─ intensity <-> power の相互変換
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Lightコンストラクタ呼び出し]
    B --> C[isRectAreaLight = true]
    C --> D[type = 'RectAreaLight']
    D --> E[width = 10, height = 10]
    E --> F[終了]

    G[powerの取得] --> H[intensity * width * height * PI を計算]
    I[powerの設定] --> J[power / width / height / PI を計算]
    J --> K[intensityに設定]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-72-1 | 影の非対応 | RectAreaLightは影を生成できない | 常時 |
| BR-72-2 | PBRマテリアル必須 | PBRマテリアル（MeshStandardMaterial、MeshPhysicalMaterial）でのみ動作 | 常時 |
| BR-72-3 | 初期化必須 | RectAreaLightUniformsLibまたはRectAreaLightTexturesLibの初期化が必要 | レンダリング前 |

### 計算ロジック

**power（ルーメン）とintensity（nits）の変換**：
- power（ルーメン） = intensity（nits） × width × height × PI
- intensity（nits） = power（ルーメン） / (width × height × PI)

この変換は、矩形面からの放射輝度と光束の物理的な関係に基づいている。

## データベース操作仕様

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 表示異常 | RectAreaLightUniformsLib/TexturesLib未初期化 | 初期化処理を追加 |
| - | 表示異常 | 非PBRマテリアルでの使用 | PBRマテリアルに変更 |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- 単一インスタンスの生成は即座に完了すること（1ms以下）
- RectAreaLightは計算コストが高いため、シーン内での使用数に注意が必要

## セキュリティ考慮事項

特になし。

## 備考

- RectAreaLightはlookAt()メソッドを使用して光の向きを設定できる
- ヘルパークラス（RectAreaLightHelper）を使用して光源を可視化可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

RectAreaLightが持つプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Light.js | `src/lights/Light.js` | 基底クラスのプロパティ（color, intensity） |

**読解のコツ**: RectAreaLightはシンプルな構造だが、powerプロパティのgetter/setterが特徴的。

#### Step 2: エントリーポイントを理解する

RectAreaLightクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RectAreaLight.js | `src/lights/RectAreaLight.js` | クラス全体の構造 |

**主要処理フロー**:
1. **38-40行目**: コンストラクタでLightクラスを初期化
2. **49行目**: isRectAreaLightフラグの設定
3. **59行目**: width の設定（デフォルト10）
4. **67行目**: height の設定（デフォルト10）
5. **77-88行目**: powerプロパティのgetter/setter

#### Step 3: 物理ベースの計算を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RectAreaLight.js | `src/lights/RectAreaLight.js` | powerプロパティ（77-88行目） |

**主要処理フロー**:
- **79-80行目**: power getter - intensity * width * height * Math.PI
- **84-88行目**: power setter - power / (width * height * Math.PI)

### プログラム呼び出し階層図

```
RectAreaLight
    │
    ├─ extends Light
    │      │
    │      ├─ extends Object3D
    │      │      └─ extends EventDispatcher
    │      │
    │      └─ uses Color (for color property)
    │
    └─ power getter/setter
           └─ intensity との相互変換
```

### データフロー図

```
[入力]                    [処理]                           [出力]

color (引数) ───────────▶ Lightコンストラクタ ────────────▶ this.color
intensity (引数) ───────▶ Lightコンストラクタ ────────────▶ this.intensity
width (引数) ───────────▶ 直接代入 ───────────────────────▶ this.width
height (引数) ──────────▶ 直接代入 ───────────────────────▶ this.height

power (設定時) ─────────▶ power / width / height / PI ───▶ this.intensity
intensity (取得時) ─────▶ intensity * width * height * PI ▶ power
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RectAreaLight.js | `src/lights/RectAreaLight.js` | ソース | 矩形エリアライトクラスの実装 |
| Light.js | `src/lights/Light.js` | ソース | 光源の基底クラス |
| Object3D.js | `src/core/Object3D.js` | ソース | 3Dオブジェクトの基底クラス |
| Color.js | `src/math/Color.js` | ソース | 色の管理クラス |
