# 機能設計書 73-LightProbe

## 概要

本ドキュメントは、Three.jsライブラリにおけるLightProbe（ライトプローブ）機能の設計を記述する。LightProbeは、球面調和関数を使用して環境光をエンコードし、シーンに間接照明効果を提供する特殊な光源である。

### 本機能の処理概要

LightProbeは、従来の光源（DirectionalLight、PointLight等）とは異なり、光を放射しない代わりに3D空間を通過する光の情報を保存する。球面調和関数（Spherical Harmonics）を使用して環境光をエンコードし、レンダリング時にオブジェクトへの間接照明を近似する。これにより、環境マップから生成された拡散環境光を効率的にシミュレートできる。

**業務上の目的・背景**：リアルタイム3Dレンダリングにおいて、グローバルイルミネーション（大域照明）は計算コストが高い。LightProbeは、事前計算された球面調和関数を使用することで、低コストで環境光の近似を実現する。特にAR（拡張現実）アプリケーションでは、WebXRから取得した実世界の照明データを使用して、仮想オブジェクトを現実の照明環境に適合させることができる。

**機能の利用シーン**：環境マップベースの間接照明、AR/MRアプリケーションでの実世界照明の反映、静的なグローバルイルミネーションの近似、フォトリアリスティックなシーンでの拡散環境光。

**主要な処理内容**：
1. 球面調和関数（SphericalHarmonics3）による環境光のエンコード
2. 光の強度（intensity）の管理
3. LightProbeGeneratorによる環境マップからの自動生成
4. JSONシリアライズ/デシリアライズに対応

**関連システム・外部連携**：WebXR APIからの光推定データ取得、LightProbeGeneratorによるCubeTextureからの生成、PBRマテリアルとの連携。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに登録なし |

## 機能種別

照明制御 / 環境光シミュレーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sh | SphericalHarmonics3 | No | 球面調和関数（デフォルト: 新規SphericalHarmonics3） | SphericalHarmonics3型 |
| intensity | number | No | 光の強度（デフォルト: 1） | 数値型 |

### 入力データソース

- JavaScriptコードからのコンストラクタ呼び出し
- LightProbeGeneratorによるCubeTextureからの生成
- WebXR APIからの光推定データ
- ObjectLoaderによるJSONファイルからの読み込み

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isLightProbe | boolean | 型識別フラグ（常にtrue） |
| sh | SphericalHarmonics3 | 球面調和関数データ |
| intensity | number | 光の強度（継承） |

### 出力先

3Dシーングラフ、レンダラーへの環境光データ

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ Lightクラスの初期化（undefined, intensity）
2. 型識別フラグの設定
   └─ isLightProbe = true
3. 球面調和関数の設定
   └─ shプロパティに保存
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Lightコンストラクタ呼び出し]
    B --> C[isLightProbe = true]
    C --> D[sh = SphericalHarmonics3]
    D --> E[終了]

    F[環境マップから生成] --> G[LightProbeGenerator.fromCubeTexture]
    G --> H[球面調和関数を計算]
    H --> I[LightProbeを返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-73-1 | 拡散光のみ | LightProbeは拡散環境光のみをシミュレート（鏡面反射には環境マップが必要） | 常時 |
| BR-73-2 | color未使用 | colorプロパティは使用されない（undefinedが渡される） | 常時 |
| BR-73-3 | 影の非対応 | LightProbeは影を生成できない | 常時 |

### 計算ロジック

球面調和関数は9つの係数（3次まで）を使用して環境光を近似する。各係数は3成分（RGB）を持ち、合計27個の値で環境光分布をエンコードする。レンダリング時、サーフェスの法線方向に基づいて適切な光の色と強度が計算される。

## データベース操作仕様

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | 不正なSphericalHarmonics3が渡された場合 | デフォルト値を使用 |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- 単一インスタンスの生成は即座に完了すること（1ms以下）
- LightProbeGeneratorによる生成は環境マップのサイズに依存
- 球面調和関数の評価は低コストで実行される

## セキュリティ考慮事項

特になし。

## 備考

- LightProbeは機能的にはirradiance environment map（放射照度環境マップ）と等価
- WebXRでは実世界の照明を反映するために使用される
- colorプロパティは継承されるが使用されない（undefinedが渡される）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

球面調和関数の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SphericalHarmonics3.js | `src/math/SphericalHarmonics3.js` | 球面調和関数の9係数構造 |
| 1-2 | Light.js | `src/lights/Light.js` | 基底クラスのプロパティ |

**読解のコツ**: SphericalHarmonics3は9つのVector3係数を持ち、各係数がRGB成分を表す。

#### Step 2: エントリーポイントを理解する

LightProbeクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LightProbe.js | `src/lights/LightProbe.js` | クラス全体の構造 |

**主要処理フロー**:
1. **31行目**: コンストラクタでsh（デフォルト新規SphericalHarmonics3）とintensityを受け取る
2. **33行目**: Lightコンストラクタにundefinedを渡す（colorは使用しない）
3. **42行目**: isLightProbeフラグの設定
4. **49行目**: shプロパティの設定

#### Step 3: 関連処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LightProbe.js | `src/lights/LightProbe.js` | copyメソッド（53-61行目） |
| 3-2 | LightProbe.js | `src/lights/LightProbe.js` | toJSONメソッド（63-71行目） |

**主要処理フロー**:
- **57行目**: shのコピー
- **67行目**: shを配列としてJSON出力

### プログラム呼び出し階層図

```
LightProbe
    │
    ├─ extends Light
    │      │
    │      ├─ extends Object3D
    │      │      └─ extends EventDispatcher
    │      │
    │      └─ uses Color (継承されるが使用されない)
    │
    └─ uses SphericalHarmonics3
           └─ 9 x Vector3 coefficients
```

### データフロー図

```
[入力]                         [処理]                        [出力]

sh (引数/デフォルト) ─────────▶ 直接代入 ──────────────────▶ this.sh
intensity (引数) ─────────────▶ Lightコンストラクタ ────────▶ this.intensity
undefined ────────────────────▶ Lightコンストラクタ ────────▶ this.color (使用されない)

CubeTexture ──────────────────▶ LightProbeGenerator ───────▶ LightProbe
WebXR光推定データ ────────────▶ fromCubeTexture ───────────▶ this.sh
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LightProbe.js | `src/lights/LightProbe.js` | ソース | ライトプローブクラスの実装 |
| Light.js | `src/lights/Light.js` | ソース | 光源の基底クラス |
| SphericalHarmonics3.js | `src/math/SphericalHarmonics3.js` | ソース | 球面調和関数クラス |
| Object3D.js | `src/core/Object3D.js` | ソース | 3Dオブジェクトの基底クラス |
