# 機能設計書 87-Bone

## 概要

本ドキュメントは、Three.jsにおけるスケルトンを構成するボーン（骨）オブジェクト `Bone` クラスの機能設計を定義する。BoneはObject3Dを継承し、Skeletonの階層構造を構成する基本要素として機能する。

### 本機能の処理概要

Boneクラスは、Object3Dを継承した最小限のクラスであり、スケルトンアニメーションにおける関節や骨を表現する。複数のBoneを親子関係で階層化することで、人体の骨格構造やロボットのアーム構造などを表現できる。

**業務上の目的・背景**：スケルタルアニメーションでは、骨格の各関節をBoneとして表現し、親子関係により階層構造を構築する必要がある。Boneの変換（位置、回転）がSkinnedMeshの頂点に影響を与え、キャラクターやオブジェクトのアニメーションを実現する。

**機能の利用シーン**：
- 人体の骨格構造（肩、肘、手首などの関節）
- 動物やクリーチャーの骨格
- ロボットアームや機械の関節
- 顔のフェイシャルボーン
- カスタム変形アニメーション

**主要な処理内容**：
1. Object3Dの全機能を継承
2. isBoneフラグによる型判定
3. 親子関係による階層構造の構築
4. AnimationMixerによるアニメーション駆動

**関連システム・外部連携**：Skeleton、SkinnedMesh、AnimationMixer、SkeletonHelperと連携。

**権限による制御**：特になし（Three.jsはクライアントサイドライブラリ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | Bones Browser | 補助機能 | 個別ボーンの操作 |

## 機能種別

データオブジェクト / 階層構造要素

## 入力仕様

### 入力パラメータ

コンストラクタはパラメータを取らない。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | - | - |

### 入力データソース

特になし（Object3Dの機能を継承）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isBone | boolean | 型判定フラグ（常にtrue） |
| type | string | オブジェクトタイプ（'Bone'） |

※その他すべてのObject3Dプロパティを継承

### 出力先

Skeletonに登録され、SkinnedMeshのスキニング処理で参照される。

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ Object3Dの初期化、isBone/typeの設定
2. 親子関係の構築
   └─ add()で子ボーンを追加
3. アニメーション時
   └─ AnimationMixerが位置/回転/スケールを更新
4. レンダリング時
   └─ updateMatrixWorld()で行列を更新
```

### フローチャート

```mermaid
flowchart TD
    A[Bone生成] --> B[Object3D初期化]
    B --> C[isBone=true設定]
    C --> D[type='Bone'設定]
    D --> E[待機状態]
    E --> F{add呼び出し?}
    F -->|Yes| G[子Bone追加]
    G --> E
    F -->|No| H{アニメーション更新?}
    H -->|Yes| I[position/rotation更新]
    I --> J[updateMatrixWorld]
    J --> E
    H -->|No| E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-87-01 | 型判定 | isBone===trueでボーン判定が可能 | 常時 |
| BR-87-02 | 親子判定 | Skeleton.pose()で親がBoneか確認 | ポーズリセット時 |
| BR-87-03 | 変換継承 | 子ボーンは親ボーンの変換を継承 | 常時 |

### 計算ロジック

Object3Dから継承される行列計算のみ。

## データベース操作仕様

該当なし（Three.jsはクライアントサイドライブラリ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | - | - |

### リトライ仕様

特になし

## トランザクション仕様

該当なし

## パフォーマンス要件

- Boneは非常に軽量なクラス
- Object3Dの機能のみで追加処理なし

## セキュリティ考慮事項

特になし（クライアントサイドレンダリング）

## 備考

- BoneはObject3Dとほぼ同一だが、isBoneフラグで型判定が可能
- SkeletonHelperで可視化可能
- 通常はGLTFLoader等でインポートされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Boneクラスの非常にシンプルな構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Bone.js | `src/objects/Bone.js` | Boneクラス全体（非常に短い） |

**読解のコツ**: BoneはGroupと同様に最小限の実装であり、Object3Dの機能を完全に継承している。

#### Step 2: 継承元を理解する

Object3Dの基本機能を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Object3D.js | `src/core/Object3D.js` | position, rotation, quaternion, scale |

**主要処理フロー**:
- **140-226行目**: 位置・回転・スケールのプロパティ定義
- **744-785行目**: add()で子ボーンを追加
- **1163-1201行目**: updateMatrixWorld()で行列更新

#### Step 3: Boneの実装を確認

Boneクラスの全コードを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Bone.js | `src/objects/Bone.js` | 17-39行目の完全なクラス定義 |

**主要処理フロー**:
1. **22行目**: コンストラクタでsuper()呼び出し
2. **33行目**: `this.isBone = true`
3. **35行目**: `this.type = 'Bone'`

### プログラム呼び出し階層図

```
Bone
    │
    └─ Object3D (継承)
           │
           ├─ EventDispatcher (継承)
           │
           ├─ position (Vector3)
           │      └─ ボーンのローカル位置
           │
           ├─ rotation (Euler)
           │      └─ ボーンのローカル回転
           │
           ├─ quaternion (Quaternion)
           │      └─ 回転の四元数表現
           │
           ├─ scale (Vector3)
           │      └─ ボーンのローカルスケール
           │
           ├─ matrix (Matrix4)
           │      └─ ローカル変換行列
           │
           ├─ matrixWorld (Matrix4)
           │      └─ ワールド変換行列
           │
           └─ children[] (Object3D/Bone)
                  └─ 子ボーン配列
```

### データフロー図

```
[入力]                    [処理]                         [出力]

new Bone() ──────────▶ コンストラクタ ─────────▶ Bone Object
                            │                        │
                            │                        ├─ isBone: true
                            │                        ├─ type: 'Bone'
                            └────────────────────▶   └─ position/rotation/scale

parentBone.add(childBone) ▶ add() ─────────────▶ 親子関係構築
                              │
                              └─ childBone.parent = parentBone

AnimationMixer.update() ──▶ position/rotation更新 ─▶ matrix更新
                              │
                              └─ updateMatrixWorld()で子に伝播
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Bone.js | `src/objects/Bone.js` | ソース | ボーンのメインクラス |
| Object3D.js | `src/core/Object3D.js` | ソース | 3Dオブジェクト基底クラス |
| Skeleton.js | `src/objects/Skeleton.js` | ソース | ボーンを管理するスケルトン |
| SkinnedMesh.js | `src/objects/SkinnedMesh.js` | ソース | ボーンの影響を受けるメッシュ |
| SkeletonHelper.js | `src/helpers/SkeletonHelper.js` | ソース | ボーンの可視化ヘルパー |
| AnimationMixer.js | `src/animation/AnimationMixer.js` | ソース | アニメーション制御 |
| Vector3.js | `src/math/Vector3.js` | ソース | 3Dベクトル |
| Quaternion.js | `src/math/Quaternion.js` | ソース | 四元数（回転） |
| Euler.js | `src/math/Euler.js` | ソース | オイラー角 |
| Matrix4.js | `src/math/Matrix4.js` | ソース | 変換行列 |
