# 機能設計書 88-Texture

## 概要

本ドキュメントは、Three.jsにおけるテクスチャの基底クラス `Texture` の機能設計を定義する。Textureは画像データをGPUにアップロードし、マテリアルの外観を制御するために使用される基本的なクラスである。

### 本機能の処理概要

Textureクラスは、画像データ（Image、Canvas、Video等）を管理し、WebGLまたはWebGPUにテクスチャとしてアップロードするための基底クラスである。ラッピングモード、フィルタリング、ミップマップ、UV変換など、テクスチャに関するあらゆる設定を提供する。

**業務上の目的・背景**：3Dオブジェクトにリアルな外観を与えるために、画像をサーフェスにマッピングする機能が必要である。テクスチャはカラーマップ、法線マップ、環境マップなど多様な用途で使用され、PBR（物理ベースレンダリング）の実現にも不可欠である。

**機能の利用シーン**：
- 3Dモデルのカラーテクスチャ（diffuse map）
- 法線マップ、バンプマップ
- 環境マップ（キューブマップ、等距離円筒図法）
- アルファマップ（透明度制御）
- AO（アンビエントオクルージョン）マップ
- 動的テクスチャ（Canvas、Video）

**主要な処理内容**：
1. 画像データの管理（Sourceクラス経由）
2. テクスチャパラメータの設定（wrap, filter, format等）
3. UV変換マトリックスの計算
4. ミップマップの自動生成制御
5. needsUpdateによるGPUアップロードトリガー

**関連システム・外部連携**：Material（各種マップ）、WebGLRenderer、WebGPURenderer、TextureLoaderと連携。

**権限による制御**：特になし（Three.jsはクライアントサイドライブラリ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | Sidebar - Scene | 補助機能 | 背景テクスチャの設定 |
| 6 | Sidebar - Material | 補助機能 | テクスチャマップの設定 |

## 機能種別

データ管理 / GPU転送

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| image | Object | No | 画像データ（Image, Canvas, Video等） | デフォルト: null |
| mapping | number | No | マッピングタイプ | デフォルト: UVMapping |
| wrapS | number | No | 水平ラッピング | デフォルト: ClampToEdgeWrapping |
| wrapT | number | No | 垂直ラッピング | デフォルト: ClampToEdgeWrapping |
| magFilter | number | No | 拡大フィルタ | デフォルト: LinearFilter |
| minFilter | number | No | 縮小フィルタ | デフォルト: LinearMipmapLinearFilter |
| format | number | No | テクスチャフォーマット | デフォルト: RGBAFormat |
| type | number | No | データ型 | デフォルト: UnsignedByteType |
| anisotropy | number | No | 異方性フィルタリング | デフォルト: 1 |
| colorSpace | string | No | カラースペース | デフォルト: NoColorSpace |

### 入力データソース

- Image/HTMLImageElement: 画像ファイル
- HTMLCanvasElement: Canvas描画結果
- HTMLVideoElement: 動画フレーム
- ImageBitmap: ビットマップ画像
- TypedArray: 生データ（DataTexture用）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isTexture | boolean | 型判定フラグ（常にtrue） |
| id | number | テクスチャID（自動生成） |
| uuid | string | テクスチャUUID |
| source | Source | 画像データソース |
| mapping | number | マッピングタイプ |
| wrapS/wrapT | number | ラッピングモード |
| magFilter/minFilter | number | フィルタリングモード |
| format/type | number | フォーマット/データ型 |
| offset/repeat/center/rotation | Vector2/number | UV変換パラメータ |
| matrix | Matrix3 | UV変換マトリックス |
| version | number | 更新バージョン |

### 出力先

WebGL/WebGPUテクスチャユニットにバインドされ、シェーダーで参照される。

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ プロパティ初期化、Sourceオブジェクト生成
2. 画像ロード完了
   └─ needsUpdate = true設定
3. レンダリング時
   └─ バージョンチェック → GPUアップロード → テクスチャパラメータ設定
4. UV変換時
   └─ updateMatrix()でmatrixを計算
5. 破棄時
   └─ dispose()でGPUリソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[Texture生成] --> B[プロパティ初期化]
    B --> C[Source生成]
    C --> D[待機状態]
    D --> E{needsUpdate?}
    E -->|Yes| F[バージョン++]
    F --> G[Source.needsUpdate=true]
    G --> H[GPUアップロード]
    H --> D
    E -->|No| I{matrixAutoUpdate?}
    I -->|Yes| J[updateMatrix呼び出し]
    J --> K[レンダリング使用]
    I -->|No| K
    K --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-88-01 | 不変性 | 初回使用後はdimensions/format/typeを変更不可 | 使用開始後 |
| BR-88-02 | NPOT制限 | 非2のべき乗サイズはwrap/mipmapに制限あり | WebGL1 |
| BR-88-03 | flipY | 画像は垂直反転してアップロード（デフォルト） | 通常のテクスチャ |
| BR-88-04 | colorSpace | カラーテクスチャはSRGBColorSpace推奨 | カラーマップ使用時 |
| BR-88-05 | 自動更新 | matrixAutoUpdate=trueでUV変換マトリックス自動計算 | 常時 |

### 計算ロジック

UV変換マトリックスの計算:
```javascript
// offset, repeat, rotation, centerからマトリックスを構築
matrix.setUvTransform(offset.x, offset.y, repeat.x, repeat.y, rotation, center.x, center.y);
```

## データベース操作仕様

該当なし（Three.jsはクライアントサイドライブラリ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | setValues()に未定義キーを渡した | コンソールに警告 |
| - | 警告 | setValues()で存在しないプロパティを参照 | コンソールに警告 |

### リトライ仕様

特になし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 初回アップロード後はGPU側でキャッシュ
- updateRangesで部分更新可能
- 異方性フィルタリングはGPU負荷が高い

## セキュリティ考慮事項

- CORSポリシーにより他ドメインの画像は制限される場合がある
- クロスオリジン画像使用時はcrossOrigin設定が必要

## 備考

- disposeイベントをリッスンしてカスタムクリーンアップ可能
- onUpdateコールバックでテクスチャ更新時の処理をフック可能
- Source共有により複数テクスチャで同一画像を効率的に使用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テクスチャの基本構造とSourceクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Source.js | `src/textures/Source.js` | 画像データの管理クラス |
| 1-2 | constants.js | `src/constants.js` | wrap, filter, format定数 |

**読解のコツ**: Textureとimageの関係はSourceを介して間接参照される設計。

#### Step 2: エントリーポイントを理解する

Textureクラス本体を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Texture.js | `src/textures/Texture.js` | メインクラス |

**主要処理フロー**:
1. **48-371行目**: コンストラクタで全プロパティを初期化
2. **376-398行目**: width/height/depth getter（Sourceから取得）
3. **404-415行目**: image getter/setter（Source.data経由）
4. **421-425行目**: updateMatrix()でUV変換マトリックス計算
5. **636-646行目**: dispose()でdisposeイベント発行
6. **743-752行目**: needsUpdate setter（version++、Source更新）

#### Step 3: UV変換を理解する

UV座標変換の処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Texture.js | `src/textures/Texture.js` | transformUv()メソッド |

**主要処理フロー**:
- **654-732行目**: transformUv()でwrap, flipYを適用

### プログラム呼び出し階層図

```
Texture
    │
    ├─ EventDispatcher (継承)
    │      └─ dispose, update イベント
    │
    ├─ Source (source)
    │      ├─ data (Image/Canvas/Video等)
    │      ├─ version (更新カウンタ)
    │      └─ getSize() (dimensions取得)
    │
    ├─ プロパティ群
    │      ├─ mapping (UVMapping等)
    │      ├─ wrapS/wrapT (Wrapping)
    │      ├─ magFilter/minFilter (Filtering)
    │      ├─ format/type (Data format)
    │      └─ offset/repeat/center/rotation (UV変換)
    │
    ├─ matrix (Matrix3)
    │      └─ UV変換マトリックス
    │
    ├─ updateMatrix()
    │      └─ offset/repeat/rotation/centerからmatrix計算
    │
    ├─ transformUv()
    │      └─ UV座標にwrap/flipY適用
    │
    └─ dispose()
           └─ disposeイベント発行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Image/Canvas/Video ───▶ Texture Constructor ──▶ Texture Object
                            │                        │
                            │                        ├─ isTexture: true
                            └─ Source生成             ├─ source
                                                     ├─ mapping/wrap/filter
                                                     └─ offset/repeat等

needsUpdate = true ───▶ version++ ─────────────▶ GPU Upload Trigger
                            │
                            └─ source.needsUpdate = true

offset/repeat/rotation ▶ updateMatrix() ────────▶ matrix (Matrix3)
                            │
                            └─ setUvTransform()

UV座標 ───────────────▶ transformUv() ──────────▶ 変換後UV
                            │
                            ├─ matrix適用
                            ├─ wrap処理
                            └─ flipY処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Texture.js | `src/textures/Texture.js` | ソース | テクスチャ基底クラス |
| Source.js | `src/textures/Source.js` | ソース | 画像データソース |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベントシステム |
| Vector2.js | `src/math/Vector2.js` | ソース | 2Dベクトル（offset/repeat等） |
| Matrix3.js | `src/math/Matrix3.js` | ソース | UV変換マトリックス |
| MathUtils.js | `src/math/MathUtils.js` | ソース | UUID生成 |
| constants.js | `src/constants.js` | ソース | 定数（wrap, filter, format等） |
| TextureLoader.js | `src/loaders/TextureLoader.js` | ソース | テクスチャローダー |
