# 機能設計書 89-DataTexture

## 概要

本ドキュメントは、Three.jsにおける生バッファデータからテクスチャを生成する `DataTexture` クラスの機能設計を定義する。DataTextureはTypedArray（Uint8Array, Float32Array等）から直接テクスチャを生成し、プログラムで動的に生成したデータや数値計算結果をGPUで使用可能にする。

### 本機能の処理概要

DataTextureクラスは、Textureを継承し、画像ファイルではなくTypedArrayの生データからテクスチャを生成する。各テクセルの値をプログラムで直接制御できるため、プロシージャルテクスチャ、ルックアップテーブル、GPGPUデータなど多様な用途に使用される。

**業務上の目的・背景**：3Dアプリケーションにおいて、画像ファイルではなくプログラムで生成したデータをテクスチャとして使用する必要がある。シミュレーション結果の可視化、カラーグラデーション、ノイズテクスチャ、スキニング用ボーンデータなど、動的なデータをGPUに効率的に送信するために使用される。

**機能の利用シーン**：
- プロシージャルテクスチャの生成（ノイズ、グラデーション等）
- ルックアップテーブル（LUT）
- GPGPUでのデータ送信
- スキニング用ボーンマトリックス
- シミュレーション結果の可視化
- カスタム環境マップ

**主要な処理内容**：
1. TypedArrayからテクスチャデータを構築
2. 幅・高さ・フォーマット・型の指定
3. フィルタリングモードのデフォルト変更（NearestFilter）
4. flipY/generateMipmaps/unpackAlignmentのデフォルト変更

**関連システム・外部連携**：Texture（基底クラス）、Skeleton（ボーンテクスチャ）、各種マテリアルと連携。

**権限による制御**：特になし（Three.jsはクライアントサイドライブラリ）

## 関連画面

画面機能マッピング.csvに本機能（No.89）の関連画面情報は記載されていない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

データテクスチャ生成 / GPU転送

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| data | TypedArray | No | テクスチャデータ（デフォルト: null） | - |
| width | number | No | テクスチャ幅（デフォルト: 1） | - |
| height | number | No | テクスチャ高さ（デフォルト: 1） | - |
| format | number | No | テクスチャフォーマット（デフォルト: RGBAFormat） | - |
| type | number | No | データ型（デフォルト: UnsignedByteType） | - |
| mapping | number | No | マッピングタイプ | - |
| wrapS | number | No | 水平ラッピング | - |
| wrapT | number | No | 垂直ラッピング | - |
| magFilter | number | No | 拡大フィルタ（デフォルト: NearestFilter） | - |
| minFilter | number | No | 縮小フィルタ（デフォルト: NearestFilter） | - |
| anisotropy | number | No | 異方性フィルタリング | - |
| colorSpace | string | No | カラースペース | - |

### 入力データソース

- TypedArray: Uint8Array, Uint16Array, Int8Array, Int16Array, Float32Array等
- データレイアウト: RGBA順（RGBAFormatの場合）で幅×高さ分のピクセルデータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isDataTexture | boolean | 型判定フラグ（常にtrue） |
| image | {data, width, height} | 画像定義オブジェクト |
| generateMipmaps | boolean | ミップマップ生成フラグ（デフォルト: false） |
| flipY | boolean | 垂直反転フラグ（デフォルト: false） |
| unpackAlignment | number | アライメント（デフォルト: 1） |

### 出力先

WebGL/WebGPUテクスチャユニットにバインドされ、シェーダーで参照される。

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ Textureコンストラクタ呼び出し → プロパティ上書き
2. image設定
   └─ {data, width, height}オブジェクトとして設定
3. デフォルト値上書き
   └─ generateMipmaps=false, flipY=false, unpackAlignment=1
4. needsUpdate設定
   └─ GPUアップロードトリガー
```

### フローチャート

```mermaid
flowchart TD
    A[DataTexture生成] --> B[Textureコンストラクタ呼び出し]
    B --> C[isDataTexture=true設定]
    C --> D[image設定]
    D --> E[generateMipmaps=false]
    E --> F[flipY=false]
    F --> G[unpackAlignment=1]
    G --> H[待機状態]
    H --> I{needsUpdate?}
    I -->|Yes| J[GPUアップロード]
    J --> H
    I -->|No| K[シェーダーで使用]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-89-01 | フィルタデフォルト | mag/minFilterはNearestFilterがデフォルト | 常時 |
| BR-89-02 | flipYデフォルト | flipYはfalseがデフォルト（データそのまま） | 常時 |
| BR-89-03 | mipmapデフォルト | generateMipmapsはfalseがデフォルト | 常時 |
| BR-89-04 | アライメント | unpackAlignmentは1（バイトアライメント） | 常時 |
| BR-89-05 | データサイズ | data.length = width * height * チャンネル数 | 常時 |

### 計算ロジック

データサイズの計算:
```javascript
// RGBAFormat, UnsignedByteTypeの場合
dataSize = width * height * 4  // 4 bytes per pixel (RGBA)

// RGBAFormat, FloatTypeの場合
dataSize = width * height * 4  // 4 floats per pixel
```

## データベース操作仕様

該当なし（Three.jsはクライアントサイドライブラリ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | - | - |

### リトライ仕様

特になし

## トランザクション仕様

該当なし

## パフォーマンス要件

- データの直接参照によりコピーオーバーヘッドを最小化
- NearestFilterデフォルトにより補間コストを削減
- unpackAlignment=1で任意サイズのデータに対応

## セキュリティ考慮事項

特になし（クライアントサイドレンダリング）

## 備考

- TypedArrayの型はformatとtypeに合わせる必要がある
- Float32Arrayを使用する場合はtype=FloatTypeを指定
- Skeletonのボーンテクスチャとして使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

DataTextureの構造とTextureからの差分を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Texture.js | `src/textures/Texture.js` | 基底クラスのプロパティ |
| 1-2 | constants.js | `src/constants.js` | NearestFilter, FloatType等の定数 |

**読解のコツ**: DataTextureはTextureのデフォルト値を変更しているだけの軽量クラス。

#### Step 2: エントリーポイントを理解する

DataTextureクラス本体を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DataTexture.js | `src/textures/DataTexture.js` | メインクラス（非常に短い） |

**主要処理フロー**:
1. **32-34行目**: コンストラクタでTextureコンストラクタ呼び出し
2. **43行目**: `this.isDataTexture = true`
3. **50行目**: `this.image = { data: data, width: width, height: height }`
4. **60行目**: `this.generateMipmaps = false`
5. **71行目**: `this.flipY = false`
6. **81行目**: `this.unpackAlignment = 1`

#### Step 3: 使用例を理解する

DataTextureの使用例（Skeleton）を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Skeleton.js | `src/objects/Skeleton.js` | computeBoneTexture()でDataTexture使用 |

**主要処理フロー**:
- **268行目**: `new DataTexture(boneMatrices, size, size, RGBAFormat, FloatType)`

### プログラム呼び出し階層図

```
DataTexture
    │
    └─ Texture (継承)
           │
           ├─ EventDispatcher (継承)
           │
           ├─ Source (source)
           │      └─ data経由でimageを管理
           │
           └─ プロパティ（上書き）
                  ├─ isDataTexture: true
                  ├─ image: {data, width, height}
                  ├─ magFilter: NearestFilter
                  ├─ minFilter: NearestFilter
                  ├─ generateMipmaps: false
                  ├─ flipY: false
                  └─ unpackAlignment: 1
```

### データフロー図

```
[入力]                    [処理]                         [出力]

TypedArray ───────────▶ DataTexture Constructor ─▶ DataTexture Object
(data)                       │                        │
width, height ───────────────┤                        ├─ isDataTexture: true
format, type ────────────────┘                        ├─ image: {data, width, height}
                                                      ├─ magFilter: NearestFilter
                                                      ├─ minFilter: NearestFilter
                                                      ├─ generateMipmaps: false
                                                      ├─ flipY: false
                                                      └─ unpackAlignment: 1

needsUpdate = true ───▶ Texture.needsUpdate ──────▶ GPU Upload
                            │
                            └─ source.needsUpdate = true
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DataTexture.js | `src/textures/DataTexture.js` | ソース | DataTextureメインクラス |
| Texture.js | `src/textures/Texture.js` | ソース | テクスチャ基底クラス |
| Source.js | `src/textures/Source.js` | ソース | 画像データソース |
| Skeleton.js | `src/objects/Skeleton.js` | ソース | ボーンテクスチャでの使用例 |
| constants.js | `src/constants.js` | ソース | 定数（NearestFilter, FloatType等） |
