# 機能設計書 91-Data3DTexture

## 概要

本ドキュメントは、Three.jsライブラリにおける3Dボリュームテクスチャ機能（Data3DTexture）の設計仕様を記述したものである。

### 本機能の処理概要

Data3DTextureは、TypedArrayから3次元テクスチャを生成する機能を提供する。幅（width）、高さ（height）、深度（depth）のパラメータにより3Dボリュームデータを分割して管理し、ボリュームレンダリングや3Dノイズテクスチャなどの用途に使用される。

**業務上の目的・背景**：3Dボリュームデータを可視化する必要がある科学・医療分野のアプリケーションや、3Dノイズを使用したプロシージャルテクスチャ生成、流体シミュレーションの可視化など、2Dテクスチャでは表現できない立体的なデータ表現が求められる場面で本機能は必要とされる。

**機能の利用シーン**：
- CT/MRIスキャンデータなど医療画像の3Dボリュームレンダリング
- 雲や煙などの大気効果のシミュレーション
- 3Dパーリンノイズによるプロシージャルテクスチャ生成
- 流体シミュレーションの可視化
- ルックアップテーブル（LUT）としての3D色変換

**主要な処理内容**：
1. TypedArrayデータと幅・高さ・深度パラメータを受け取りテクスチャを初期化
2. 3Dテクスチャ用のデフォルトパラメータを設定（NearestFilter、ClampToEdgeWrapping等）
3. GPUへのアップロード時に適切な3Dテクスチャとして処理されるよう設定
4. 深度方向のラッピングモード（wrapR）を管理

**関連システム・外部連携**：WebGL 2.0以上のコンテキストが必要。WebGPURendererでも同様に使用可能。

**権限による制御**：特になし。ブラウザのWebGL 2.0サポートが必要。

## 関連画面

画面機能マッピングに該当する関連画面は存在しない（内部処理用テクスチャクラス）。

## 機能種別

データ変換 / テクスチャ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| data | TypedArray | No | バッファデータ | null許容 |
| width | number | No | テクスチャの幅（デフォルト: 1） | 正の整数 |
| height | number | No | テクスチャの高さ（デフォルト: 1） | 正の整数 |
| depth | number | No | テクスチャの深度（デフォルト: 1） | 正の整数 |

### 入力データソース

アプリケーションからのTypedArray形式のボリュームデータ（Float32Array、Uint8Array等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isData3DTexture | boolean | 型判定フラグ（常にtrue） |
| image | Object | データ、幅、高さ、深度を含むオブジェクト |
| magFilter | number | NearestFilter（デフォルト） |
| minFilter | number | NearestFilter（デフォルト） |
| wrapR | number | 深度方向のラッピングモード |
| generateMipmaps | boolean | ミップマップ生成フラグ（デフォルト: false） |
| flipY | boolean | 垂直反転フラグ（デフォルト: false） |
| unpackAlignment | number | メモリアライメント（デフォルト: 1） |

### 出力先

GPUテクスチャメモリ（WebGLRenderer/WebGPURendererを通じて）

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 親クラスTextureのコンストラクタを呼び出し（image: null）
2. プロパティ初期化
   └─ isData3DTexture = true を設定
3. imageオブジェクト設定
   └─ {data, width, height, depth} オブジェクトを設定
4. デフォルトフィルター設定
   └─ magFilter, minFilter を NearestFilter に設定
5. ラッピングモード設定
   └─ wrapR を ClampToEdgeWrapping に設定
6. その他デフォルト設定
   └─ generateMipmaps = false, flipY = false, unpackAlignment = 1
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new Data3DTexture] --> B[親クラスTexture初期化]
    B --> C[isData3DTexture = true]
    C --> D[image オブジェクト作成]
    D --> E[フィルター設定: NearestFilter]
    E --> F[wrapR = ClampToEdgeWrapping]
    F --> G[generateMipmaps = false]
    G --> H[flipY = false]
    H --> I[unpackAlignment = 1]
    I --> J[終了: Data3DTexture インスタンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-91-01 | デフォルトフィルター | 3Dテクスチャはデフォルトでフィルタリングなし（NearestFilter） | 常時 |
| BR-91-02 | ミップマップ無効 | 3Dテクスチャはデフォルトでミップマップ生成しない | 常時 |
| BR-91-03 | 垂直反転無効 | 3Dテクスチャはデフォルトで垂直反転しない | 常時 |
| BR-91-04 | アライメント設定 | メモリアライメントは1バイトに設定 | 常時 |

### 計算ロジック

データサイズ計算: `totalSize = width * height * depth * channelsPerPixel * bytesPerChannel`

## データベース操作仕様

該当なし（メモリ/GPU操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | WebGL2未サポート | ブラウザがWebGL 2.0をサポートしていない場合 | WebGL 2.0対応ブラウザを使用 |
| - | メモリ不足 | 大きなボリュームデータの割り当て失敗 | データサイズを削減 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（GPU操作は非トランザクション）

## パフォーマンス要件

- 3Dテクスチャはメモリ使用量が大きいため、必要最小限のサイズで使用することを推奨
- NearestFilterの使用により補間処理コストを削減

## セキュリティ考慮事項

- TypedArrayのデータはアプリケーション側で適切に管理すること
- 外部データを使用する場合は入力検証を行うこと

## 備考

- WebGL 1.0ではサポートされない
- WebGPURendererでも同様に使用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

3Dテクスチャの基本構造を理解するため、まず定数定義とベースクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constants.js | `src/constants.js` | ClampToEdgeWrapping, NearestFilter等のテクスチャ関連定数を確認 |
| 1-2 | Texture.js | `src/textures/Texture.js` | 基底クラスの構造とプロパティを理解 |

**読解のコツ**: Textureクラスの継承関係を把握し、どのプロパティがオーバーライドされているかを確認する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Data3DTexture.js | `src/textures/Data3DTexture.js` | コンストラクタの初期化処理を確認 |

**主要処理フロー**:
1. **20行目**: コンストラクタ定義 - data, width, height, depthパラメータを受け取る
2. **30行目**: 親クラスTextureを初期化（imageはnull）
3. **39行目**: isData3DTexture = true（型判定フラグ）
4. **46行目**: imageオブジェクトに{data, width, height, depth}を設定
5. **56行目**: magFilter = NearestFilter
6. **66行目**: minFilter = NearestFilter
7. **75行目**: wrapR = ClampToEdgeWrapping（深度方向ラッピング）
8. **85行目**: generateMipmaps = false
9. **96行目**: flipY = false
10. **106行目**: unpackAlignment = 1

#### Step 3: 関連クラスの理解

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Source.js | `src/textures/Source.js` | テクスチャデータソースの管理を理解 |

### プログラム呼び出し階層図

```
Data3DTexture (constructor)
    │
    └─ Texture (super)
           │
           ├─ EventDispatcher (super)
           │
           └─ Source
                  └─ data, width, height, depth
```

### データフロー図

```
[入力]                    [処理]                      [出力]

TypedArray data    ───▶  Data3DTexture              ───▶  GPU 3D Texture
width, height,           (コンストラクタ)
depth parameters         │
                         ├─ image オブジェクト作成
                         │
                         └─ フィルター/ラッピング設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Data3DTexture.js | `src/textures/Data3DTexture.js` | ソース | 3Dボリュームテクスチャクラス |
| Texture.js | `src/textures/Texture.js` | ソース | テクスチャ基底クラス |
| Source.js | `src/textures/Source.js` | ソース | テクスチャデータソース管理 |
| constants.js | `src/constants.js` | ソース | テクスチャ関連定数定義 |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベント管理基底クラス |
