# 機能設計書 92-CubeTexture

## 概要

本ドキュメントは、Three.jsライブラリにおけるキューブマップテクスチャ機能（CubeTexture）の設計仕様を記述したものである。

### 本機能の処理概要

CubeTextureは、6つの画像から構成されるキューブマップテクスチャを生成する機能を提供する。環境マッピング（反射/屈折）やスカイボックスの描画に使用され、立方体の各面（+X, -X, +Y, -Y, +Z, -Z）に対応する画像を管理する。

**業務上の目的・背景**：リアルな3D環境を表現するためには、オブジェクトの反射や周囲の環境を表現する環境マッピングが不可欠である。CubeTextureは、この環境マッピングを実現するためのキューブマップデータを管理し、金属やガラスなどの反射表現、空や背景の360度表現を可能にする。

**機能の利用シーン**：
- スカイボックス（背景環境）の表示
- 金属やガラスオブジェクトの反射マッピング
- 屈折効果の表現（水面、ガラス等）
- 環境ライティングのためのIBL（Image Based Lighting）
- PBRマテリアルの環境マップとしての使用

**主要な処理内容**：
1. 6面の画像配列を受け取りキューブマップテクスチャを初期化
2. CubeReflectionMappingをデフォルトマッピングとして設定
3. flipY = false に設定（キューブマップの特性上）
4. imagesプロパティを通じた画像配列へのアクセス提供

**関連システム・外部連携**：CubeTextureLoaderと連携して画像を読み込む。WebGLRenderer/WebGPURendererで描画時に使用される。

**権限による制御**：特になし。

## 関連画面

画面機能マッピングに該当する関連画面は存在しない（内部処理用テクスチャクラス）。

## 機能種別

データ変換 / テクスチャ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| images | Array<Image> | No | 6面の画像配列（デフォルト: []） | 配列長6を推奨 |
| mapping | number | No | テクスチャマッピング（デフォルト: CubeReflectionMapping） | 定数値 |
| wrapS | number | No | S方向ラッピング（デフォルト: ClampToEdgeWrapping） | 定数値 |
| wrapT | number | No | T方向ラッピング（デフォルト: ClampToEdgeWrapping） | 定数値 |
| magFilter | number | No | 拡大フィルター（デフォルト: LinearFilter） | 定数値 |
| minFilter | number | No | 縮小フィルター（デフォルト: LinearMipmapLinearFilter） | 定数値 |
| format | number | No | テクスチャフォーマット（デフォルト: RGBAFormat） | 定数値 |
| type | number | No | データ型（デフォルト: UnsignedByteType） | 定数値 |
| anisotropy | number | No | 異方性フィルタリング | 正の整数 |
| colorSpace | string | No | 色空間（デフォルト: NoColorSpace） | 文字列 |

### 入力データソース

CubeTextureLoaderを通じて読み込まれた6枚の画像、またはアプリケーションから直接提供されたImage配列

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isCubeTexture | boolean | 型判定フラグ（常にtrue） |
| image | Array<Image> | 6面の画像配列 |
| images | Array<Image> | imageのエイリアス（getter/setter） |
| flipY | boolean | 垂直反転フラグ（デフォルト: false） |
| mapping | number | CubeReflectionMapping（デフォルト） |

### 出力先

GPUテクスチャメモリ（キューブマップテクスチャとして）

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 親クラスTextureのコンストラクタを呼び出し（images, CubeReflectionMapping, 他パラメータ）
2. プロパティ初期化
   └─ isCubeTexture = true を設定
3. flipY設定
   └─ flipY = false に設定（キューブマップ特性）
4. imagesプロパティ
   └─ getter/setterでimageプロパティへのアクセスを提供
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new CubeTexture] --> B[親クラスTexture初期化]
    B --> C{images配列確認}
    C --> D[isCubeTexture = true]
    D --> E[flipY = false]
    E --> F[終了: CubeTexture インスタンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-92-01 | デフォルトマッピング | CubeReflectionMappingがデフォルト | 常時 |
| BR-92-02 | 垂直反転無効 | キューブマップはflipY = false | 常時 |
| BR-92-03 | 6面画像 | 立方体の6面に対応する画像を管理 | 常時 |
| BR-92-04 | 画像順序 | +X, -X, +Y, -Y, +Z, -Zの順序 | CubeTextureLoader使用時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（メモリ/GPU操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 画像数不足 | images配列が6未満 | 6枚の画像を提供 |
| - | 画像サイズ不一致 | 6面の画像サイズが異なる | 同一サイズの画像を使用 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- キューブマップは6面分のテクスチャメモリを使用
- ミップマップ生成時はさらにメモリ増加

## セキュリティ考慮事項

- 外部画像を読み込む場合はCORS設定に注意

## 備考

- CubeTextureLoaderと組み合わせて使用することを推奨
- WebGLRendererでの環境マップ使用時に自動的にキューブマップとして認識

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

キューブマップの基本構造と定数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constants.js | `src/constants.js` | CubeReflectionMapping定数を確認 |
| 1-2 | Texture.js | `src/textures/Texture.js` | 基底クラスの構造とプロパティを理解 |

**読解のコツ**: CubeReflectionMappingとCubeRefractionMappingの違いを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CubeTexture.js | `src/textures/CubeTexture.js` | コンストラクタとgetter/setterの確認 |

**主要処理フロー**:
1. **20-35行目**: コンストラクタ定義 - 多数のパラメータを受け取る
2. **36行目**: 親クラスにCubeReflectionMappingを渡して初期化
3. **38行目**: `super( images, mapping, ... )` - Textureコンストラクタ呼び出し
4. **47行目**: isCubeTexture = true（型判定フラグ）
5. **58行目**: flipY = false（キューブマップ特性）
6. **67-77行目**: imagesプロパティのgetter/setter（imageのエイリアス）

#### Step 3: 関連ローダーの理解

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CubeTextureLoader.js | `src/loaders/CubeTextureLoader.js` | キューブマップ画像の読み込み処理 |

### プログラム呼び出し階層図

```
CubeTexture (constructor)
    │
    └─ Texture (super)
           │
           ├─ EventDispatcher (super)
           │
           └─ Source
                  └─ images[6]
```

### データフロー図

```
[入力]                    [処理]                      [出力]

6枚の画像            ───▶  CubeTexture               ───▶  GPU Cube Map Texture
(+X,-X,+Y,-Y,+Z,-Z)        (コンストラクタ)
                           │
                           ├─ Texture継承初期化
                           │
                           └─ flipY = false 設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CubeTexture.js | `src/textures/CubeTexture.js` | ソース | キューブマップテクスチャクラス |
| Texture.js | `src/textures/Texture.js` | ソース | テクスチャ基底クラス |
| CubeTextureLoader.js | `src/loaders/CubeTextureLoader.js` | ソース | キューブマップローダー |
| constants.js | `src/constants.js` | ソース | CubeReflectionMapping等の定数定義 |
