# 機能設計書 93-CanvasTexture

## 概要

本ドキュメントは、Three.jsライブラリにおけるCanvas要素からテクスチャを生成する機能（CanvasTexture）の設計仕様を記述したものである。

### 本機能の処理概要

CanvasTextureは、HTMLCanvasElementからテクスチャを生成する機能を提供する。Canvas 2D APIで描画した内容を直接テクスチャとして使用でき、動的なテクスチャ生成やテキストレンダリングに活用される。基底クラスとほぼ同様だが、needsUpdate = trueが初期化時に設定される点が特徴である。

**業務上の目的・背景**：2DグラフィックスAPIを活用した動的テクスチャ生成のニーズに対応する。テキストの3D表示、プロシージャルテクスチャの動的生成、UIオーバーレイの作成など、Canvas APIの柔軟性を3D空間で活用するために本機能は必要とされる。

**機能の利用シーン**：
- テキストの3Dオブジェクトへの描画
- 2Dグラフや図表の3D空間への配置
- プロシージャルテクスチャのリアルタイム生成
- 動的に変化するUIテクスチャの作成
- Canvas上での画像合成結果のテクスチャ化

**主要な処理内容**：
1. HTMLCanvasElementを受け取りテクスチャを初期化
2. 親クラスTextureの初期化処理を実行
3. isCanvasTexture = true フラグを設定
4. needsUpdate = true を設定（即座にGPUアップロード可能状態に）

**関連システム・外部連携**：Canvas 2D API、WebGLRenderer/WebGPURenderer

**権限による制御**：特になし

## 関連画面

画面機能マッピングに該当する関連画面は存在しない（汎用テクスチャクラス）。

## 機能種別

データ変換 / テクスチャ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| canvas | HTMLCanvasElement | Yes | HTMLキャンバス要素 | 有効なCanvas要素 |
| mapping | number | No | テクスチャマッピング（デフォルト: DEFAULT_MAPPING） | 定数値 |
| wrapS | number | No | S方向ラッピング（デフォルト: ClampToEdgeWrapping） | 定数値 |
| wrapT | number | No | T方向ラッピング（デフォルト: ClampToEdgeWrapping） | 定数値 |
| magFilter | number | No | 拡大フィルター（デフォルト: LinearFilter） | 定数値 |
| minFilter | number | No | 縮小フィルター（デフォルト: LinearMipmapLinearFilter） | 定数値 |
| format | number | No | テクスチャフォーマット（デフォルト: RGBAFormat） | 定数値 |
| type | number | No | データ型（デフォルト: UnsignedByteType） | 定数値 |
| anisotropy | number | No | 異方性フィルタリング | 正の整数 |

### 入力データソース

アプリケーションから提供されるHTMLCanvasElement（Canvas 2D Context経由で描画済み）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isCanvasTexture | boolean | 型判定フラグ（常にtrue） |
| image | HTMLCanvasElement | ソースCanvasへの参照 |
| needsUpdate | boolean | 更新フラグ（初期化時にtrue） |

### 出力先

GPUテクスチャメモリ

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 親クラスTextureのコンストラクタを呼び出し（canvas含む全パラメータ）
2. プロパティ初期化
   └─ isCanvasTexture = true を設定
3. 更新フラグ設定
   └─ needsUpdate = true を設定（即座にレンダリング可能に）
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new CanvasTexture] --> B[Canvas要素を受け取る]
    B --> C[親クラスTexture初期化]
    C --> D[isCanvasTexture = true]
    D --> E[needsUpdate = true]
    E --> F[終了: CanvasTexture インスタンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-93-01 | 即時更新可能 | 初期化時にneedsUpdate = trueが設定される | 常時 |
| BR-93-02 | Canvas直接参照 | Canvasの内容変更後はneedsUpdate = trueを再設定 | Canvas更新時 |

### 計算ロジック

テクスチャサイズはCanvas要素のwidth/heightに依存

## データベース操作仕様

該当なし（メモリ/GPU操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 無効なCanvas | Canvas要素が無効な場合 | 有効なHTMLCanvasElementを提供 |
| - | サイズゼロ | Canvasの幅または高さが0 | Canvasに適切なサイズを設定 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- Canvas更新時は毎回needsUpdate = trueを設定する必要あり
- 大きなCanvasはメモリ使用量に注意

## セキュリティ考慮事項

- tainted canvasの場合、セキュリティ制限によりテクスチャ化できない場合がある

## 備考

- Canvas内容を更新後、needsUpdate = trueを再設定することで更新が反映される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Texture.js | `src/textures/Texture.js` | 基底クラスの構造とneedsUpdateの仕組みを理解 |

**読解のコツ**: needsUpdateのsetterがversion++とsource.needsUpdate = trueを実行する点に注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CanvasTexture.js | `src/textures/CanvasTexture.js` | 非常にシンプルな実装を確認 |

**主要処理フロー**:
1. **11行目**: クラス定義開始 `class CanvasTexture extends Texture`
2. **26行目**: コンストラクタ定義 - 9個のパラメータを受け取る
3. **28行目**: 親クラスに全パラメータを渡して初期化
4. **37行目**: isCanvasTexture = true（型判定フラグ）
5. **39行目**: needsUpdate = true（即座にGPUアップロード可能状態）

### プログラム呼び出し階層図

```
CanvasTexture (constructor)
    │
    └─ Texture (super)
           │
           ├─ EventDispatcher (super)
           │
           └─ Source
                  └─ HTMLCanvasElement
```

### データフロー図

```
[入力]                    [処理]                      [出力]

HTMLCanvasElement  ───▶  CanvasTexture              ───▶  GPU Texture
                         (コンストラクタ)
                         │
                         ├─ Texture継承初期化
                         │
                         └─ needsUpdate = true
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CanvasTexture.js | `src/textures/CanvasTexture.js` | ソース | Canvas→テクスチャ変換クラス |
| Texture.js | `src/textures/Texture.js` | ソース | テクスチャ基底クラス |
| Source.js | `src/textures/Source.js` | ソース | テクスチャデータソース管理 |
