# 機能設計書 94-VideoTexture

## 概要

本ドキュメントは、Three.jsライブラリにおける動画からテクスチャを生成する機能（VideoTexture）の設計仕様を記述したものである。

### 本機能の処理概要

VideoTextureは、HTMLVideoElementから動的に更新されるテクスチャを生成する機能を提供する。動画のフレームをリアルタイムでテクスチャとして使用でき、requestVideoFrameCallback APIを活用した効率的なフレーム同期更新をサポートする。

**業務上の目的・背景**：3D空間での動画再生や動画を使用したインタラクティブなコンテンツ作成のニーズに対応する。デジタルサイネージ、インタラクティブメディアインスタレーション、ビデオウォール、教育コンテンツなど、動画と3Dグラフィックスを組み合わせた表現が求められる場面で本機能は必要とされる。

**機能の利用シーン**：
- 3Dオブジェクト表面への動画テクスチャマッピング
- バーチャル空間内のスクリーンやモニター表現
- 動画を使用したインタラクティブアート
- VR/AR環境での動画表示
- ライブストリーミング映像の3D空間への配置

**主要な処理内容**：
1. HTMLVideoElementを受け取りテクスチャを初期化
2. LinearFilterをデフォルトフィルターとして設定
3. requestVideoFrameCallbackを使用した自動フレーム更新の登録
4. 動画フレームが更新されるたびにneedsUpdate = trueを設定
5. disposeメソッドでrequestVideoFrameCallbackをキャンセル

**関連システム・外部連携**：HTML5 Video API、requestVideoFrameCallback API、WebGLRenderer/WebGPURenderer

**権限による制御**：特になし。動画再生にはユーザーインタラクションが必要な場合がある。

## 関連画面

画面機能マッピングに該当する関連画面は存在しない（汎用テクスチャクラス）。

## 機能種別

データ変換 / テクスチャ生成 / リアルタイム更新

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| video | HTMLVideoElement | Yes | HTML動画要素 | 有効なVideo要素 |
| mapping | number | No | テクスチャマッピング（デフォルト: DEFAULT_MAPPING） | 定数値 |
| wrapS | number | No | S方向ラッピング（デフォルト: ClampToEdgeWrapping） | 定数値 |
| wrapT | number | No | T方向ラッピング（デフォルト: ClampToEdgeWrapping） | 定数値 |
| magFilter | number | No | 拡大フィルター（デフォルト: LinearFilter） | 定数値 |
| minFilter | number | No | 縮小フィルター（デフォルト: LinearFilter） | 定数値 |
| format | number | No | テクスチャフォーマット（デフォルト: RGBAFormat） | 定数値 |
| type | number | No | データ型（デフォルト: UnsignedByteType） | 定数値 |
| anisotropy | number | No | 異方性フィルタリング | 正の整数 |

### 入力データソース

アプリケーションから提供されるHTMLVideoElement（動画ファイルまたはストリーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isVideoTexture | boolean | 型判定フラグ（常にtrue） |
| image | HTMLVideoElement | ソースVideoへの参照 |
| generateMipmaps | boolean | ミップマップ生成フラグ（デフォルト: false） |
| needsUpdate | boolean | 更新フラグ（フレーム更新時にtrue） |

### 出力先

GPUテクスチャメモリ

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 親クラスTextureのコンストラクタを呼び出し
2. プロパティ初期化
   └─ isVideoTexture = true
   └─ generateMipmaps = false
   └─ _requestVideoFrameCallbackId = 0
3. requestVideoFrameCallback登録
   └─ APIがサポートされている場合、updateVideo関数を登録
4. 動画フレーム更新時
   └─ needsUpdate = true
   └─ 次のrequestVideoFrameCallbackを再登録
5. dispose時
   └─ cancelVideoFrameCallbackを呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new VideoTexture] --> B[親クラスTexture初期化]
    B --> C[isVideoTexture = true]
    C --> D[generateMipmaps = false]
    D --> E{requestVideoFrameCallback サポート?}
    E -->|Yes| F[updateVideo コールバック登録]
    E -->|No| G[update メソッドで手動更新]
    F --> H[終了: VideoTexture インスタンス]
    G --> H

    I[フレーム更新] --> J[updateVideo 呼び出し]
    J --> K[needsUpdate = true]
    K --> L[次のコールバック登録]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-94-01 | デフォルトフィルター | magFilter, minFilterはLinearFilter | 常時 |
| BR-94-02 | ミップマップ無効 | 動画テクスチャはミップマップを生成しない | 常時 |
| BR-94-03 | 自動更新 | requestVideoFrameCallbackで自動的にフレーム更新 | APIサポート時 |
| BR-94-04 | フォールバック | API未サポート時はupdateメソッドで手動更新 | API非サポート時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（メモリ/GPU操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 動画未読み込み | 動画がまだ読み込まれていない | readyState確認 |
| - | CORS制限 | クロスオリジン動画 | CORS設定確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 毎フレーム更新のためGPUへの転送コストに注意
- 高解像度動画はパフォーマンスに影響

## セキュリティ考慮事項

- クロスオリジン動画の場合CORS設定が必要
- autoplayポリシーによりユーザーインタラクションが必要な場合がある

## 備考

- WebGPURenderer使用時はcolorSpace = SRGBColorSpaceの設定が必要
- 動画のサイズ変更後はdispose()して新しいインスタンスを作成する必要がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Texture.js | `src/textures/Texture.js` | 基底クラスのneedsUpdateの仕組みを理解 |
| 1-2 | constants.js | `src/constants.js` | LinearFilter定数を確認 |

**読解のコツ**: VideoTextureはTextureの継承に加え、requestVideoFrameCallback APIとの連携が特徴。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VideoTexture.js | `src/textures/VideoTexture.js` | コンストラクタとコールバック登録を確認 |

**主要処理フロー**:
1. **21行目**: クラス定義開始 `class VideoTexture extends Texture`
2. **36行目**: コンストラクタ - magFilter, minFilterがLinearFilterにデフォルト設定
3. **38行目**: 親クラスに全パラメータを渡して初期化
4. **47行目**: isVideoTexture = true
5. **57行目**: generateMipmaps = false
6. **67行目**: _requestVideoFrameCallbackId = 0（内部状態管理）
7. **71-76行目**: updateVideo関数定義 - needsUpdate = trueと次コールバック登録
8. **78-82行目**: requestVideoFrameCallback APIチェックと初回登録
9. **86-90行目**: cloneメソッド - 動画要素を渡して新インスタンス作成
10. **98-109行目**: updateメソッド - API未サポート時のフォールバック
11. **111-123行目**: disposeメソッド - コールバックキャンセルと親クラスdispose

#### Step 3: ライフサイクル管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VideoTexture.js | `src/textures/VideoTexture.js` | dispose処理でのリソース解放を確認 |

### プログラム呼び出し階層図

```
VideoTexture (constructor)
    │
    ├─ Texture (super)
    │      │
    │      ├─ EventDispatcher (super)
    │      │
    │      └─ Source
    │             └─ HTMLVideoElement
    │
    └─ requestVideoFrameCallback
           │
           └─ updateVideo (recursive callback)
                  │
                  └─ needsUpdate = true
```

### データフロー図

```
[入力]                    [処理]                      [出力]

HTMLVideoElement   ───▶  VideoTexture               ───▶  GPU Texture
      │                  (コンストラクタ)
      │                  │
      │                  ├─ Texture継承初期化
      │                  │
      │                  └─ rVFC登録
      │
      ▼
[動画フレーム更新]  ───▶  updateVideo                ───▶  needsUpdate = true
                         (callback)                       │
                                                          ▼
                                                    GPU再アップロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VideoTexture.js | `src/textures/VideoTexture.js` | ソース | 動画テクスチャクラス |
| Texture.js | `src/textures/Texture.js` | ソース | テクスチャ基底クラス |
| Source.js | `src/textures/Source.js` | ソース | テクスチャデータソース管理 |
| constants.js | `src/constants.js` | ソース | LinearFilter等の定数定義 |
