# 機能設計書 95-DepthTexture

## 概要

本ドキュメントは、Three.jsライブラリにおける深度情報をテクスチャとして保存する機能（DepthTexture）の設計仕様を記述したものである。

### 本機能の処理概要

DepthTextureは、レンダリング時の深度情報を自動的にテクスチャとして保存する機能を提供する。シャドウマッピング、ポストプロセッシングエフェクト、深度ベースのエフェクト（被写界深度、SSAO等）で使用される特殊なテクスチャである。

**業務上の目的・背景**：リアルな3Dレンダリングには深度情報の活用が不可欠である。シャドウマップの生成、被写界深度（DoF）効果、アンビエントオクルージョン（SSAO）、フォグ効果、デカール投影など、多くの高度なレンダリング技法が深度バッファへのアクセスを必要とする。DepthTextureはこれらの技法を実現するための基盤機能を提供する。

**機能の利用シーン**：
- シャドウマッピングによる影の描画
- 被写界深度（Depth of Field）エフェクト
- スクリーンスペースアンビエントオクルージョン（SSAO）
- ソフトパーティクル
- デカールプロジェクション
- 深度ベースのフォグ効果

**主要な処理内容**：
1. 幅・高さ・深度パラメータを受け取り深度テクスチャを初期化
2. DepthFormatまたはDepthStencilFormatのフォーマット検証
3. NearestFilterをデフォルトフィルターとして設定
4. compareFunction プロパティによる深度比較関数の設定
5. copy、toJSONメソッドでの深度テクスチャ固有処理

**関連システム・外部連携**：WebGLRenderTarget、シャドウマップシステム、ポストプロセッシングパイプライン

**権限による制御**：特になし

## 関連画面

画面機能マッピングに該当する関連画面は存在しない（内部処理用テクスチャクラス）。

## 機能種別

データ変換 / テクスチャ生成 / レンダリング補助

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| width | number | Yes | テクスチャの幅 | 正の整数 |
| height | number | Yes | テクスチャの高さ | 正の整数 |
| type | number | No | データ型（デフォルト: UnsignedIntType） | 定数値 |
| mapping | number | No | テクスチャマッピング | 定数値 |
| wrapS | number | No | S方向ラッピング | 定数値 |
| wrapT | number | No | T方向ラッピング | 定数値 |
| magFilter | number | No | 拡大フィルター（デフォルト: NearestFilter） | 定数値 |
| minFilter | number | No | 縮小フィルター（デフォルト: NearestFilter） | 定数値 |
| anisotropy | number | No | 異方性フィルタリング | 正の整数 |
| format | number | No | テクスチャフォーマット（デフォルト: DepthFormat） | DepthFormat/DepthStencilFormat |
| depth | number | No | テクスチャの深度（デフォルト: 1） | 正の整数 |

### 入力データソース

レンダリングパイプラインからの深度バッファデータ（自動生成）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isDepthTexture | boolean | 型判定フラグ（常にtrue） |
| image | Object | {width, height, depth}オブジェクト |
| flipY | boolean | 垂直反転フラグ（デフォルト: false） |
| generateMipmaps | boolean | ミップマップ生成フラグ（デフォルト: false） |
| compareFunction | number\|null | 深度比較関数（デフォルト: null） |

### 出力先

GPUテクスチャメモリ（深度バッファとして）

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ フォーマット検証（DepthFormatまたはDepthStencilFormat必須）
2. imageオブジェクト作成
   └─ {width, height, depth}オブジェクトを作成
3. 親クラスTexture初期化
   └─ 全パラメータを渡して初期化
4. プロパティ初期化
   └─ isDepthTexture = true
   └─ flipY = false
   └─ generateMipmaps = false
   └─ compareFunction = null
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new DepthTexture] --> B{フォーマット検証}
    B -->|DepthFormat or DepthStencilFormat| C[imageオブジェクト作成]
    B -->|その他| X[エラースロー]
    C --> D[親クラスTexture初期化]
    D --> E[isDepthTexture = true]
    E --> F[flipY = false]
    F --> G[generateMipmaps = false]
    G --> H[compareFunction = null]
    H --> I[終了: DepthTexture インスタンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-95-01 | フォーマット制限 | DepthFormatまたはDepthStencilFormatのみ許可 | 常時 |
| BR-95-02 | デフォルトフィルター | NearestFilterがデフォルト | 常時 |
| BR-95-03 | ミップマップ無効 | 深度テクスチャはミップマップを生成しない | 常時 |
| BR-95-04 | 垂直反転無効 | 深度テクスチャはflipY = false | 常時 |
| BR-95-05 | 深度比較 | compareFunctionで深度比較方式を設定可能 | シャドウマップ等 |

### 計算ロジック

深度値は通常0.0〜1.0の範囲に正規化される

## データベース操作仕様

該当なし（メモリ/GPU操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Error | 不正なフォーマット | DepthFormat/DepthStencilFormat以外を指定 | 正しいフォーマットを使用 |
| - | メモリ不足 | 大きなサイズの深度テクスチャ作成 | サイズを削減 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 深度テクスチャはシャドウマップ等で頻繁に使用される
- 解像度はパフォーマンスとクオリティのトレードオフ

## セキュリティ考慮事項

- 深度情報はシーン構造を暴露する可能性があるため、必要に応じて保護

## 備考

- DepthStencilFormatを使用するとステンシル情報も含めて保存可能
- WebGL拡張の対応状況により利用可能な深度フォーマットが異なる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constants.js | `src/constants.js` | DepthFormat, DepthStencilFormat, NearestFilter, UnsignedIntType等の定数を確認 |
| 1-2 | Texture.js | `src/textures/Texture.js` | 基底クラスの構造を理解 |

**読解のコツ**: 深度テクスチャ特有のフォーマット定数とその意味を理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DepthTexture.js | `src/textures/DepthTexture.js` | コンストラクタとフォーマット検証を確認 |

**主要処理フロー**:
1. **11行目**: クラス定義開始 `class DepthTexture extends Texture`
2. **28行目**: コンストラクタ定義 - 多数のパラメータ、デフォルト値設定
3. **30-34行目**: フォーマット検証 - DepthFormat/DepthStencilFormat以外はエラー
4. **36行目**: imageオブジェクト作成 `{ width, height, depth }`
5. **38行目**: 親クラスTexture初期化
6. **47行目**: isDepthTexture = true
7. **58行目**: flipY = false
8. **68行目**: generateMipmaps = false
9. **76行目**: compareFunction = null（深度比較関数）
10. **81-90行目**: copyメソッド - Sourceの新規作成とcompareFunction複製
11. **92-100行目**: toJSONメソッド - compareFunctionのシリアライズ

#### Step 3: 深度比較関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | constants.js | `src/constants.js` | NeverCompare, LessCompare等の比較関数定数 |

### プログラム呼び出し階層図

```
DepthTexture (constructor)
    │
    ├─ フォーマット検証
    │      └─ Error throw (不正フォーマット時)
    │
    └─ Texture (super)
           │
           ├─ EventDispatcher (super)
           │
           └─ Source
                  └─ {width, height, depth}
```

### データフロー図

```
[入力]                    [処理]                      [出力]

width, height,      ───▶  DepthTexture               ───▶  GPU Depth Texture
depth, format            (コンストラクタ)
                         │
                         ├─ フォーマット検証
                         │
                         ├─ Texture継承初期化
                         │
                         └─ compareFunction設定
                                │
                                ▼
                         シャドウマップ / DOF / SSAO 等
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DepthTexture.js | `src/textures/DepthTexture.js` | ソース | 深度テクスチャクラス |
| Texture.js | `src/textures/Texture.js` | ソース | テクスチャ基底クラス |
| Source.js | `src/textures/Source.js` | ソース | テクスチャデータソース管理 |
| constants.js | `src/constants.js` | ソース | DepthFormat等の定数定義 |
| WebGLRenderTarget.js | `src/renderers/WebGLRenderTarget.js` | ソース | 深度テクスチャの主要利用先 |
