# 機能設計書 96-CompressedTexture

## 概要

本ドキュメントは、Three.jsライブラリにおける圧縮テクスチャ機能（CompressedTexture）の設計仕様を記述したものである。

### 本機能の処理概要

CompressedTextureは、GPUネイティブの圧縮形式（DXT/S3TC、ETC、ASTC、PVRTC等）でエンコードされたテクスチャデータを管理する機能を提供する。圧縮テクスチャはファイルサイズとGPUメモリ使用量を大幅に削減しながら高品質なテクスチャを実現する。

**業務上の目的・背景**：大規模な3Dアプリケーションやゲームでは、テクスチャデータがストレージとメモリの大部分を占める。圧縮テクスチャを使用することで、ダウンロード時間の短縮、メモリ使用量の削減、GPUパフォーマンスの向上を実現できる。特にモバイルデバイスやWebアプリケーションでは、これらの最適化が重要となる。

**機能の利用シーン**：
- 大規模3Dゲームやアプリケーションでのテクスチャ最適化
- モバイルデバイス向けアプリケーション（ETC、PVRTC形式）
- デスクトップ向けアプリケーション（DXT/S3TC形式）
- WebGL/WebGPUアプリケーションでの帯域幅削減
- メモリ制約のある環境でのテクスチャ管理

**主要な処理内容**：
1. ミップマップデータ配列と寸法を受け取りテクスチャを初期化
2. imageオブジェクトに幅と高さを設定
3. mipmapsプロパティにミップマップデータを設定
4. flipY = false、generateMipmaps = false に固定（圧縮データの特性）

**関連システム・外部連携**：CompressedTextureLoader、KTX2Loader等の圧縮テクスチャローダー

**権限による制御**：特になし。GPUが対応する圧縮形式に依存。

## 関連画面

画面機能マッピングに該当する関連画面は存在しない（内部処理用テクスチャクラス）。

## 機能種別

データ変換 / テクスチャ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| mipmaps | Array<Object> | Yes | ミップマップデータ配列（各要素はdata, width, heightを含む） | 配列 |
| width | number | Yes | テクスチャの幅 | 正の整数 |
| height | number | Yes | テクスチャの高さ | 正の整数 |
| format | number | No | 圧縮フォーマット（デフォルト: RGBAFormat） | 定数値 |
| type | number | No | データ型（デフォルト: UnsignedByteType） | 定数値 |
| mapping | number | No | テクスチャマッピング | 定数値 |
| wrapS | number | No | S方向ラッピング | 定数値 |
| wrapT | number | No | T方向ラッピング | 定数値 |
| magFilter | number | No | 拡大フィルター | 定数値 |
| minFilter | number | No | 縮小フィルター | 定数値 |
| anisotropy | number | No | 異方性フィルタリング | 正の整数 |
| colorSpace | string | No | 色空間（デフォルト: NoColorSpace） | 文字列 |

### 入力データソース

CompressedTextureLoader等を通じて読み込まれた圧縮テクスチャファイル（.dds, .ktx, .ktx2, .pvr等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isCompressedTexture | boolean | 型判定フラグ（常にtrue） |
| image | Object | {width, height}オブジェクト |
| mipmaps | Array<Object> | ミップマップデータ配列 |
| flipY | boolean | 垂直反転フラグ（固定: false） |
| generateMipmaps | boolean | ミップマップ生成フラグ（固定: false） |

### 出力先

GPUテクスチャメモリ（圧縮形式のまま）

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 親クラスTextureのコンストラクタを呼び出し（image: null）
2. プロパティ初期化
   └─ isCompressedTexture = true を設定
3. imageオブジェクト設定
   └─ {width, height}オブジェクトを設定（サイズ情報のみ）
4. mipmaps設定
   └─ ミップマップデータ配列を設定
5. 固定プロパティ設定
   └─ flipY = false（圧縮データは反転不可）
   └─ generateMipmaps = false（ミップマップはファイルに埋め込み済み）
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new CompressedTexture] --> B[親クラスTexture初期化]
    B --> C[isCompressedTexture = true]
    C --> D[image = {width, height}]
    D --> E[mipmaps = 入力配列]
    E --> F[flipY = false 固定]
    F --> G[generateMipmaps = false 固定]
    G --> H[終了: CompressedTexture インスタンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-96-01 | flipY固定 | 圧縮テクスチャは反転不可（false固定） | 常時 |
| BR-96-02 | ミップマップ固定 | ミップマップはファイル埋め込み必須（生成不可） | 常時 |
| BR-96-03 | GPU依存 | 圧縮形式はGPUサポートに依存 | 常時 |
| BR-96-04 | データサイズ | 圧縮形式により異なるサイズ計算 | 形式依存 |

### 計算ロジック

圧縮テクスチャのメモリサイズは圧縮形式に依存:
- DXT1: width * height / 2 bytes
- DXT5: width * height bytes
- ETC1: width * height / 2 bytes
- ASTC: ブロックサイズに依存

## データベース操作仕様

該当なし（メモリ/GPU操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 未サポート形式 | GPUが圧縮形式をサポートしていない | 対応形式のテクスチャを使用 |
| - | 不正なデータ | ミップマップデータが破損 | 正しいファイルを再読み込み |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 圧縮テクスチャはGPUで直接使用されるため高パフォーマンス
- 解凍処理不要でメモリ効率が良い

## セキュリティ考慮事項

- 外部から読み込むテクスチャファイルの検証を推奨

## 備考

- 圧縮形式はプラットフォームにより異なる:
  - デスクトップ: DXT/S3TC (BC1-BC7)
  - Android: ETC2, ASTC
  - iOS: PVRTC, ASTC
- KTX2形式はBasis Universal圧縮により複数プラットフォームをサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constants.js | `src/constants.js` | 圧縮テクスチャ関連の定数（RGBA_S3TC_DXT1_Format等）を確認 |
| 1-2 | Texture.js | `src/textures/Texture.js` | 基底クラスのmipmapsプロパティを理解 |

**読解のコツ**: 圧縮テクスチャは通常のテクスチャと異なり、GPUが直接理解する形式のデータを持つことを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CompressedTexture.js | `src/textures/CompressedTexture.js` | シンプルな実装を確認 |

**主要処理フロー**:
1. **10行目**: クラス定義開始 `class CompressedTexture extends Texture`
2. **29行目**: コンストラクタ - 12個のパラメータを受け取る
3. **31行目**: 親クラスに null を渡して初期化
4. **40行目**: isCompressedTexture = true
5. **47行目**: image = { width, height }（サイズ情報のみ）
6. **54行目**: mipmaps = 入力配列を設定
7. **67行目**: flipY = false（固定、読み取り専用）
8. **80行目**: generateMipmaps = false（固定、読み取り専用）

### プログラム呼び出し階層図

```
CompressedTexture (constructor)
    │
    └─ Texture (super)
           │
           ├─ EventDispatcher (super)
           │
           └─ Source
                  └─ null (圧縮データは直接管理)

CompressedTextureLoader
    │
    └─ CompressedTexture (生成)
           │
           └─ mipmaps[]: 圧縮データ配列
```

### データフロー図

```
[入力]                    [処理]                      [出力]

圧縮テクスチャファイル
(.dds, .ktx, .ktx2)
      │
      ▼
CompressedTextureLoader  ───▶  CompressedTexture     ───▶  GPU Compressed Texture
                               (コンストラクタ)
                               │
                               ├─ mipmaps配列設定
                               │
                               └─ flipY/generateMipmaps 固定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CompressedTexture.js | `src/textures/CompressedTexture.js` | ソース | 圧縮テクスチャクラス |
| Texture.js | `src/textures/Texture.js` | ソース | テクスチャ基底クラス |
| constants.js | `src/constants.js` | ソース | 圧縮形式定数定義 |
| CompressedTextureLoader.js | `src/loaders/CompressedTextureLoader.js` | ソース | 圧縮テクスチャローダー |
