---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-Object3D.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **C-25（pivotプロパティの追加バージョン）**：リリースノート等の外部ドキュメント未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/core/Object3D.js` - Object3Dクラスのソースコード
- E-02: `src/core/EventDispatcher.js` - EventDispatcherクラスのソースコード
- E-03: `src/core/Layers.js` - Layersクラスのソースコード
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Object3DはEventDispatcherを継承している | E-01 (64行目: `class Object3D extends EventDispatcher`) | ○ |
| C-02 | positionプロパティはVector3インスタンス | E-01 (140行目, 168行目) | ○ |
| C-03 | rotationとquaternionは相互同期される | E-01 (145-158行目: onRotationChange, onQuaternionChange) | ○ |
| C-04 | idは自動採番される | E-01 (89行目: `Object.defineProperty( this, 'id', { value: _object3DId ++ } )`) | ○ |
| C-05 | uuidはMathUtils.generateUUID()で生成 | E-01 (8行目, 97行目) | ○ |
| C-06 | デフォルトのupは(0,1,0) | E-01 (1647行目: `Object3D.DEFAULT_UP = new Vector3( 0, 1, 0 )`) | ○ |
| C-07 | add()で自分自身を追加しようとすると警告が出る | E-01 (758-762行目) | ○ |
| C-08 | add()でObject3D以外を追加しようとすると警告が出る | E-01 (777-780行目) | ○ |
| C-09 | add()時にaddedイベントが発行される | E-01 (771行目: `object.dispatchEvent( _addedEvent )`) | ○ |
| C-10 | add()時にchildaddedイベントが発行される | E-01 (773-775行目) | ○ |
| C-11 | remove()時にremovedイベントが発行される | E-01 (817行目) | ○ |
| C-12 | remove()時にchildremovedイベントが発行される | E-01 (819-821行目) | ○ |
| C-13 | updateMatrix()でmatrix.compose()が呼ばれる | E-01 (1133行目) | ○ |
| C-14 | pivotが設定されている場合に補正処理が行われる | E-01 (1135-1146行目) | ○ |
| C-15 | updateMatrixWorld()は子オブジェクトを再帰処理する | E-01 (1191-1199行目) | ○ |
| C-16 | matrixAutoUpdateのデフォルトはtrue | E-01 (1657行目: `Object3D.DEFAULT_MATRIX_AUTO_UPDATE = true`) | ○ |
| C-17 | visibleのデフォルトはtrue | E-01 (289行目) | ○ |
| C-18 | castShadowのデフォルトはfalse | E-01 (297行目) | ○ |
| C-19 | receiveShadowのデフォルトはfalse | E-01 (305行目) | ○ |
| C-20 | frustumCulledのデフォルトはtrue | E-01 (313行目) | ○ |
| C-21 | renderOrderのデフォルトは0 | E-01 (325行目) | ○ |
| C-22 | staticプロパティはWebGPURendererで使用される | E-01 (357-368行目: コメント参照) | ○ |
| C-23 | layersのデフォルトはlayer 0 | E-01 (281行目), E-03 (27行目: `this.mask = 1 | 0`) | ○ |
| C-24 | 関連画面として8画面が該当 | E-05 | ○ |
| C-25 | pivotプロパティはr173で追加された | **根拠なし** - リリースノート未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-25のリリースバージョン情報**
  - pivotプロパティがr173で追加されたという情報はソースコードのコメントやCHANGELOGから確認できなかった
  - 候補：CHANGELOG.md / GitHub Releases / Three.js公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 全体的にソースコードから直接確認可能な内容が多く、信頼性は高い
- **リスク1（中）**: バージョン関連の記述（C-25）は外部ドキュメントでの確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] rotation/quaternion同期の説明が正確か確認（E-01 145-158行目）
- [ ] updateMatrixWorld()の再帰処理の説明が正確か確認（E-01 1163-1201行目）
- [ ] pivot補正の数式が正確か確認（E-01 1139-1144行目）
- [ ] pivotプロパティの追加バージョン（r173）を公式ドキュメントで確認
- [ ] 関連画面の一覧が画面機能マッピングと一致しているか確認
