---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：101-ImageLoader

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/loaders/ImageLoader.js` - ImageLoaderクラスの実装
- E-02: `src/loaders/Cache.js` - Cacheシングルトンオブジェクト
- E-03: `src/loaders/Loader.js` - Loader基底クラス
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.101）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ImageLoaderはHTMLのImage APIを使用して画像を読み込む | E-01 (88行目: createElementNS('img')) | ○ |
| C-02 | Loaderクラスを継承している | E-01 (20行目: class ImageLoader extends Loader) | ○ |
| C-03 | URLまたはData URIから画像を読み込む | E-01 (150行目: url.slice(0,5) !== 'data:') | ○ |
| C-04 | Cacheシステムと連携して重複読み込みを防止 | E-01 (53行目: Cache.get, 156行目: Cache.add) | ○ |
| C-05 | LoadingManagerと連携して進捗管理 | E-01 (59, 65, 109, 135-136行目: manager.itemStart/itemEnd/itemError) | ○ |
| C-06 | CORS対応のためcrossOrigin設定がある | E-01 (152行目: image.crossOrigin = this.crossOrigin) | ○ |
| C-07 | キャッシュヒット時は即座にonLoadコールバックを実行 | E-01 (57-67行目: cached.complete === true時の処理) | ○ |
| C-08 | 読み込み中の画像に対する重複リクエストは_loadingマップで管理 | E-01 (5行目: _loading = new WeakMap(), 70-81行目) | ○ |
| C-09 | Data URI以外の場合にcrossOrigin属性を設定 | E-01 (150-154行目: if url.slice(0,5) !== 'data:') | ○ |
| C-10 | エラー時にCacheからエントリを削除 | E-01 (119行目: Cache.remove) | ○ |
| C-11 | load()メソッドは画像要素を戻り値として返す | E-01 (161行目: return image) | ○ |
| C-12 | プログレスイベントはr84以降未サポート | E-01 (14-16行目: JSDocコメント) | ○ |
| C-13 | loadAsync()メソッドがPromiseベースで利用可能 | E-03 (91-101行目: Loaderクラスの実装) | ○ |
| C-14 | 成功時に待機中コールバックを全て実行 | E-01 (98-105行目: _loadingから取得して実行) | ○ |
| C-15 | エラー時に待機中コールバックのonErrorを実行 | E-01 (123-130行目: _loadingからコールバック実行) | ○ |
| C-16 | crossOriginのデフォルト値は'anonymous' | E-03 (32行目: this.crossOrigin = 'anonymous') | ○ |
| C-17 | Cacheキーは'image:'プレフィックス付きURL | E-01 (53行目: `image:${url}`) | ○ |
| C-18 | manager.resolveURL()でURLを解決 | E-01 (49行目: url = this.manager.resolveURL(url)) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] キャッシュ機構の動作確認（Cache.enabled = trueの場合の挙動）
- [ ] CORS設定がData URIで正しくスキップされることの確認
- [ ] エラー時のクリーンアップ処理の確認
