---
generated_at: 2026-01-27 12:38:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：104-ObjectLoader

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/loaders/ObjectLoader.js` - ObjectLoaderクラスの実装（1274行）
- E-02: `src/loaders/FileLoader.js` - FileLoaderクラス
- E-03: `src/loaders/ImageLoader.js` - ImageLoaderクラス
- E-04: `src/loaders/BufferGeometryLoader.js` - BufferGeometryLoaderクラス
- E-05: `src/loaders/MaterialLoader.js` - MaterialLoaderクラス
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.104）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Loaderクラスを継承 | E-01 (84行目: class ObjectLoader extends Loader) | ○ |
| C-02 | FileLoaderでJSONファイルを読み込む | E-01 (112行目: new FileLoader) | ○ |
| C-03 | メタデータ検証でtype='geometry'を拒否 | E-01 (136行目: metadata.type.toLowerCase() === 'geometry') | ○ |
| C-04 | parseAnimations()でAnimationClip.parseを使用 | E-01 (411行目: AnimationClip.parse(data)) | ○ |
| C-05 | parseShapes()でShape.fromJSONを使用 | E-01 (278行目: new Shape().fromJSON) | ○ |
| C-06 | parseGeometries()でBufferGeometryLoaderを使用 | E-01 (327行目: new BufferGeometryLoader()) | ○ |
| C-07 | parseImages()でImageLoaderを使用 | E-01 (481行目: new ImageLoader(manager)) | ○ |
| C-08 | parseMaterials()でMaterialLoaderを使用 | E-01 (378行目: new MaterialLoader()) | ○ |
| C-09 | parseObject()が再帰的に子オブジェクトを処理 | E-01 (1150行目: this.parseObject(children[i]...)) | ○ |
| C-10 | bindSkeletons()でSkinnedMeshにスケルトンをバインド | E-01 (1211行目: child.bind(skeleton, child.bindMatrix)) | ○ |
| C-11 | bindLightTargets()でDirectionalLight/SpotLightのtargetを解決 | E-01 (1225行目: if child.isDirectionalLight or isSpotLight) | ○ |
| C-12 | path未設定時はURLからベースパスを抽出 | E-01 (109行目: LoaderUtils.extractUrlBase(url)) | ○ |
| C-13 | loadAsync()が提供されている | E-01 (159-185行目: async loadAsync) | ○ |
| C-14 | parseAsync()が提供されている | E-01 (247-266行目: async parseAsync) | ○ |
| C-15 | Scene型のオブジェクトをサポート | E-01 (813行目: new Scene()) | ○ |
| C-16 | PerspectiveCamera型をサポート | E-01 (866行目: new PerspectiveCamera) | ○ |
| C-17 | SkinnedMesh型をサポート | E-01 (935行目: new SkinnedMesh) | ○ |
| C-18 | InstancedMesh型をサポート | E-01 (960行目: new InstancedMesh) | ○ |
| C-19 | BatchedMesh型をサポート | E-01 (971行目: new BatchedMesh) | ○ |
| C-20 | LOD型をサポートし、levels設定も復元 | E-01 (1043行目: new LOD(), 1174-1188行目) | ○ |
| C-21 | UUID参照でリソースを解決 | E-01 (749-805行目: getGeometry, getMaterial, getTexture) | ○ |
| C-22 | 画像読み込み完了まで待機してからonLoad実行 | E-01 (218-235行目: hasImages判定) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 未知のオブジェクトタイプが渡された場合の挙動確認（Object3Dとして処理）
- [ ] 循環参照を含むJSONの処理確認
- [ ] リソース参照が見つからない場合の警告ログ確認
- [ ] スケルトンバインドが正しく動作することの確認
