---
generated_at: 2026-01-27 12:42:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：105-MaterialLoader

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/loaders/MaterialLoader.js` - MaterialLoaderクラスの実装（440行）
- E-02: `src/loaders/FileLoader.js` - FileLoaderクラス
- E-03: `src/materials/Materials.js` - マテリアルクラス集約
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.105）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Loaderクラスを継承 | E-01 (43行目: class MaterialLoader extends Loader) | ○ |
| C-02 | FileLoaderでJSONファイルを読み込む | E-01 (75行目: new FileLoader(scope.manager)) | ○ |
| C-03 | createMaterialFromType()でタイプ別マテリアル生成 | E-01 (127行目: this.createMaterialFromType(json.type)) | ○ |
| C-04 | 18種類のマテリアルタイプをサポート | E-01 (412-431行目: materialLib) | ○ |
| C-05 | テクスチャはsetTextures()で事前設定が必要 | E-01 (59行目: this.textures = {}, 384-388行目) | ○ |
| C-06 | colorはsetHex()で整数から変換 | E-01 (131行目: material.color.setHex(json.color)) | ○ |
| C-07 | uniformsはtype識別子で種類を判定 | E-01 (238-271行目: switch uniform.type) | ○ |
| C-08 | 't'はTexture型として処理 | E-01 (240-242行目: case 't') | ○ |
| C-09 | 'c'はColor型として処理 | E-01 (244-246行目: case 'c') | ○ |
| C-10 | 'v2','v3','v4'はVector型として処理 | E-01 (248-258行目: case 'v2','v3','v4') | ○ |
| C-11 | 'm3','m4'はMatrix型として処理 | E-01 (260-266行目: case 'm3','m4') | ○ |
| C-12 | テクスチャ未定義時はwarn出力 | E-01 (119行目: warn('MaterialLoader: Undefined texture')) | ○ |
| C-13 | NodeMaterialは非サポート | E-01 (39-40行目: JSDocコメント) | ○ |
| C-14 | normalScaleはスカラーでも配列でも受け付ける | E-01 (312-326行目: normalScale処理) | ○ |
| C-15 | vertexColorsは数値でもブール値でも受け付ける | E-01 (214-226行目: vertexColors処理) | ○ |
| C-16 | 約20種類のテクスチャマップをサポート | E-01 (302-371行目: マップ設定) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 未知のマテリアルタイプが渡された場合のエラー処理確認
- [ ] テクスチャ未設定時の挙動確認（warnのみで処理継続）
- [ ] ShaderMaterialのuniforms復元が正しく動作することの確認
