---
generated_at: 2026-01-27 12:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：110-AnimationMixer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/animation/AnimationMixer.js` - AnimationMixerクラスの実装（861行）
- E-02: `src/animation/AnimationAction.js` - AnimationActionクラス
- E-03: `src/animation/AnimationClip.js` - AnimationClipクラス
- E-04: `src/animation/PropertyBinding.js` - PropertyBindingクラス
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.110）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventDispatcherを継承 | E-01 (16行目: class AnimationMixer extends EventDispatcher) | ○ |
| C-02 | コンストラクタでrootを受け取る | E-01 (23行目: constructor(root)) | ○ |
| C-03 | timeのデフォルト値は0 | E-01 (37行目: this.time = 0) | ○ |
| C-04 | timeScaleのデフォルト値は1.0 | E-01 (49行目: this.timeScale = 1.0) | ○ |
| C-05 | clipAction()でアクションを取得/生成 | E-01 (557-616行目: clipAction) | ○ |
| C-06 | 同じclip/rootで同じアクションを返す | E-01 (585-591行目: existingAction返却) | ○ |
| C-07 | update()でdeltaTime *= timeScale | E-01 (678行目) | ○ |
| C-08 | update()でtime += deltaTime | E-01 (683行目: time = this.time += deltaTime) | ○ |
| C-09 | accuIndexはXORで切り替え | E-01 (686行目: accuIndex = this._accuIndex ^= 1) | ○ |
| C-10 | アクティブアクションをループで更新 | E-01 (690-696行目: for i !== nActions) | ○ |
| C-11 | アクティブバインディングを適用 | E-01 (703-707行目: bindings[i].apply(accuIndex)) | ○ |
| C-12 | setTime()で特定時刻にジャンプ | E-01 (722-733行目) | ○ |
| C-13 | stopAllAction()で全アクション停止 | E-01 (652-665行目) | ○ |
| C-14 | uncacheClip()でクリップのキャッシュ解放 | E-01 (752-791行目) | ○ |
| C-15 | uncacheRoot()でルートのキャッシュ解放 | E-01 (801-835行目) | ○ |
| C-16 | uncacheAction()でアクションのキャッシュ解放 | E-01 (845-856行目) | ○ |
| C-17 | _initMemoryManager()で管理構造を初期化 | E-01 (199-264行目) | ○ |
| C-18 | statsプロパティでデバッグ統計を提供 | E-01 (223-262行目) | ○ |
| C-19 | existingAction()で既存アクションを取得 | E-01 (625-645行目) | ○ |
| C-20 | getRoot()でルートオブジェクトを取得 | E-01 (740-744行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 複数アクションの同時再生とブレンドが正しく動作することの確認
- [ ] loopイベントとfinishedイベントの発火タイミング確認
- [ ] uncache系メソッド後のメモリ解放確認
- [ ] timeScale = 0での一時停止動作確認
- [ ] 負のtimeScaleでの逆再生動作確認
