---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：111-AnimationClip.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **C-25 関連画面情報**：画面機能マッピングに該当なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/animation/AnimationClip.js` - 16-628行目（クラス全体）
- E-02: `src/animation/AnimationClip.js` - 32-86行目（コンストラクタ）
- E-03: `src/animation/AnimationClip.js` - 95-114行目（parse静的メソッド）
- E-04: `src/animation/AnimationClip.js` - 123-147行目（toJSON静的メソッド）
- E-05: `src/animation/AnimationClip.js` - 163-203行目（CreateFromMorphTargetSequence）
- E-06: `src/animation/AnimationClip.js` - 441-458行目（resetDuration）
- E-07: `src/animation/AnimationClip.js` - 465-475行目（trim）
- E-08: `src/animation/AnimationClip.js` - 503-513行目（optimize）
- E-09: `src/animation/AnimationClip.js` - 483-495行目（validate）
- E-10: `src/animation/AnimationClip.js` - 551-591行目（getTrackTypeForValueTypeName）
- E-11: `src/animation/AnimationClip.js` - 593-626行目（parseKeyframeTrack）
- E-12: `src/animation/AnimationClip.js` - 307-314行目（parseAnimation非推奨警告）
- E-13: `src/constants.js` - NormalAnimationBlendMode定義
- E-14: `docs/code-to-docs/機能一覧/機能一覧.csv` - 111行目
- E-15: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AnimationClipはキーフレームアニメーションデータを格納するクラス | E-01, E-14 | ○ |
| C-02 | 複数のKeyframeTrackを束ねて管理 | E-02 (tracks配列) | ○ |
| C-03 | コンストラクタでname, duration, tracks, blendModeを受け取る | E-02 (32行目) | ○ |
| C-04 | durationが負の場合resetDuration()で自動計算 | E-02 (80-84行目) | ○ |
| C-05 | UUIDはgenerateUUID()で自動生成 | E-02 (69行目) | ○ |
| C-06 | デフォルトblendModeはNormalAnimationBlendMode | E-02 (32行目), E-13 | ○ |
| C-07 | parse()でJSONからインスタンスを生成 | E-03 | ○ |
| C-08 | toJSON()でJSONにシリアライズ | E-04 | ○ |
| C-09 | CreateFromMorphTargetSequenceでモーフターゲットからクリップ生成 | E-05 | ○ |
| C-10 | resetDuration()は全トラックの最大終了時間を計算 | E-06 | ○ |
| C-11 | trim()でトラックをトリミング | E-07 | ○ |
| C-12 | optimize()で冗長キーフレームを削除 | E-08 | ○ |
| C-13 | validate()でトラックの妥当性検証 | E-09 | ○ |
| C-14 | getTrackTypeForValueTypeName()で型名からトラッククラスを取得 | E-10 | ○ |
| C-15 | parseKeyframeTrack()でJSONからトラックを生成 | E-11 | ○ |
| C-16 | parseAnimation()はr175で非推奨、r185で削除予定 | E-12 | ○ |
| C-17 | userDataに関数を格納するとクローン時に失われる | E-02 (71-77行目コメント) | ○ |
| C-18 | findByName()で名前からクリップを検索 | E-01 (215-238行目) | ○ |
| C-19 | CreateClipsFromMorphTargetSequences()でモーフターゲット群から複数クリップ生成 | E-01 (253-296行目) | ○ |
| C-20 | clone()で複製を作成 | E-01 (520-536行目) | ○ |
| C-21 | トラック型にはNumber/Vector/Quaternion/Color/String/Booleanがある | E-10, E-01 (1-8行目import) | ○ |
| C-22 | AnimationUtilsのgetKeyframeOrder, sortedArrayを使用 | E-05 (180-182行目) | ○ |
| C-23 | FPS変換時frameTime = 1.0 / fps | E-03 (99行目) | ○ |
| C-24 | scale()でトラックの時間をスケーリング | E-03 (103行目) | ○ |
| C-25 | 画面機能マッピングに該当なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- AnimationClipと画面の直接的な関連は画面機能マッピング.csvに記載されていない
  - AnimationMixer(No.110)は画面との関連があるが、AnimationClip自体は内部データ構造のため画面との直接関連がない
  - 候補：ライブラリ内部クラスのため画面関連なしは妥当

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は高い
- parseAnimation()の非推奨警告については最新バージョンで確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] コンストラクタのパラメータ仕様がソースコードと一致するか確認
- [ ] 静的メソッド(parse, toJSON, CreateFromMorphTargetSequence等)の説明が正確か確認
- [ ] 行番号の参照が現在のソースコードと一致するか確認
- [ ] parseAnimation()の非推奨状態が最新か確認
