---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：112-AnimationAction.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/animation/AnimationAction.js` - 1-933行目（クラス全体）
- E-02: `src/animation/AnimationAction.js` - 9-167行目（コンストラクタ）
- E-03: `src/animation/AnimationAction.js` - 175-181行目（play）
- E-04: `src/animation/AnimationAction.js` - 188-194行目（stop）
- E-05: `src/animation/AnimationAction.js` - 201-212行目（reset）
- E-06: `src/animation/AnimationAction.js` - 305-309行目（fadeIn）
- E-07: `src/animation/AnimationAction.js` - 318-322行目（fadeOut）
- E-08: `src/animation/AnimationAction.js` - 333-352行目（crossFadeFrom）
- E-09: `src/animation/AnimationAction.js` - 470-496行目（warp）
- E-10: `src/animation/AnimationAction.js` - 553-629行目（_update）
- E-11: `src/animation/AnimationAction.js` - 631-666行目（_updateWeight）
- E-12: `src/animation/AnimationAction.js` - 668-709行目（_updateTimeScale）
- E-13: `src/animation/AnimationAction.js` - 711-866行目（_updateTime）
- E-14: `src/constants.js` - LoopRepeat, LoopOnce, LoopPingPong定義
- E-15: `docs/code-to-docs/機能一覧/機能一覧.csv` - 112行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AnimationActionはAnimationClipの再生を制御するクラス | E-01, E-15 | ○ |
| C-02 | コンストラクタでmixer, clip, localRoot, blendModeを受け取る | E-02 (17行目) | ○ |
| C-03 | デフォルトloopはLoopRepeat | E-02 (67行目) | ○ |
| C-04 | time, timeScale, weightのデフォルト値 | E-02 (83-103行目) | ○ |
| C-05 | play()はmixer._activateAction()を呼び出す | E-03 (177行目) | ○ |
| C-06 | stop()はmixer._deactivateAction()とreset()を呼び出す | E-04 (190-192行目) | ○ |
| C-07 | reset()はpaused=false, enabled=true, time=0に戻す | E-05 (203-207行目) | ○ |
| C-08 | fadeIn()は_scheduleFading(duration, 0, 1)を呼び出す | E-06 (307行目) | ○ |
| C-09 | fadeOut()は_scheduleFading(duration, 1, 0)を呼び出す | E-07 (320行目) | ○ |
| C-10 | crossFadeFrom()は双方のフェードを実行 | E-08 (335-336行目) | ○ |
| C-11 | warp時にwarpフラグtrueならタイムスケールも調整 | E-08 (338-348行目) | ○ |
| C-12 | warp()はタイムスケールを動的変更 | E-09 | ○ |
| C-13 | _update()は毎フレームミキサーから呼び出される | E-10 (555行目コメント) | ○ |
| C-14 | enabled=falseの場合_updateWeightのみ実行 | E-10 (557-563行目) | ○ |
| C-15 | weight > 0の場合のみインターポラント評価 | E-10 (597-627行目) | ○ |
| C-16 | AdditiveAnimationBlendModeとNormalAnimationBlendModeで処理分岐 | E-10 (602-625行目) | ○ |
| C-17 | _updateWeight()でフェード処理含む重み計算 | E-11 | ○ |
| C-18 | フェード終了時にinterpolantValue=0ならenabled=false | E-11 (650-654行目) | ○ |
| C-19 | _updateTimeScale()でワープ処理含むタイムスケール計算 | E-12 | ○ |
| C-20 | ワープ終了時にtimeScale=0ならpaused=true | E-12 (688-691行目) | ○ |
| C-21 | _updateTime()でループ処理と時間更新 | E-13 | ○ |
| C-22 | LoopOnceで終了時にfinishedイベント発火 | E-13 (763-767行目) | ○ |
| C-23 | LoopRepeat/PingPongでループ時にloopイベント発火 | E-13 (842-844行目) | ○ |
| C-24 | clampWhenFinished=trueで終了時paused=true | E-13 (758行目) | ○ |
| C-25 | PingPong時に奇数ループで時間反転 | E-13 (854-860行目) | ○ |
| C-26 | _setEndings()でループ境界の補間設定 | E-13 (868-902行目) | ○ |
| C-27 | setDuration()でtimeScale = clip.duration / duration | E-01 (425-430行目) | ○ |
| C-28 | repetitionsはデフォルトInfinity | E-02 (116行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] play/stop/reset/pauseの動作が正確に記述されているか確認
- [ ] fadeIn/fadeOut/crossFadeFromの遷移ロジックが正確か確認
- [ ] ループモード（LoopRepeat, LoopOnce, LoopPingPong）の動作説明が正確か確認
- [ ] イベント発火（finished, loop）のタイミングが正確か確認
- [ ] 行番号の参照が現在のソースコードと一致するか確認
