---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：113-KeyframeTrack.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/animation/KeyframeTrack.js` - 1-637行目（クラス全体）
- E-02: `src/animation/KeyframeTrack.js` - 19-59行目（コンストラクタ）
- E-03: `src/animation/KeyframeTrack.js` - 113-117行目（InterpolantFactoryMethodDiscrete）
- E-04: `src/animation/KeyframeTrack.js` - 126-130行目（InterpolantFactoryMethodLinear）
- E-05: `src/animation/KeyframeTrack.js` - 139-143行目（InterpolantFactoryMethodSmooth）
- E-06: `src/animation/KeyframeTrack.js` - 157-170行目（InterpolantFactoryMethodBezier）
- E-07: `src/animation/KeyframeTrack.js` - 178-239行目（setInterpolation）
- E-08: `src/animation/KeyframeTrack.js` - 287-303行目（shift）
- E-09: `src/animation/KeyframeTrack.js` - 311-327行目（scale）
- E-10: `src/animation/KeyframeTrack.js` - 339-379行目（trim）
- E-11: `src/animation/KeyframeTrack.js` - 387-461行目（validate）
- E-12: `src/animation/KeyframeTrack.js` - 469-580行目（optimize）
- E-13: `src/animation/KeyframeTrack.js` - 68-104行目（toJSON静的メソッド）
- E-14: `src/animation/KeyframeTrack.js` - 604-634行目（プロトタイププロパティ）
- E-15: `docs/code-to-docs/機能一覧/機能一覧.csv` - 113行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KeyframeTrackはキーフレームデータを管理するトラック基底クラス | E-01, E-15 | ○ |
| C-02 | コンストラクタでname, times, values, interpolationを受け取る | E-02 (29行目) | ○ |
| C-03 | nameがundefinedの場合エラー | E-02 (31行目) | ○ |
| C-04 | timesが空または未定義の場合エラー | E-02 (32行目) | ○ |
| C-05 | timesはFloat32Arrayに変換される | E-02 (48行目), E-14 (618行目) | ○ |
| C-06 | valuesはFloat32Arrayに変換される | E-02 (55行目), E-14 (626行目) | ○ |
| C-07 | DefaultInterpolationはInterpolateLinear | E-14 (634行目) | ○ |
| C-08 | setInterpolation()で補間タイプを設定 | E-07 | ○ |
| C-09 | InterpolateDiscreteでDiscreteInterpolant生成 | E-03, E-07 (184-188行目) | ○ |
| C-10 | InterpolateLinearでLinearInterpolant生成 | E-04, E-07 (190-194行目) | ○ |
| C-11 | InterpolateSmoothでCubicInterpolant生成 | E-05, E-07 (196-200行目) | ○ |
| C-12 | InterpolateBezierでBezierInterpolant生成 | E-06, E-07 (202-206行目) | ○ |
| C-13 | サポートされない補間タイプはDefaultInterpolationにフォールバック | E-07 (216-220行目) | ○ |
| C-14 | getValueSize()はvalues.length / times.lengthを返す | E-01 (275-279行目) | ○ |
| C-15 | shift()は全時間値にオフセットを加算 | E-08 | ○ |
| C-16 | scale()は全時間値にスケールを乗算 | E-09 | ○ |
| C-17 | trim()は範囲外のキーフレームを削除 | E-10 | ○ |
| C-18 | trim()は最低1つのキーフレームを維持 | E-10 (364-368行目) | ○ |
| C-19 | validate()で時間順序、NaN値を検証 | E-11 | ○ |
| C-20 | optimize()で冗長なキーフレームを削除 | E-12 | ○ |
| C-21 | toJSON()でトラックをJSON形式に変換 | E-13 | ○ |
| C-22 | clone()で複製を作成 | E-01 (587-600行目) | ○ |
| C-23 | ValueTypeNameはプロトタイプで定義 | E-14 (610行目) | ○ |
| C-24 | Bezier補間時にsettingsからタンジェントデータを取得 | E-06 (162-166行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 補間タイプ（Discrete, Linear, Smooth, Bezier）の動作説明が正確か確認
- [ ] trim()の境界条件（最低1キーフレーム維持）が正確か確認
- [ ] optimize()のロジック説明が正確か確認
- [ ] 行番号の参照が現在のソースコードと一致するか確認
