---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：114-AnimationObjectGroup.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/animation/AnimationObjectGroup.js` - 1-412行目（クラス全体）
- E-02: `src/animation/AnimationObjectGroup.js` - 25-95行目（コンストラクタ）
- E-03: `src/animation/AnimationObjectGroup.js` - 102-188行目（add）
- E-04: `src/animation/AnimationObjectGroup.js` - 195-242行目（remove）
- E-05: `src/animation/AnimationObjectGroup.js` - 249-336行目（uncache）
- E-06: `src/animation/AnimationObjectGroup.js` - 340-375行目（subscribe_）
- E-07: `src/animation/AnimationObjectGroup.js` - 377-407行目（unsubscribe_）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 114行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AnimationObjectGroupは複数オブジェクトに同一アニメーションを適用 | E-01 (5-24行目コメント), E-08 | ○ |
| C-02 | コンストラクタで可変長引数のObject3Dを受け取る | E-02 (32行目) | ○ |
| C-03 | isAnimationObjectGroupフラグはtrue | E-02 (41行目) | ○ |
| C-04 | UUIDはgenerateUUID()で自動生成 | E-02 (49行目) | ○ |
| C-05 | _objectsにキャッシュとアクティブオブジェクトを格納 | E-02 (52行目) | ○ |
| C-06 | nCachedObjects_がキャッシュ領域の閾値 | E-02 (54行目) | ○ |
| C-07 | _indicesByUUIDでUUIDからインデックスを高速検索 | E-02 (58行目) | ○ |
| C-08 | statsでtotal, inUse, bindingsPerObjectを取得可能 | E-02 (73-93行目) | ○ |
| C-09 | add()で新規オブジェクトをACTIVE領域に追加 | E-03 (121-135行目) | ○ |
| C-10 | add()でCACHED→ACTIVEに移動 | E-03 (137-175行目) | ○ |
| C-11 | 同一UUIDの異なるオブジェクト追加でエラーログ | E-03 (177-181行目) | ○ |
| C-12 | remove()でACTIVE→CACHEDに移動 | E-04 | ○ |
| C-13 | uncache()でオブジェクトとバインディングを完全削除 | E-05 | ○ |
| C-14 | subscribe_()でパスに対するバインディング配列を取得/作成 | E-06 | ○ |
| C-15 | subscribe_()は既存パスなら既存配列を返す | E-06 (349行目) | ○ |
| C-16 | subscribe_()は新規パスならPropertyBindingを作成 | E-06 (369行目) | ○ |
| C-17 | unsubscribe_()でパスのバインディング購読を解除 | E-07 | ○ |
| C-18 | 同一プロパティはグループ経由か直接のどちらかでのみ制御可能 | E-01 (22-23行目コメント) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] add/remove/uncacheのキャッシュ管理ロジックが正確に記述されているか確認
- [ ] subscribe_/unsubscribe_の内部インターフェースの説明が正確か確認
- [ ] 行番号の参照が現在のソースコードと一致するか確認
