---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：115-PropertyBinding.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/animation/PropertyBinding.js` - 1-795行目（クラス全体）
- E-02: `src/animation/PropertyBinding.js` - 3-36行目（正規表現パターン）
- E-03: `src/animation/PropertyBinding.js` - 109-152行目（コンストラクタ）
- E-04: `src/animation/PropertyBinding.js` - 164-176行目（create静的メソッド）
- E-05: `src/animation/PropertyBinding.js` - 185-189行目（sanitizeNodeName）
- E-06: `src/animation/PropertyBinding.js` - 209-255行目（parseTrackName）
- E-07: `src/animation/PropertyBinding.js` - 266-324行目（findNode）
- E-08: `src/animation/PropertyBinding.js` - 332-360行目（getter群）
- E-09: `src/animation/PropertyBinding.js` - 364-468行目（setter群）
- E-10: `src/animation/PropertyBinding.js` - 487-717行目（bind）
- E-11: `src/animation/PropertyBinding.js` - 722-731行目（unbind）
- E-12: `src/animation/PropertyBinding.js` - 737-790行目（BindingType/Versioning）
- E-13: `src/animation/PropertyBinding.js` - 38-97行目（Compositeクラス）
- E-14: `docs/code-to-docs/機能一覧/機能一覧.csv` - 115行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PropertyBindingはシーングラフ内のプロパティへの参照を保持 | E-01, E-14 | ○ |
| C-02 | コンストラクタでrootNode, path, parsedPathを受け取る | E-03 (118行目) | ○ |
| C-03 | parsedPathがなければparseTrackNameを呼び出し | E-03 (132行目) | ○ |
| C-04 | findNodeでノードを検索 | E-03 (139行目) | ○ |
| C-05 | 初期状態はgetValue/setValue = unbound | E-03 (149-150行目) | ○ |
| C-06 | create()はAnimationObjectGroupならCompositeを返す | E-04 (166-172行目) | ○ |
| C-07 | sanitizeNodeName()でスペースをアンダースコア、予約文字を削除 | E-05 (187行目) | ○ |
| C-08 | parseTrackName()で正規表現によりパース | E-06 (211行目) | ○ |
| C-09 | parseTrackName結果にnodeName, objectName, propertyName等を含む | E-06 (219-226行目) | ○ |
| C-10 | propertyNameが空の場合エラー | E-06 (247-250行目) | ○ |
| C-11 | findNode()はskeleton.getBoneByName()を使用 | E-07 (277行目) | ○ |
| C-12 | findNode()はchildren配列を再帰検索 | E-07 (290-310行目) | ○ |
| C-13 | _supportedObjectNamesにmaterial, materials, bones, mapを含む | E-02 (36行目) | ○ |
| C-14 | BindingTypeにDirect, EntireArray, ArrayElement, HasFromToArrayがある | E-12 (737-742行目) | ○ |
| C-15 | VersioningにNone, NeedsUpdate, MatrixWorldNeedsUpdateがある | E-12 (744-748行目) | ○ |
| C-16 | bind()でobjectName解決（materials, bones, map） | E-10 (521-608行目) | ○ |
| C-17 | morphTargetInfluencesは名前からインデックスを解決 | E-10 (661-684行目) | ○ |
| C-18 | Material型はVersioning.NeedsUpdate | E-10 (646行目) | ○ |
| C-19 | Object3D型はVersioning.MatrixWorldNeedsUpdate | E-10 (650行目) | ○ |
| C-20 | propertyIndex指定時はBindingType.ArrayElement | E-10 (688行目) | ○ |
| C-21 | fromArray/toArrayメソッド存在時はBindingType.HasFromToArray | E-10 (697行目) | ○ |
| C-22 | Array.isArrayの場合はBindingType.EntireArray | E-10 (703行目) | ○ |
| C-23 | unbind()でnodeをnull、getter/setterをunboundに戻す | E-11 | ○ |
| C-24 | GetterByBindingType配列でバインディングタイプからgetterを選択 | E-12 (750-757行目) | ○ |
| C-25 | SetterByBindingTypeAndVersioning二次元配列でsetter選択 | E-12 (759-790行目) | ○ |
| C-26 | Compositeクラスはグループ内全バインディングに値を設定 | E-13 (61-69行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] parseTrackName()のサポートするパス形式が正確に記述されているか確認
- [ ] bind()のobjectName解決ロジックが正確か確認
- [ ] BindingType/Versioningの組み合わせによるsetter選択が正確か確認
- [ ] 行番号の参照が現在のソースコードと一致するか確認
