---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：116-PropertyMixer.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/animation/PropertyMixer.js` - 1-386行目（クラス全体）
- E-02: `src/animation/PropertyMixer.js` - 6-122行目（コンストラクタ）
- E-03: `src/animation/PropertyMixer.js` - 130-165行目（accumulate）
- E-04: `src/animation/PropertyMixer.js` - 172-191行目（accumulateAdditive）
- E-05: `src/animation/PropertyMixer.js` - 198-244行目（apply）
- E-06: `src/animation/PropertyMixer.js` - 250-274行目（saveOriginalState）
- E-07: `src/animation/PropertyMixer.js` - 279-284行目（restoreOriginalState）
- E-08: `src/animation/PropertyMixer.js` - 324-336行目（_select）
- E-09: `src/animation/PropertyMixer.js` - 338-342行目（_slerp）
- E-10: `src/animation/PropertyMixer.js` - 344-354行目（_slerpAdditive）
- E-11: `src/animation/PropertyMixer.js` - 356-368行目（_lerp）
- E-12: `src/animation/PropertyMixer.js` - 370-380行目（_lerpAdditive）
- E-13: `src/animation/PropertyMixer.js` - 288-318行目（_setIdentity系）
- E-14: `docs/code-to-docs/機能一覧/機能一覧.csv` - 116行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PropertyMixerは複数アニメーションの値をブレンド | E-01, E-14 | ○ |
| C-02 | コンストラクタでbinding, typeName, valueSizeを受け取る | E-02 (15行目) | ○ |
| C-03 | quaternion型はslerp/slerpAdditiveを使用 | E-02 (53-60行目) | ○ |
| C-04 | quaternion型はバッファ6領域（work含む） | E-02 (58行目) | ○ |
| C-05 | bool/string型はselectを使用 | E-02 (62-72行目) | ○ |
| C-06 | bool/string型はArrayを使用 | E-02 (72行目) | ○ |
| C-07 | デフォルトはlerp/lerpAdditiveを使用 | E-02 (75-80行目) | ○ |
| C-08 | デフォルトはFloat64Arrayを使用 | E-02 (80行目) | ○ |
| C-09 | accumulate()で累積重み0なら入力値をコピー | E-03 (141-149行目) | ○ |
| C-10 | accumulate()で累積重み>0ならミックス関数で補間 | E-03 (153-159行目) | ○ |
| C-11 | accumulateAdditive()で累積重み0なら_setIdentity | E-04 (178-182行目) | ○ |
| C-12 | accumulateAdditive()で_mixBufferRegionAdditiveを呼び出し | E-04 (188行目) | ○ |
| C-13 | apply()で累積重み<1ならオリジナル値をブレンド | E-05 (212-219行目) | ○ |
| C-14 | apply()で加算累積あれば追加 | E-05 (223-227行目) | ○ |
| C-15 | apply()で変化検出してsetValueを呼び出し | E-05 (231-241行目) | ○ |
| C-16 | saveOriginalState()でbinding.getValueを呼び出し | E-06 (259行目) | ○ |
| C-17 | saveOriginalState()でaccu0/accu1をorigで初期化 | E-06 (262-265行目) | ○ |
| C-18 | restoreOriginalState()でorigの値を適用 | E-07 | ○ |
| C-19 | _select()でt>=0.5なら値を選択 | E-08 (326行目) | ○ |
| C-20 | _slerp()でQuaternion.slerpFlatを使用 | E-09 (340行目) | ○ |
| C-21 | _slerpAdditive()でmultiplyQuaternionsFlatとslerpFlatを使用 | E-10 (349-352行目) | ○ |
| C-22 | 数値の加算単位元は0、quaternionは(0,0,0,1) | E-13 (288-305行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] バッファレイアウトの説明が正確か確認
- [ ] 各タイプ（quaternion, bool/string, default）の処理分岐が正確か確認
- [ ] ミックス関数（slerp, lerp, select）の動作説明が正確か確認
- [ ] 行番号の参照が現在のソースコードと一致するか確認
