---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：117-AnimationUtils.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/animation/AnimationUtils.js` - 1-496行目（全体）
- E-02: `src/animation/AnimationUtils.js` - 12-24行目（convertArray）
- E-03: `src/animation/AnimationUtils.js` - 32-48行目（getKeyframeOrder）
- E-04: `src/animation/AnimationUtils.js` - 58-77行目（sortedArray）
- E-05: `src/animation/AnimationUtils.js` - 87-159行目（flattenJSON）
- E-06: `src/animation/AnimationUtils.js` - 171-240行目（subclip）
- E-07: `src/animation/AnimationUtils.js` - 251-372行目（makeClipAdditive）
- E-08: `src/animation/AnimationUtils.js` - 379-484行目（AnimationUtilsクラス）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 117行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AnimationUtilsはアニメーション関連のユーティリティ関数群 | E-01, E-09 | ○ |
| C-02 | convertArray()で配列型変換 | E-02 | ○ |
| C-03 | 同じ型ならそのまま返す | E-02 (14行目) | ○ |
| C-04 | TypedArrayならnew type(array) | E-02 (18行目) | ○ |
| C-05 | Arrayならslice.call | E-02 (22行目) | ○ |
| C-06 | getKeyframeOrder()でソートインデックス配列を返す | E-03 | ○ |
| C-07 | sortedArray()でorderに従ってvaluesを並べ替え | E-04 | ○ |
| C-08 | flattenJSON()でAOS形式のJSONをtimes/valuesに展開 | E-05 | ○ |
| C-09 | flattenJSONはArray、toArray()、プリミティブを処理 | E-05 (102-157行目) | ○ |
| C-10 | subclip()でフレーム範囲のクリップを切り出し | E-06 | ○ |
| C-11 | subclip()はsourceClipをclone | E-06 (173行目) | ○ |
| C-12 | subclip()で最小開始時間を0にシフト | E-06 (228-234行目) | ○ |
| C-13 | subclip()で空トラックは除外 | E-06 (203行目) | ○ |
| C-14 | makeClipAdditive()で加算フォーマットに変換 | E-07 | ○ |
| C-15 | fps <= 0の場合は30をデフォルト | E-07 (253行目) | ○ |
| C-16 | bool/stringトラックはスキップ | E-07 (265行目) | ○ |
| C-17 | quaternionは共役を使用 | E-07 (325-329行目) | ○ |
| C-18 | 数値は参照値を減算 | E-07 (351-358行目) | ○ |
| C-19 | blendModeをAdditiveAnimationBlendModeに設定 | E-07 (368行目) | ○ |
| C-20 | 関数とクラスメソッド両方でエクスポート | E-01 (486-495行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] subclip()のフレーム抽出ロジックが正確か確認
- [ ] makeClipAdditive()のquaternion処理が正確か確認
- [ ] flattenJSON()の各分岐処理が正確か確認
- [ ] 行番号の参照が現在のソースコードと一致するか確認
