---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：118-Audio.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/audio/Audio.js` - 1-779行目（クラス全体）
- E-02: `src/audio/Audio.js` - 29-216行目（コンストラクタ）
- E-03: `src/audio/Audio.js` - 238-247行目（setNodeSource）
- E-04: `src/audio/Audio.js` - 257-266行目（setMediaElementSource）
- E-05: `src/audio/Audio.js` - 276-285行目（setMediaStreamSource）
- E-06: `src/audio/Audio.js` - 295-304行目（setBuffer）
- E-07: `src/audio/Audio.js` - 314-349行目（play）
- E-08: `src/audio/Audio.js` - 358-390行目（pause）
- E-09: `src/audio/Audio.js` - 400-422行目（stop）
- E-10: `src/audio/Audio.js` - 430-454行目（connect）
- E-11: `src/audio/Audio.js` - 462-492行目（disconnect）
- E-12: `src/audio/Audio.js` - 511-529行目（setFilters）
- E-13: `docs/code-to-docs/機能一覧/機能一覧.csv` - 118行目
- E-14: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 95行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Audioは非位置依存オーディオオブジェクト | E-01 (5-8行目コメント), E-13 | ○ |
| C-02 | Object3Dを継承 | E-01 (29行目) | ○ |
| C-03 | コンストラクタでAudioListenerを受け取る | E-02 (36行目) | ○ |
| C-04 | listenerからcontextを取得 | E-02 (56行目) | ○ |
| C-05 | GainNodeを作成しlistenerに接続 | E-02 (63-65行目) | ○ |
| C-06 | autoplayプロパティ | E-02 (73行目) | ○ |
| C-07 | sourceTypeはempty/buffer/audioNode/mediaNode/mediaStreamNode | E-02 (200行目) | ○ |
| C-08 | hasPlaybackControlデフォルトtrue | E-02 (178行目) | ○ |
| C-09 | setNodeSourceでhasPlaybackControl=false | E-03 (240行目) | ○ |
| C-10 | setMediaElementSourceでcreateMediaElementSource使用 | E-04 (261行目) | ○ |
| C-11 | setMediaStreamSourceでcreateMediaStreamSource使用 | E-05 (280行目) | ○ |
| C-12 | setBufferでautoplayならplay呼び出し | E-06 (300行目) | ○ |
| C-13 | play()で再生中なら警告 | E-07 (316-319行目) | ○ |
| C-14 | play()でhasPlaybackControl=falseなら警告 | E-07 (323-326行目) | ○ |
| C-15 | play()でcreateBufferSource、start呼び出し | E-07 (332-338行目) | ○ |
| C-16 | pause()で_progress計算 | E-08 (371行目) | ○ |
| C-17 | pause()でループ時はmodulo | E-08 (377行目) | ○ |
| C-18 | stop()で_progress=0 | E-09 (409行目) | ○ |
| C-19 | connect()でフィルターチェーン接続 | E-10 (432-448行目) | ○ |
| C-20 | setFilters()でdisconnect→設定→connect | E-12 (515-519行目) | ○ |
| C-21 | WebAudioサンプルで主機能として使用 | E-14 | ○ |
| C-22 | setVolume()でgain.gain.setTargetAtTime使用 | E-01 (731-735行目) | ○ |
| C-23 | setDetune()でsource.detune.setTargetAtTime使用 | E-01 (537-545行目) | ○ |
| C-24 | setPlaybackRate()でsource.playbackRate.setTargetAtTime使用 | E-01 (593-608行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] play/pause/stopの再生制御ロジックが正確か確認
- [ ] フィルターチェーンの接続ロジックが正確か確認
- [ ] sourceType別の動作が正確に記述されているか確認
- [ ] 行番号の参照が現在のソースコードと一致するか確認
