---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：119-AudioListener.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/audio/AudioListener.js` - 1-217行目（クラス全体）
- E-02: `src/audio/AudioListener.js` - 14-23行目（クラスコメント）
- E-03: `src/audio/AudioListener.js` - 29-76行目（コンストラクタ）
- E-04: `src/audio/AudioListener.js` - 85-89行目（getInput）
- E-05: `src/audio/AudioListener.js` - 96-109行目（removeFilter）
- E-06: `src/audio/AudioListener.js` - 128-147行目（setFilter）
- E-07: `src/audio/AudioListener.js` - 154-158行目（getMasterVolume）
- E-08: `src/audio/AudioListener.js` - 167-173行目（setMasterVolume）
- E-09: `src/audio/AudioListener.js` - 175-212行目（updateMatrixWorld）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` - 119行目
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 95行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AudioListenerは仮想リスナーを表現 | E-02 (14-17行目コメント), E-10 | ○ |
| C-02 | Object3Dを継承 | E-01 (24行目) | ○ |
| C-03 | コンストラクタに引数なし | E-03 (29行目) | ○ |
| C-04 | AudioContext.getContext()でcontext取得 | E-03 (41行目) | ○ |
| C-05 | createGain()でGainNode作成 | E-03 (49行目) | ○ |
| C-06 | gain.connect(context.destination) | E-03 (50行目) | ○ |
| C-07 | filterはデフォルトnull | E-03 (61行目) | ○ |
| C-08 | timeDeltaはデフォルト0 | E-03 (70行目) | ○ |
| C-09 | _clockでClockインスタンス保持 | E-03 (74行目) | ○ |
| C-10 | getInput()はgainを返す | E-04 (87行目) | ○ |
| C-11 | removeFilter()でフィルター切断 | E-05 (100-103行目) | ○ |
| C-12 | setFilter()でgain→filter→destination接続 | E-06 (141-143行目) | ○ |
| C-13 | 既存フィルターがあれば切断してから設定 | E-06 (130-133行目) | ○ |
| C-14 | getMasterVolume()でgain.gain.value返却 | E-07 (156行目) | ○ |
| C-15 | setMasterVolume()でsetTargetAtTime使用 | E-08 (169行目) | ○ |
| C-16 | updateMatrixWorldでsuper呼び出し | E-09 (177行目) | ○ |
| C-17 | _clock.getDelta()でtimeDelta更新 | E-09 (181行目) | ○ |
| C-18 | matrixWorldからposition/quaternion/scale分解 | E-09 (183行目) | ○ |
| C-19 | forward(-Z)とup(Y)ベクトル計算 | E-09 (186-187行目) | ○ |
| C-20 | positionX存在時はlinearRampToValueAtTime使用 | E-09 (189-203行目) | ○ |
| C-21 | positionX非存在時はsetPosition/setOrientation使用 | E-09 (207-208行目) | ○ |
| C-22 | WebAudioサンプルで主機能として使用 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] フィルター接続/切断ロジックが正確か確認
- [ ] マスターボリューム制御が正確か確認
- [ ] updateMatrixWorldのリスナー更新ロジックが正確か確認
- [ ] Chrome向けとレガシー向けの分岐が正確か確認
- [ ] 行番号の参照が現在のソースコードと一致するか確認
