---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-InterleavedBuffer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/core/InterleavedBuffer.js` 1-292行目
- E-02: `src/math/MathUtils.js`（generateUUID関数）
- E-03: `src/constants.js`（StaticDrawUsage定数定義）
- E-04: `src/core/InterleavedBufferAttribute.js`（関連クラス）
- E-05: `src/core/BufferGeometry.js`（使用箇所）
- E-06: `src/renderers/webgl/WebGLAttributes.js`（GPU転送）
- E-07: `機能一覧.csv` 12行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TypedArrayをベースとしたバッファを管理 | E-01 (15-16行目, 34行目) | ○ |
| C-02 | strideプロパティで頂点あたりの要素数を管理 | E-01 (41行目) | ○ |
| C-03 | countはarray.length / strideで計算される | E-01 (49行目) | ○ |
| C-04 | isInterleavedBufferフラグがtrueに設定される | E-01 (27行目) | ○ |
| C-05 | usageのデフォルト値はStaticDrawUsage | E-01 (60行目), E-03 | ○ |
| C-06 | updateRangesで部分更新範囲を管理 | E-01 (68行目) | ○ |
| C-07 | versionプロパティで更新を追跡 | E-01 (75行目) | ○ |
| C-08 | UUIDはMathUtils.generateUUID()で生成 | E-01 (1行目, 83行目), E-02 | ○ |
| C-09 | onUploadCallbackでGPU転送完了時の処理を設定可能 | E-01 (91行目, 242-248行目) | ○ |
| C-10 | needsUpdate=true時にversionがインクリメント | E-01 (101-105行目) | ○ |
| C-11 | setUsage()で使用パターンを変更できる | E-01 (113-119行目) | ○ |
| C-12 | addUpdateRange()で更新範囲を追加できる | E-01 (127-131行目) | ○ |
| C-13 | clearUpdateRanges()で更新範囲をクリアできる | E-01 (136-140行目) | ○ |
| C-14 | copy()でディープコピーが行われる | E-01 (148-157行目) | ○ |
| C-15 | copyAt()で特定頂点のデータをコピーできる | E-01 (169-182行目) | ○ |
| C-16 | set()で配列データを設定できる | E-01 (191-197行目) | ○ |
| C-17 | clone()でインスタンスを複製できる | E-01 (205-232行目) | ○ |
| C-18 | clone時にarrayBufferが共有される | E-01 (207-223行目) | ○ |
| C-19 | toJSON()でシリアライズできる | E-01 (256-287行目) | ○ |
| C-20 | InterleavedBufferAttributeと組み合わせて使用される | E-01 (5-9行目コメント), E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] InterleavedBufferの主要メソッド（setUsage, addUpdateRange, copy, clone, toJSON）の動作確認
- [ ] InterleavedBufferAttributeとの連携が正しく記述されているか確認
- [ ] updateRangesによる部分更新の仕組みが正しく説明されているか確認
- [ ] clone時のarrayBuffer共有の説明が適切か確認
