---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：120-PositionalAudio.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/audio/PositionalAudio.js` - 1-254行目（クラス全体）
- E-02: `src/audio/PositionalAudio.js` - 10-39行目（クラスコメント・使用例）
- E-03: `src/audio/PositionalAudio.js` - 47-62行目（コンストラクタ）
- E-04: `src/audio/PositionalAudio.js` - 64-72行目（connect）
- E-05: `src/audio/PositionalAudio.js` - 74-82行目（disconnect）
- E-06: `src/audio/PositionalAudio.js` - 84-88行目（getOutput）
- E-07: `src/audio/PositionalAudio.js` - 109-115行目（setRefDistance）
- E-08: `src/audio/PositionalAudio.js` - 134-140行目（setRolloffFactor）
- E-09: `src/audio/PositionalAudio.js` - 163-169行目（setDistanceModel）
- E-10: `src/audio/PositionalAudio.js` - 191-197行目（setMaxDistance）
- E-11: `src/audio/PositionalAudio.js` - 207-215行目（setDirectionalCone）
- E-12: `src/audio/PositionalAudio.js` - 217-249行目（updateMatrixWorld）
- E-13: `docs/code-to-docs/機能一覧/機能一覧.csv` - 120行目
- E-14: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 95行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PositionalAudioは位置依存オーディオオブジェクト | E-02 (10-11行目コメント), E-13 | ○ |
| C-02 | Audioクラスを継承 | E-01 (40行目) | ○ |
| C-03 | コンストラクタでlistenerを受け取る | E-03 (47行目) | ○ |
| C-04 | super(listener)でAudio初期化 | E-03 (49行目) | ○ |
| C-05 | createPanner()でPannerNode作成 | E-03 (58行目) | ○ |
| C-06 | panningModel='HRTF'に設定 | E-03 (59行目) | ○ |
| C-07 | panner.connect(this.gain) | E-03 (60行目) | ○ |
| C-08 | connect()でsuper.connect()後にpanner接続 | E-04 (66-68行目) | ○ |
| C-09 | disconnect()でsuper.disconnect()後にpanner切断 | E-05 (76-78行目) | ○ |
| C-10 | getOutput()はpannerを返す | E-06 (86行目) | ○ |
| C-11 | setRefDistance()でpanner.refDistance設定 | E-07 (111行目) | ○ |
| C-12 | setRolloffFactor()でpanner.rolloffFactor設定 | E-08 (136行目) | ○ |
| C-13 | setDistanceModel()でpanner.distanceModel設定 | E-09 (165行目) | ○ |
| C-14 | distanceModelはlinear/inverse/exponential | E-09 (160行目コメント) | ○ |
| C-15 | setMaxDistance()でpanner.maxDistance設定 | E-10 (193行目) | ○ |
| C-16 | maxDistanceはlinear距離モデルで使用 | E-10 (186行目コメント) | ○ |
| C-17 | setDirectionalCone()で3パラメータ設定 | E-11 (209-211行目) | ○ |
| C-18 | updateMatrixWorldでsuper呼び出し | E-12 (219行目) | ○ |
| C-19 | hasPlaybackControl=true かつ isPlaying=falseなら早期リターン | E-12 (221行目) | ○ |
| C-20 | matrixWorldからposition/quaternion/scale分解 | E-12 (223行目) | ○ |
| C-21 | orientationはZ軸正方向(0,0,1)を回転 | E-12 (225行目) | ○ |
| C-22 | positionX存在時はlinearRampToValueAtTime使用 | E-12 (229-240行目) | ○ |
| C-23 | positionX非存在時はsetPosition/setOrientation使用 | E-12 (244-245行目) | ○ |
| C-24 | WebAudioサンプルで主機能として使用 | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] PannerNodeの初期化ロジックが正確か確認
- [ ] connect/disconnectのオーバーライドが正確か確認
- [ ] 距離パラメータ設定メソッドが正確か確認
- [ ] 指向性コーン設定が正確か確認
- [ ] updateMatrixWorldの位置更新ロジックが正確か確認
- [ ] 行番号の参照が現在のソースコードと一致するか確認
