---
generated_at: 2026-01-27 12:32:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート: 122-AudioContext

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **AudioContext制限数**：ブラウザ実装に依存
  2. **自動再生ポリシー詳細**：ブラウザバージョンに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/audio/AudioContext.js` - AudioContextユーティリティ実装
- E-02: `src/audio/AudioListener.js` - AudioContext使用例
- E-03: `src/audio/Audio.js` - AudioContext使用例
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-05: Web Audio API仕様（外部仕様）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | モジュールレベルで_context変数を管理 | E-01 (1行目) | ○ |
| C-02 | シングルトンパターンを採用 | E-01 (3-8行目) | ○ |
| C-03 | 初回呼び出し時のみインスタンス作成 | E-01 (4-6行目) | ○ |
| C-04 | window.AudioContextを使用 | E-01 (5行目) | ○ |
| C-05 | window.webkitAudioContextにフォールバック | E-01 (5行目) | ○ |
| C-06 | 関数はexportされている | E-01 (11行目) | ○ |
| C-07 | AudioListenerで使用される | E-02 | ○ |
| C-08 | Audioクラスで使用される | E-03 | ○ |
| C-09 | AudioContext状態はsuspended/running/closed | E-05 | ○ |
| C-10 | ユーザーインタラクション後にresume必要 | E-05 | ○ |
| C-11 | キャッシュしたインスタンスを返却 | E-01 (7行目) | ○ |
| C-12 | AudioAnalyserはaudio.context経由で使用 | E-01, E-03 | ○ |
| C-13 | 古いSafariでwebkitAudioContextが必要 | E-01 (5行目) | ○ |
| C-14 | ブラウザでAudioContext数制限がある | **根拠なし** | △ |
| C-15 | Chrome 66+で自動再生制限 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ブラウザごとのAudioContext制限数
  - 候補：ブラウザ公式ドキュメント / MDN / caniuse.com
- 自動再生ポリシーのバージョン詳細
  - 候補：Chrome DevBlog / Safari Release Notes / MDN

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シングルトンパターンの実装は正確
- 1: 中リスク - ブラウザ互換性の詳細は変動する可能性
- 0: 低リスク - Web Audio API仕様に基づく記述

## 6) レビュアーチェックリスト（最小）
- [ ] AudioContext.jsの実装とシングルトンパターンの確認
- [ ] webkit prefixの必要性と対象ブラウザの確認
- [ ] AudioListenerでの使用方法の確認
- [ ] 自動再生ポリシーの最新情報確認
- [ ] ブラウザごとのAudioContext制限数確認
