---
generated_at: 2026-01-27 12:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 126-Matrix3

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全項目が根拠ありのため、特に優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/math/Matrix3.js` - Matrix3クラス実装
- E-02: `src/math/Matrix4.js` - 4x4行列実装
- E-03: `src/math/Vector3.js` - 基底ベクトル抽出
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | elementsプロパティを持つ | E-01 (62-68行目) | ○ |
| C-02 | 列優先格納 | E-01 (1-27行目コメント) | ○ |
| C-03 | isMatrix3フラグを持つ | E-01 (55行目) | ○ |
| C-04 | デフォルトは単位行列 | E-01 (62-68行目) | ○ |
| C-05 | set()は行優先引数 | E-01 (78-103行目) | ○ |
| C-06 | identity()メソッドが存在 | E-01 (110-122行目) | ○ |
| C-07 | multiply()メソッドが存在 | E-01 (188-193行目) | ○ |
| C-08 | premultiply()メソッドが存在 | E-01 (201-206行目) | ○ |
| C-09 | multiplyMatrices()メソッドが存在 | E-01 (215-243行目) | ○ |
| C-10 | multiplyScalar()メソッドが存在 | E-01 (251-261行目) | ○ |
| C-11 | determinant()メソッドが存在 | E-01 (268-278行目) | ○ |
| C-12 | invert()メソッドが存在 | E-01 (287-319行目) | ○ |
| C-13 | transpose()メソッドが存在 | E-01 (326-337行目) | ○ |
| C-14 | setFromMatrix4()メソッドが存在 | E-01 (167-181行目) | ○ |
| C-15 | getNormalMatrix()メソッドが存在 | E-01 (346-350行目) | ○ |
| C-16 | extractBasis()メソッドが存在 | E-01 (151-159行目) | ○ |
| C-17 | makeTranslation()メソッドが存在 | E-01 (456-482行目) | ○ |
| C-18 | makeRotation()メソッドが存在 | E-01 (490-507行目) | ○ |
| C-19 | makeScale()メソッドが存在 | E-01 (516-528行目) | ○ |
| C-20 | setUvTransform()メソッドが存在 | E-01 (388-401行目) | ○ |
| C-21 | scale()メソッドが存在 | E-01 (410-416行目) | ○ |
| C-22 | rotate()メソッドが存在 | E-01 (424-430行目) | ○ |
| C-23 | translate()メソッドが存在 | E-01 (439-445行目) | ○ |
| C-24 | det=0でゼロ行列を返す | E-01 (301行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全メソッドがソースコードで確認済み
- 0: 低リスク - 行列計算式は標準的な線形代数
- 0: 低リスク - 法線行列の計算式も標準的

## 6) レビュアーチェックリスト（最小）
- [ ] Matrix3.jsの実装と設計書の整合性確認
- [ ] 行優先/列優先の変換が正しく説明されているか確認
- [ ] invert()のゼロ行列返却挙動の確認
- [ ] getNormalMatrix()の計算式確認
- [ ] 2D変換メソッド(scale/rotate/translate)の動作確認
