---
generated_at: 2026-01-27 12:42:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート: 127-Matrix4

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **decompose()の制限事項**：数学的根拠の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/math/Matrix4.js` - Matrix4クラス実装
- E-02: `src/math/Quaternion.js` - クォータニオン実装
- E-03: `src/math/Euler.js` - オイラー角実装
- E-04: `src/math/Vector3.js` - ベクトル実装
- E-05: `src/constants.js` - 座標系定数
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | elementsプロパティを持つ | E-01 (82-89行目) | ○ |
| C-02 | 列優先格納 | E-01 (15-40行目コメント) | ○ |
| C-03 | isMatrix4フラグを持つ | E-01 (75行目) | ○ |
| C-04 | デフォルトは単位行列 | E-01 (82-89行目) | ○ |
| C-05 | set()は行優先引数 | E-01 (99-132行目) | ○ |
| C-06 | identity()メソッドが存在 | E-01 (139-152行目) | ○ |
| C-07 | multiply()メソッドが存在 | E-01 (532-536行目) | ○ |
| C-08 | premultiply()メソッドが存在 | E-01 (544-548行目) | ○ |
| C-09 | multiplyMatrices()メソッドが存在 | E-01 (558-596行目) | ○ |
| C-10 | determinant()メソッドが存在 | E-01 (624-646行目) | ○ |
| C-11 | invert()メソッドが存在 | E-01 (708-759行目) | ○ |
| C-12 | transpose()メソッドが存在 | E-01 (653-668行目) | ○ |
| C-13 | makeTranslation()メソッドが存在 | E-01 (806-834行目) | ○ |
| C-14 | makeRotationX/Y/Z()メソッドが存在 | E-01 (843-906行目) | ○ |
| C-15 | makeRotationAxis()メソッドが存在 | E-01 (919-940行目) | ○ |
| C-16 | makeRotationFromEuler()メソッドが存在 | E-01 (334-454行目) | ○ |
| C-17 | makeRotationFromQuaternion()メソッドが存在 | E-01 (464-468行目) | ○ |
| C-18 | makeScale()メソッドが存在 | E-01 (950-963行目) | ○ |
| C-19 | makeShear()メソッドが存在 | E-01 (976-989行目) | ○ |
| C-20 | makePerspective()メソッドが存在 | E-01 (1118-1162行目) | ○ |
| C-21 | makeOrthographic()メソッドが存在 | E-01 (1178-1222行目) | ○ |
| C-22 | compose()メソッドが存在 | E-01 (1000-1034行目) | ○ |
| C-23 | decompose()メソッドが存在 | E-01 (1049-1102行目) | ○ |
| C-24 | extractBasis()メソッドが存在 | E-01 (235-253行目) | ○ |
| C-25 | makeBasis()メソッドが存在 | E-01 (263-274行目) | ○ |
| C-26 | lookAt()メソッドが存在 | E-01 (479-524行目) | ○ |
| C-27 | WebGLCoordinateSystemをサポート | E-01, E-05 | ○ |
| C-28 | WebGPUCoordinateSystemをサポート | E-01, E-05 | ○ |
| C-29 | det=0でゼロ行列を返す | E-01 (733行目) | ○ |
| C-30 | decompose()は非一様スケールで不正確 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- decompose()の数学的制限についての公式説明
  - 候補：three.js公式ドキュメント / GitHub Issue / 数学文献

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全メソッドがソースコードで確認済み
- 0: 低リスク - 行列計算式は標準的な線形代数
- 1: 中リスク - decompose()の制限は実装確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Matrix4.jsの実装と設計書の整合性確認
- [ ] compose()/decompose()の対称性確認
- [ ] makePerspective()のWebGL/WebGPU座標系対応確認
- [ ] lookAt()の計算式確認
- [ ] decompose()の制限事項の妥当性確認
