---
generated_at: 2026-01-27 12:46:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート: 129-Euler

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **回転順序の用途説明**：業界標準の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/math/Euler.js` - Eulerクラス実装
- E-02: `src/math/Quaternion.js` - クォータニオン実装
- E-03: `src/math/Matrix4.js` - 回転行列実装
- E-04: `src/math/MathUtils.js` - clamp関数
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | _x, _y, _z, _orderプロパティを持つ | E-01 (46-49行目) | ○ |
| C-02 | デフォルトはx=y=z=0, order='XYZ' | E-01 (35行目) | ○ |
| C-03 | isEulerフラグを持つ | E-01 (44行目) | ○ |
| C-04 | DEFAULT_ORDERは'XYZ' | E-01 (447行目) | ○ |
| C-05 | 6つの回転順序をサポート | E-01 (196-304行目) | ○ |
| C-06 | set()メソッドが存在 | E-01 (138-149行目) | ○ |
| C-07 | clone()メソッドが存在 | E-01 (156-160行目) | ○ |
| C-08 | copy()メソッドが存在 | E-01 (168-179行目) | ○ |
| C-09 | setFromRotationMatrix()メソッドが存在 | E-01 (189-318行目) | ○ |
| C-10 | setFromQuaternion()メソッドが存在 | E-01 (328-334行目) | ○ |
| C-11 | setFromVector3()メソッドが存在 | E-01 (343-347行目) | ○ |
| C-12 | reorder()メソッドが存在 | E-01 (359-365行目) | ○ |
| C-13 | equals()メソッドが存在 | E-01 (373-377行目) | ○ |
| C-14 | fromArray()メソッドが存在 | E-01 (387-398行目) | ○ |
| C-15 | toArray()メソッドが存在 | E-01 (408-417行目) | ○ |
| C-16 | setterで_onChangeCallback呼び出し | E-01 (65-68行目等) | ○ |
| C-17 | ジンバルロック対策(0.9999999閾値) | E-01 (202行目等) | ○ |
| C-18 | イテレータをサポート | E-01 (429-436行目) | ○ |
| C-19 | クォータニオン経由でreorder | E-01 (361-363行目) | ○ |
| C-20 | 回転行列経由でsetFromQuaternion | E-01 (330-332行目) | ○ |
| C-21 | clamp関数を使用 | E-01 (3行目, 200行目等) | ○ |
| C-22 | YXZはFPSカメラによく使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 回転順序の用途についての業界標準
  - 候補：3Dグラフィックス教科書 / ゲームエンジンドキュメント / 航空機姿勢文献

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全メソッドがソースコードで確認済み
- 0: 低リスク - ジンバルロック対策の閾値確認済み
- 1: 中リスク - 回転順序の用途説明は一般論

## 6) レビュアーチェックリスト（最小）
- [ ] Euler.jsの実装と設計書の整合性確認
- [ ] setFromRotationMatrix()の6つの分岐確認
- [ ] ジンバルロック対策の閾値（0.9999999）妥当性確認
- [ ] reorder()のクォータニオン経由変換確認
- [ ] _onChangeCallback()の呼び出しタイミング確認
