---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：13-WebGLRenderer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **VR時90fpsの目標**：一般的なVR推奨値だが、Three.js内での明示的な記述なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/renderers/WebGLRenderer.js` 1-900行目（部分読み込み）
- E-02: `src/renderers/WebGLRenderTarget.js` 全文
- E-03: `src/renderers/webgl/WebGLState.js`（参照）
- E-04: `src/renderers/webgl/WebGLPrograms.js`（参照）
- E-05: `src/renderers/webxr/WebXRManager.js`（参照）
- E-06: `機能一覧.csv` 13行目
- E-07: `画面機能マッピング.csv` 複数行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebGL 2 APIを使用してレンダリング | E-01 (59-63行目コメント, 388行目) | ○ |
| C-02 | WebGL 1はr163以降サポート外 | E-01 (101-103行目) | ○ |
| C-03 | isWebGLRendererフラグがtrueに設定 | E-01 (95行目) | ○ |
| C-04 | domElementプロパティでキャンバスを保持 | E-01 (159行目) | ○ |
| C-05 | debugオブジェクトでシェーダーエラーチェック設定 | E-01 (176-188行目) | ○ |
| C-06 | autoClearがtrueでrender前に自動クリア | E-01 (198行目) | ○ |
| C-07 | autoClearColor/Depth/Stencilで個別制御 | E-01 (207-225行目) | ○ |
| C-08 | sortObjectsでオブジェクトソートを制御 | E-01 (241行目) | ○ |
| C-09 | clippingPlanesでクリッピング平面を設定 | E-01 (250行目) | ○ |
| C-10 | toneMappingでトーンマッピング設定 | E-01 (269行目) | ○ |
| C-11 | toneMappingExposureで露出設定 | E-01 (277行目) | ○ |
| C-12 | transmissionResolutionScaleでトランスミッション解像度設定 | E-01 (289行目) | ○ |
| C-13 | initGLContext()でサブシステム初期化 | E-01 (423-540行目) | ○ |
| C-14 | WebXRManagerでVR/AR対応 | E-01 (552-559行目), E-05 | ○ |
| C-15 | getContext()でWebGL2RenderingContextを取得 | E-01 (566-570行目) | ○ |
| C-16 | setPixelRatio()でデバイスピクセル比設定 | E-01 (619-627行目) | ○ |
| C-17 | setSize()でキャンバスサイズ設定 | E-01 (650-680行目) | ○ |
| C-18 | setViewport()でビューポート設定 | E-01 (787-801行目) | ○ |
| C-19 | setScissor()でシザー領域設定 | E-01 (824-838行目) | ○ |
| C-20 | getClearColor()でクリア色を取得 | E-01 (896-899行目) | ○ |
| C-21 | WebGLRenderTargetでオフスクリーンレンダリング | E-02 | ○ |
| C-22 | 複数の画面で主機能として使用される | E-07 | ○ |
| C-23 | infoオブジェクトでレンダリング統計取得 | E-01 (536行目) | ○ |
| C-24 | capabilitiesでWebGL機能情報取得 | E-01 (469行目) | ○ |
| C-25 | VR時は90fpsが目標 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- VR時のフレームレート目標値の公式ドキュメント
  - 候補：WebXR仕様書 / Three.js公式ドキュメント / VRデバイスメーカーガイドライン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な主張が大部分
- 1: 中リスク - パフォーマンス目標値は一般的なVR推奨値に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] WebGLRendererの主要メソッド（render, setSize, setRenderTarget）の動作確認
- [ ] サブシステム（WebGLState, WebGLPrograms等）との連携が正しく記述されているか確認
- [ ] 画面機能マッピングとの整合性確認
- [ ] WebXR対応の記述が適切か確認
