---
generated_at: 2026-01-27 12:37:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：133-Sphere.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在するため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/math/Sphere.js` - Sphereクラスの実装ファイル（421行）
- E-02: `src/math/Vector3.js` - 依存するVector3クラス
- E-03: `src/math/Box3.js` - 相互参照するBox3クラス
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Sphereは3D球体を表現する | E-01 (8-11行目: JSDocコメント) | ○ |
| C-02 | center（Vector3）とradius（number）で定義 | E-01 (20-43行目: constructor) | ○ |
| C-03 | isSphereフラグが存在する | E-01 (28-29行目) | ○ |
| C-04 | デフォルトでcenterは(0,0,0) | E-01 (20行目) | ○ |
| C-05 | デフォルトでradiusは-1（空の球） | E-01 (20行目) | ○ |
| C-06 | setFromPointsメソッドが存在する | E-01 (73-99行目) | ○ |
| C-07 | 中心未指定時はAABBの中心を使用 | E-01 (77-85行目) | ○ |
| C-08 | isEmptyはradius < 0で判定 | E-01 (124-128行目) | ○ |
| C-09 | containsPointメソッドが存在する | E-01 (151-155行目) | ○ |
| C-10 | distanceToPointメソッドが存在する | E-01 (165-169行目) | ○ |
| C-11 | intersectsSphereメソッドが存在する | E-01 (177-183行目) | ○ |
| C-12 | intersectsBoxメソッドが存在する | E-01 (191-195行目) | ○ |
| C-13 | intersectsPlaneメソッドが存在する | E-01 (203-207行目) | ○ |
| C-14 | clampPointメソッドが存在する | E-01 (218-233行目) | ○ |
| C-15 | getBoundingBoxメソッドが存在する | E-01 (241-256行目) | ○ |
| C-16 | applyMatrix4でgetMaxScaleOnAxisを使用 | E-01 (264-271行目) | ○ |
| C-17 | expandByPointメソッドが存在する | E-01 (293-325行目) | ○ |
| C-18 | unionメソッドが存在する | E-01 (333-365行目) | ○ |
| C-19 | toJSONメソッドが存在する | E-01 (395-402行目) | ○ |
| C-20 | fromJSONメソッドが存在する | E-01 (410-416行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張がソースコードから直接検証可能。

## 5) リスクフラグ（レビュー観点）

- リスクレベル: 0（低リスク）
- Sphereは単純な数学ユーティリティクラスであり、実装が明確

## 6) レビュアーチェックリスト（最小）

- [x] クラスの基本構造（center/radius/isSphere）が正確に記載されているか
- [x] setFromPointsの処理フロー（中心決定 + 最大距離計算）が正確か
- [x] applyMatrix4のスケール処理（getMaxScaleOnAxis）が正しく説明されているか
- [x] expandByPointの拡張ロジックが正確に記載されているか
- [x] unionの2球合成ロジックが正しく説明されているか
