---
generated_at: 2026-01-27 12:42:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：138-Frustum.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在するため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/math/Frustum.js` - Frustumクラスの実装ファイル（286行）
- E-02: `src/math/Plane.js` - 依存するPlaneクラス
- E-03: `src/math/Sphere.js` - 交差判定で使用するSphereクラス
- E-04: `src/constants.js` - 座標系定数の定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Frustumは視錐台を表現する | E-01 (11-17行目: JSDocコメント) | ○ |
| C-02 | 6つのPlaneで構成される | E-01 (30行目, 37行目) | ○ |
| C-03 | setFromProjectionMatrixメソッドが存在する | E-01 (95-136行目) | ○ |
| C-04 | 行列要素から6平面を計算する | E-01 (98-107行目) | ○ |
| C-05 | coordinateSystemパラメータがある | E-01 (91行目, 118-130行目) | ○ |
| C-06 | reversedDepthパラメータがある | E-01 (92行目, 109-132行目) | ○ |
| C-07 | WebGLCoordinateSystem/WebGPUCoordinateSystemをサポート | E-01 (1行目: import), E-04 | ○ |
| C-08 | intersectsObjectメソッドが存在する | E-01 (146-166行目) | ○ |
| C-09 | object.boundingSphereまたはgeometry.boundingSphereを使用 | E-01 (148-160行目) | ○ |
| C-10 | intersectsSpriteメソッドが存在する | E-01 (174-185行目) | ○ |
| C-11 | intersectsSphereメソッドが存在する | E-01 (193-213行目) | ○ |
| C-12 | 6平面との距離チェックを行う | E-01 (199-209行目) | ○ |
| C-13 | distance < -radius で完全に外側と判定 | E-01 (203-207行目) | ○ |
| C-14 | intersectsBoxメソッドが存在する | E-01 (221-245行目) | ○ |
| C-15 | 平面法線方向の最遠コーナーを選択 | E-01 (231-233行目) | ○ |
| C-16 | containsPointメソッドが存在する | E-01 (253-269行目) | ○ |
| C-17 | cloneメソッドが存在する | E-01 (276-280行目) | ○ |
| C-18 | 無効な座標系でErrorをスロー | E-01 (128行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張がソースコードから直接検証可能。

## 5) リスクフラグ（レビュー観点）

- リスクレベル: 0（低リスク）
- Frustumはレンダリング最適化の重要なクラスだが、実装が明確

## 6) レビュアーチェックリスト（最小）

- [x] 6平面の配置（右・左・上・下・遠・近）が正しく説明されているか
- [x] setFromProjectionMatrixの行列要素展開が正確か
- [x] WebGL/WebGPU座標系の違いが説明されているか
- [x] intersectsSphereの判定ロジック（distance < -radius）が正しいか
- [x] intersectsBoxの最遠コーナー選択が正しく説明されているか
