---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-WebGPURenderer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/renderers/webgpu/WebGPURenderer.js` 1-107行目
- E-02: `src/renderers/common/Renderer.js` 1-300行目（部分読み込み）
- E-03: `src/renderers/webgpu/WebGPUBackend.js`（参照）
- E-04: `src/renderers/webgl-fallback/WebGLBackend.js`（参照）
- E-05: `src/renderers/webgpu/nodes/StandardNodeLibrary.js`（参照）
- E-06: `機能一覧.csv` 14行目
- E-07: `画面機能マッピング.csv` 複数行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Rendererクラスを継承している | E-01 (28行目) | ○ |
| C-02 | WebGPUをプライマリバックエンドとして使用 | E-01 (21-25行目コメント, 62行目) | ○ |
| C-03 | WebGL 2にフォールバック可能 | E-01 (64-70行目) | ○ |
| C-04 | forceWebGLでWebGLバックエンドを強制 | E-01 (56-58行目) | ○ |
| C-05 | フォールバック時にコンソール警告を出力 | E-01 (66行目) | ○ |
| C-06 | StandardNodeLibraryを使用 | E-01 (85行目), E-05 | ○ |
| C-07 | isWebGPURendererフラグがtrueに設定 | E-01 (94行目) | ○ |
| C-08 | THREE_DEVTOOLSにイベント発行 | E-01 (96-100行目) | ○ |
| C-09 | logarithmicDepthBufferオプションをサポート | E-01 (34行目) | ○ |
| C-10 | alphaオプションのデフォルトはtrue | E-01 (35行目), E-02 (96行目) | ○ |
| C-11 | depthオプションのデフォルトはtrue | E-01 (36行目), E-02 (97行目) | ○ |
| C-12 | stencilオプションのデフォルトはfalse | E-01 (37行目), E-02 (98行目) | ○ |
| C-13 | antialiasオプションのデフォルトはfalse | E-01 (38行目), E-02 (99行目) | ○ |
| C-14 | samplesオプションでMSAAサンプル数を設定 | E-01 (39行目) | ○ |
| C-15 | multiviewオプションでWebXRマルチビュー対応 | E-01 (41行目) | ○ |
| C-16 | outputBufferTypeのデフォルトはHalfFloatType | E-01 (43-44行目), E-02 (102行目) | ○ |
| C-17 | Renderer基底クラスでautoClearを管理 | E-02 (121行目) | ○ |
| C-18 | Renderer基底クラスでtoneMappingを管理 | E-02 (180行目) | ○ |
| C-19 | Renderer基底クラスでsortObjectsを管理 | E-02 (201行目) | ○ |
| C-20 | Infoクラスで統計情報を管理 | E-02 (225行目) | ○ |
| C-21 | NodeLibraryでノードマテリアルをサポート | E-02 (244-245行目) | ○ |
| C-22 | 複数の画面で主機能として使用される | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] WebGPURendererとRenderer基底クラスの継承関係が正しく記述されているか確認
- [ ] バックエンド選択とフォールバックの仕組みが正しく説明されているか確認
- [ ] StandardNodeLibraryとの統合が正しく記述されているか確認
- [ ] 画面機能マッピングとの整合性確認
