---
generated_at: 2026-01-27 12:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：141-MathUtils.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/math/MathUtils.js` - MathUtils本体実装（752行）
- E-02: `src/math/MathUtils.js:8-9` - DEG2RAD、RAD2DEG定数定義
- E-03: `src/math/MathUtils.js:3` - _lutルックアップテーブル
- E-04: `src/math/MathUtils.js:17-33` - generateUUID関数実装
- E-05: `src/math/MathUtils.js:43-47` - clamp関数実装
- E-06: `src/math/MathUtils.js:116-120` - lerp関数実装
- E-07: `src/math/MathUtils.js:134-138` - damp関数実装
- E-08: `src/math/MathUtils.js:167-176` - smoothstep関数実装
- E-09: `src/math/MathUtils.js:187-196` - smootherstep関数実装
- E-10: `src/math/MathUtils.js:242-256` - seededRandom関数（Mulberry32）
- E-11: `src/math/MathUtils.js:331-379` - setQuaternionFromProperEuler関数
- E-12: `src/math/MathUtils.js:388-426` - denormalize関数
- E-13: `src/math/MathUtils.js:435-473` - normalize関数
- E-14: `src/math/MathUtils.js:288-292` - isPowerOfTwo関数
- E-15: `src/math/MathUtils.js:300-304` - ceilPowerOfTwo関数
- E-16: `src/math/MathUtils.js:147-153` - pingpong関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DEG2RAD = PI/180、RAD2DEG = 180/PI | E-02 | ○ |
| C-02 | _lutは0x00-0xffの16進数文字列テーブル | E-03 | ○ |
| C-03 | generateUUIDは8-4-4-4-12形式の小文字UUID生成 | E-04 | ○ |
| C-04 | clampはMath.max/minの組み合わせ | E-05 | ○ |
| C-05 | lerpは(1-t)*x + t*yで線形補間 | E-06 | ○ |
| C-06 | dampはlerp + 指数減衰 | E-07 | ○ |
| C-07 | smoothstepは3次多項式x*x*(3-2*x) | E-08 | ○ |
| C-08 | smootherstepは5次多項式で1次・2次微分が境界で0 | E-09 | ○ |
| C-09 | seededRandomはMulberry32アルゴリズム使用 | E-10 | ○ |
| C-10 | setQuaternionFromProperEulerは6種のorder対応 | E-11 | ○ |
| C-11 | denormalizeはTypedArray型に応じた変換 | E-12 | ○ |
| C-12 | normalizeはTypedArray型に応じた変換 | E-13 | ○ |
| C-13 | isPowerOfTwoはビット演算で判定 | E-14 | ○ |
| C-14 | ceilPowerOfTwoは対数計算で算出 | E-15 | ○ |
| C-15 | pingpongはeuclideanModuloを使用 | E-16 | ○ |
| C-16 | 非対応型配列でErrorをスロー | E-12, E-13 | ○ |
| C-17 | 未知のorderでwarn出力 | E-11 | ○ |
| C-18 | 個別関数は名前付きエクスポート可能 | E-01 (725-750行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] DEG2RAD/RAD2DEG定数値の正確性確認
- [ ] seededRandomの決定性テスト
- [ ] normalize/denormalizeの型対応の網羅性確認
- [ ] setQuaternionFromProperEulerの数学的正確性確認
