---
generated_at: 2026-01-27 12:41:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：147-BezierInterpolant.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/math/interpolants/BezierInterpolant.js` - BezierInterpolant本体実装（109行）
- E-02: `src/math/interpolants/BezierInterpolant.js:3-19` - クラスドキュメント
- E-03: `src/math/interpolants/BezierInterpolant.js:10-17` - タンジェントレイアウト説明
- E-04: `src/math/interpolants/BezierInterpolant.js:37-50` - 線形補間フォールバック
- E-05: `src/math/interpolants/BezierInterpolant.js:55-68` - タンジェント取得
- E-06: `src/math/interpolants/BezierInterpolant.js:71` - 初期s推定
- E-07: `src/math/interpolants/BezierInterpolant.js:74-95` - Newton-Raphson反復
- E-08: `src/math/interpolants/BezierInterpolant.js:86` - 収束判定（1e-10）
- E-09: `src/math/interpolants/BezierInterpolant.js:93` - sのクランプ処理
- E-10: `src/math/interpolants/BezierInterpolant.js:98` - ベジェY評価

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Interpolantクラスを継承 | E-01 (21行目) | ○ |
| C-02 | COLLADA/Maya形式の2Dタンジェントに対応 | E-02 | ○ |
| C-03 | タンジェントレイアウトはN*S*2要素 | E-03 | ○ |
| C-04 | タンジェントなしの場合は線形補間にフォールバック | E-04 | ○ |
| C-05 | outTangentは前キーフレームから取得 | E-05 (61-63行目) | ○ |
| C-06 | inTangentは現キーフレームから取得 | E-05 (66-68行目) | ○ |
| C-07 | 初期sは線形補間と同じ推定値 | E-06 | ○ |
| C-08 | Newton-Raphson法で最大8回反復 | E-07 (74行目) | ○ |
| C-09 | 収束判定は誤差<1e-10 | E-08 | ○ |
| C-10 | sを[0,1]にクランプ | E-09 | ○ |
| C-11 | 3次ベジェ曲線でY(s)を評価 | E-10 | ○ |
| C-12 | 導関数dBx/dsを使用して更新 | E-07 (89-90行目) | ○ |
| C-13 | 各成分ごとに独立して補間 | E-01 (55行目ループ) | ○ |
| C-14 | resultBufferを返却 | E-01 (102行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで検証済み
- Newton-Raphson法の収束性は入力データに依存する可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 3次ベジェ曲線の数式が正しいことを確認
- [ ] Newton-Raphson法の導関数が正しいことを確認
- [ ] 極端なタンジェント値での収束性テスト
- [ ] COLLADALoaderとの連携動作確認
