---
generated_at: 2026-01-27 12:44:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：150-ArrowHelper.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/helpers/ArrowHelper.js` - ArrowHelper本体実装（172行）
- E-02: `src/helpers/ArrowHelper.js:1-9` - インポート文
- E-03: `src/helpers/ArrowHelper.js:11-12` - _axis、_lineGeometry、_coneGeometry定義
- E-04: `src/helpers/ArrowHelper.js:33` - extends Object3D
- E-05: `src/helpers/ArrowHelper.js:45` - コンストラクタのデフォルト引数
- E-06: `src/helpers/ArrowHelper.js:51-59` - ジオメトリ遅延初期化
- E-07: `src/helpers/ArrowHelper.js:61` - position.copy(origin)
- E-08: `src/helpers/ArrowHelper.js:68-70` - Line作成とmatrixAutoUpdate
- E-09: `src/helpers/ArrowHelper.js:77-79` - Mesh作成とmatrixAutoUpdate
- E-10: `src/helpers/ArrowHelper.js:91-113` - setDirectionメソッド
- E-11: `src/helpers/ArrowHelper.js:122-131` - setLengthメソッド
- E-12: `src/helpers/ArrowHelper.js:138-142` - setColorメソッド
- E-13: `src/helpers/ArrowHelper.js:160-167` - disposeメソッド
- E-14: `src/helpers/ArrowHelper.js:68` - toneMapped: false

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Object3Dを継承 | E-04 | ○ |
| C-02 | デフォルト方向は(0,0,1) | E-05 | ○ |
| C-03 | デフォルト色は0xffff00（黄色） | E-05 | ○ |
| C-04 | _lineGeometryと_coneGeometryを共有 | E-03, E-06 | ○ |
| C-05 | 遅延初期化で初回のみジオメトリ作成 | E-06 | ○ |
| C-06 | position.copy(origin)で位置設定 | E-07 | ○ |
| C-07 | matrixAutoUpdate = falseを設定 | E-08, E-09 | ○ |
| C-08 | toneMapped: falseを設定 | E-14 | ○ |
| C-09 | setDirectionで四元数を設定 | E-10 | ○ |
| C-10 | dir.y > 0.99999で特殊処理（真上） | E-10 (95-97行目) | ○ |
| C-11 | dir.y < -0.99999で特殊処理（真下） | E-10 (99-101行目) | ○ |
| C-12 | setLengthでスケーリング | E-11 | ○ |
| C-13 | line.scale.yの最小値は0.0001 | E-11 (124行目) | ○ |
| C-14 | cone.position.y = lengthで位置設定 | E-11 (128行目) | ○ |
| C-15 | setColorで両マテリアルの色を変更 | E-12 | ○ |
| C-16 | dispose()でリソース解放 | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] 方向ベクトルが非正規化の場合の動作確認
- [ ] 極端に小さい/大きいlengthでの表示確認
- [ ] dispose()後の再利用でエラーが発生しないことを確認
- [ ] 多数のArrowHelper描画時のパフォーマンス確認
