---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：156-PlaneHelper

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/helpers/PlaneHelper.js` 1-97行目（メイン実装）
- E-02: `src/math/Plane.js`（数学的平面）
- E-03: `src/objects/Line.js`（親クラス実装）
- E-04: `src/objects/Mesh.js`（子要素メッシュ）
- E-05: `src/core/BufferGeometry.js`（ジオメトリ管理）
- E-06: `src/materials/LineBasicMaterial.js`（線マテリアル）
- E-07: `src/materials/MeshBasicMaterial.js`（メッシュマテリアル）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PlaneHelperはLineを継承 | E-01 (19行目: `class PlaneHelper extends Line`) | ○ |
| C-02 | デフォルトsizeは1 | E-01 (28行目: `size = 1`) | ○ |
| C-03 | デフォルトhexは0xffff00 | E-01 (28行目: `hex = 0xffff00`) | ○ |
| C-04 | ワイヤーフレームは8頂点 | E-01 (32行目: positions配列に8×3要素) | ○ |
| C-05 | toneMappedはfalse | E-01 (38行目: `toneMapped: false`) | ○ |
| C-06 | typeは'PlaneHelper' | E-01 (40行目: `this.type = 'PlaneHelper'`) | ○ |
| C-07 | planeプロパティに参照保存 | E-01 (47行目: `this.plane = plane`) | ○ |
| C-08 | sizeプロパティ保存 | E-01 (55行目: `this.size = size`) | ○ |
| C-09 | 半透明メッシュ用頂点は6頂点 | E-01 (57行目: positions2配列) | ○ |
| C-10 | メッシュのopacityは0.2 | E-01 (63行目: `opacity: 0.2`) | ○ |
| C-11 | メッシュはtransparent: true | E-01 (63行目: `transparent: true`) | ○ |
| C-12 | メッシュはdepthWrite: false | E-01 (63行目: `depthWrite: false`) | ○ |
| C-13 | this.add()で子要素追加 | E-01 (63行目: `this.add( new Mesh(...) )`) | ○ |
| C-14 | updateMatrixWorldをオーバーライド | E-01 (67行目: `updateMatrixWorld( force )`) | ○ |
| C-15 | position.set(0,0,0)で原点配置 | E-01 (69行目: `this.position.set( 0, 0, 0 )`) | ○ |
| C-16 | scale設定: size/2 | E-01 (71行目: `this.scale.set( 0.5 * this.size, 0.5 * this.size, 1 )`) | ○ |
| C-17 | lookAtでplane.normalを向く | E-01 (73行目: `this.lookAt( this.plane.normal )`) | ○ |
| C-18 | translateZで-plane.constant移動 | E-01 (75行目: `this.translateZ( - this.plane.constant )`) | ○ |
| C-19 | 親クラスupdateMatrixWorld呼出 | E-01 (77行目: `super.updateMatrixWorld( force )`) | ○ |
| C-20 | disposeでgeometry/material解放 | E-01 (87-88行目) | ○ |
| C-21 | dispose時に子要素も解放 | E-01 (89-90行目: `this.children[0].geometry/material.dispose()`) | ○ |
| C-22 | 機能名はPlaneHelperである | E-08 (157行目: `"156","ヘルパー","PlaneHelper"`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [x] クラス継承関係（Line継承）が正しく記載されているか
- [x] コンストラクタパラメータとデフォルト値が正確か
- [x] ワイヤーフレームと半透明メッシュの構造が正確か
- [x] updateMatrixWorldのロジック（lookAt, translateZ）が正確か
- [x] disposeが子要素も含めて解放しているか
